/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a policy for application-controlled session stickiness.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppCookieStickinessPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<AppCookieStickinessPolicy.Builder, AppCookieStickinessPolicy> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(AppCookieStickinessPolicy::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> COOKIE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CookieName").getter(getter(AppCookieStickinessPolicy::cookieName)).setter(setter(Builder::cookieName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CookieName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            COOKIE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyName;

    private final String cookieName;

    private AppCookieStickinessPolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.cookieName = builder.cookieName;
    }

    /**
     * <p>
     * The mnemonic name for the policy being created. The name must be unique within a set of policies for this load
     * balancer.
     * </p>
     * 
     * @return The mnemonic name for the policy being created. The name must be unique within a set of policies for this
     *         load balancer.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The name of the application cookie used for stickiness.
     * </p>
     * 
     * @return The name of the application cookie used for stickiness.
     */
    public final String cookieName() {
        return cookieName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(cookieName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppCookieStickinessPolicy)) {
            return false;
        }
        AppCookieStickinessPolicy other = (AppCookieStickinessPolicy) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(cookieName(), other.cookieName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppCookieStickinessPolicy").add("PolicyName", policyName()).add("CookieName", cookieName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "CookieName":
            return Optional.ofNullable(clazz.cast(cookieName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppCookieStickinessPolicy, T> g) {
        return obj -> g.apply((AppCookieStickinessPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppCookieStickinessPolicy> {
        /**
         * <p>
         * The mnemonic name for the policy being created. The name must be unique within a set of policies for this
         * load balancer.
         * </p>
         * 
         * @param policyName
         *        The mnemonic name for the policy being created. The name must be unique within a set of policies for
         *        this load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The name of the application cookie used for stickiness.
         * </p>
         * 
         * @param cookieName
         *        The name of the application cookie used for stickiness.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookieName(String cookieName);
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private String cookieName;

        private BuilderImpl() {
        }

        private BuilderImpl(AppCookieStickinessPolicy model) {
            policyName(model.policyName);
            cookieName(model.cookieName);
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        @Transient
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getCookieName() {
            return cookieName;
        }

        public final void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        @Override
        @Transient
        public final Builder cookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        @Override
        public AppCookieStickinessPolicy build() {
            return new AppCookieStickinessPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
