/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The policies for a load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Policies implements SdkPojo, Serializable, ToCopyableBuilder<Policies.Builder, Policies> {
    private static final SdkField<List<AppCookieStickinessPolicy>> APP_COOKIE_STICKINESS_POLICIES_FIELD = SdkField
            .<List<AppCookieStickinessPolicy>> builder(MarshallingType.LIST)
            .memberName("AppCookieStickinessPolicies")
            .getter(getter(Policies::appCookieStickinessPolicies))
            .setter(setter(Builder::appCookieStickinessPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppCookieStickinessPolicies")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppCookieStickinessPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppCookieStickinessPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LBCookieStickinessPolicy>> LB_COOKIE_STICKINESS_POLICIES_FIELD = SdkField
            .<List<LBCookieStickinessPolicy>> builder(MarshallingType.LIST)
            .memberName("LBCookieStickinessPolicies")
            .getter(getter(Policies::lbCookieStickinessPolicies))
            .setter(setter(Builder::lbCookieStickinessPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LBCookieStickinessPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LBCookieStickinessPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(LBCookieStickinessPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OTHER_POLICIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OtherPolicies")
            .getter(getter(Policies::otherPolicies))
            .setter(setter(Builder::otherPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APP_COOKIE_STICKINESS_POLICIES_FIELD, LB_COOKIE_STICKINESS_POLICIES_FIELD, OTHER_POLICIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AppCookieStickinessPolicy> appCookieStickinessPolicies;

    private final List<LBCookieStickinessPolicy> lbCookieStickinessPolicies;

    private final List<String> otherPolicies;

    private Policies(BuilderImpl builder) {
        this.appCookieStickinessPolicies = builder.appCookieStickinessPolicies;
        this.lbCookieStickinessPolicies = builder.lbCookieStickinessPolicies;
        this.otherPolicies = builder.otherPolicies;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppCookieStickinessPolicies property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAppCookieStickinessPolicies() {
        return appCookieStickinessPolicies != null && !(appCookieStickinessPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppCookieStickinessPolicies} method.
     * </p>
     * 
     * @return The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
     */
    public final List<AppCookieStickinessPolicy> appCookieStickinessPolicies() {
        return appCookieStickinessPolicies;
    }

    /**
     * For responses, this returns true if the service returned a value for the LBCookieStickinessPolicies property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLbCookieStickinessPolicies() {
        return lbCookieStickinessPolicies != null && !(lbCookieStickinessPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLbCookieStickinessPolicies} method.
     * </p>
     * 
     * @return The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
     */
    public final List<LBCookieStickinessPolicy> lbCookieStickinessPolicies() {
        return lbCookieStickinessPolicies;
    }

    /**
     * For responses, this returns true if the service returned a value for the OtherPolicies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOtherPolicies() {
        return otherPolicies != null && !(otherPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The policies other than the stickiness policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOtherPolicies} method.
     * </p>
     * 
     * @return The policies other than the stickiness policies.
     */
    public final List<String> otherPolicies() {
        return otherPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAppCookieStickinessPolicies() ? appCookieStickinessPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLbCookieStickinessPolicies() ? lbCookieStickinessPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOtherPolicies() ? otherPolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policies)) {
            return false;
        }
        Policies other = (Policies) obj;
        return hasAppCookieStickinessPolicies() == other.hasAppCookieStickinessPolicies()
                && Objects.equals(appCookieStickinessPolicies(), other.appCookieStickinessPolicies())
                && hasLbCookieStickinessPolicies() == other.hasLbCookieStickinessPolicies()
                && Objects.equals(lbCookieStickinessPolicies(), other.lbCookieStickinessPolicies())
                && hasOtherPolicies() == other.hasOtherPolicies() && Objects.equals(otherPolicies(), other.otherPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Policies")
                .add("AppCookieStickinessPolicies", hasAppCookieStickinessPolicies() ? appCookieStickinessPolicies() : null)
                .add("LBCookieStickinessPolicies", hasLbCookieStickinessPolicies() ? lbCookieStickinessPolicies() : null)
                .add("OtherPolicies", hasOtherPolicies() ? otherPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppCookieStickinessPolicies":
            return Optional.ofNullable(clazz.cast(appCookieStickinessPolicies()));
        case "LBCookieStickinessPolicies":
            return Optional.ofNullable(clazz.cast(lbCookieStickinessPolicies()));
        case "OtherPolicies":
            return Optional.ofNullable(clazz.cast(otherPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Policies, T> g) {
        return obj -> g.apply((Policies) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Policies> {
        /**
         * <p>
         * The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
         * </p>
         * 
         * @param appCookieStickinessPolicies
         *        The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appCookieStickinessPolicies(Collection<AppCookieStickinessPolicy> appCookieStickinessPolicies);

        /**
         * <p>
         * The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
         * </p>
         * 
         * @param appCookieStickinessPolicies
         *        The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appCookieStickinessPolicies(AppCookieStickinessPolicy... appCookieStickinessPolicies);

        /**
         * <p>
         * The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AppCookieStickinessPolicy>.Builder}
         * avoiding the need to create one manually via {@link List<AppCookieStickinessPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AppCookieStickinessPolicy>.Builder#build()} is called
         * immediately and its result is passed to {@link #appCookieStickinessPolicies(List<AppCookieStickinessPolicy>)}
         * .
         * 
         * @param appCookieStickinessPolicies
         *        a consumer that will call methods on {@link List<AppCookieStickinessPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appCookieStickinessPolicies(List<AppCookieStickinessPolicy>)
         */
        Builder appCookieStickinessPolicies(Consumer<AppCookieStickinessPolicy.Builder>... appCookieStickinessPolicies);

        /**
         * <p>
         * The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
         * </p>
         * 
         * @param lbCookieStickinessPolicies
         *        The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lbCookieStickinessPolicies(Collection<LBCookieStickinessPolicy> lbCookieStickinessPolicies);

        /**
         * <p>
         * The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
         * </p>
         * 
         * @param lbCookieStickinessPolicies
         *        The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lbCookieStickinessPolicies(LBCookieStickinessPolicy... lbCookieStickinessPolicies);

        /**
         * <p>
         * The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LBCookieStickinessPolicy>.Builder} avoiding
         * the need to create one manually via {@link List<LBCookieStickinessPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LBCookieStickinessPolicy>.Builder#build()} is called
         * immediately and its result is passed to {@link #lbCookieStickinessPolicies(List<LBCookieStickinessPolicy>)}.
         * 
         * @param lbCookieStickinessPolicies
         *        a consumer that will call methods on {@link List<LBCookieStickinessPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lbCookieStickinessPolicies(List<LBCookieStickinessPolicy>)
         */
        Builder lbCookieStickinessPolicies(Consumer<LBCookieStickinessPolicy.Builder>... lbCookieStickinessPolicies);

        /**
         * <p>
         * The policies other than the stickiness policies.
         * </p>
         * 
         * @param otherPolicies
         *        The policies other than the stickiness policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherPolicies(Collection<String> otherPolicies);

        /**
         * <p>
         * The policies other than the stickiness policies.
         * </p>
         * 
         * @param otherPolicies
         *        The policies other than the stickiness policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherPolicies(String... otherPolicies);
    }

    static final class BuilderImpl implements Builder {
        private List<AppCookieStickinessPolicy> appCookieStickinessPolicies = DefaultSdkAutoConstructList.getInstance();

        private List<LBCookieStickinessPolicy> lbCookieStickinessPolicies = DefaultSdkAutoConstructList.getInstance();

        private List<String> otherPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Policies model) {
            appCookieStickinessPolicies(model.appCookieStickinessPolicies);
            lbCookieStickinessPolicies(model.lbCookieStickinessPolicies);
            otherPolicies(model.otherPolicies);
        }

        public final List<AppCookieStickinessPolicy.Builder> getAppCookieStickinessPolicies() {
            List<AppCookieStickinessPolicy.Builder> result = AppCookieStickinessPoliciesCopier
                    .copyToBuilder(this.appCookieStickinessPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppCookieStickinessPolicies(
                Collection<AppCookieStickinessPolicy.BuilderImpl> appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies = AppCookieStickinessPoliciesCopier.copyFromBuilder(appCookieStickinessPolicies);
        }

        @Override
        @Transient
        public final Builder appCookieStickinessPolicies(Collection<AppCookieStickinessPolicy> appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies = AppCookieStickinessPoliciesCopier.copy(appCookieStickinessPolicies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appCookieStickinessPolicies(AppCookieStickinessPolicy... appCookieStickinessPolicies) {
            appCookieStickinessPolicies(Arrays.asList(appCookieStickinessPolicies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appCookieStickinessPolicies(
                Consumer<AppCookieStickinessPolicy.Builder>... appCookieStickinessPolicies) {
            appCookieStickinessPolicies(Stream.of(appCookieStickinessPolicies)
                    .map(c -> AppCookieStickinessPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LBCookieStickinessPolicy.Builder> getLbCookieStickinessPolicies() {
            List<LBCookieStickinessPolicy.Builder> result = LBCookieStickinessPoliciesCopier
                    .copyToBuilder(this.lbCookieStickinessPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLbCookieStickinessPolicies(
                Collection<LBCookieStickinessPolicy.BuilderImpl> lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies = LBCookieStickinessPoliciesCopier.copyFromBuilder(lbCookieStickinessPolicies);
        }

        @Override
        @Transient
        public final Builder lbCookieStickinessPolicies(Collection<LBCookieStickinessPolicy> lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies = LBCookieStickinessPoliciesCopier.copy(lbCookieStickinessPolicies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lbCookieStickinessPolicies(LBCookieStickinessPolicy... lbCookieStickinessPolicies) {
            lbCookieStickinessPolicies(Arrays.asList(lbCookieStickinessPolicies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lbCookieStickinessPolicies(Consumer<LBCookieStickinessPolicy.Builder>... lbCookieStickinessPolicies) {
            lbCookieStickinessPolicies(Stream.of(lbCookieStickinessPolicies)
                    .map(c -> LBCookieStickinessPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getOtherPolicies() {
            if (otherPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return otherPolicies;
        }

        public final void setOtherPolicies(Collection<String> otherPolicies) {
            this.otherPolicies = PolicyNamesCopier.copy(otherPolicies);
        }

        @Override
        @Transient
        public final Builder otherPolicies(Collection<String> otherPolicies) {
            this.otherPolicies = PolicyNamesCopier.copy(otherPolicies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder otherPolicies(String... otherPolicies) {
            otherPolicies(Arrays.asList(otherPolicies));
            return this;
        }

        @Override
        public Policies build() {
            return new Policies(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
