/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for response returned by <code> <a>GetPackageVersionHistory</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPackageVersionHistoryResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<GetPackageVersionHistoryResponse.Builder, GetPackageVersionHistoryResponse> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageID").getter(getter(GetPackageVersionHistoryResponse::packageID))
            .setter(setter(Builder::packageID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()).build();

    private static final SdkField<List<PackageVersionHistory>> PACKAGE_VERSION_HISTORY_LIST_FIELD = SdkField
            .<List<PackageVersionHistory>> builder(MarshallingType.LIST)
            .memberName("PackageVersionHistoryList")
            .getter(getter(GetPackageVersionHistoryResponse::packageVersionHistoryList))
            .setter(setter(Builder::packageVersionHistoryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersionHistoryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageVersionHistory> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageVersionHistory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetPackageVersionHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD,
            PACKAGE_VERSION_HISTORY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final String packageID;

    private final List<PackageVersionHistory> packageVersionHistoryList;

    private final String nextToken;

    private GetPackageVersionHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.packageID = builder.packageID;
        this.packageVersionHistoryList = builder.packageVersionHistoryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the PackageID property for this object.
     * 
     * @return The value of the PackageID property for this object.
     */
    public final String packageID() {
        return packageID;
    }

    /**
     * For responses, this returns true if the service returned a value for the PackageVersionHistoryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPackageVersionHistoryList() {
        return packageVersionHistoryList != null && !(packageVersionHistoryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of <code>PackageVersionHistory</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPackageVersionHistoryList} method.
     * </p>
     * 
     * @return List of <code>PackageVersionHistory</code> objects.
     */
    public final List<PackageVersionHistory> packageVersionHistoryList() {
        return packageVersionHistoryList;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageID());
        hashCode = 31 * hashCode + Objects.hashCode(hasPackageVersionHistoryList() ? packageVersionHistoryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPackageVersionHistoryResponse)) {
            return false;
        }
        GetPackageVersionHistoryResponse other = (GetPackageVersionHistoryResponse) obj;
        return Objects.equals(packageID(), other.packageID())
                && hasPackageVersionHistoryList() == other.hasPackageVersionHistoryList()
                && Objects.equals(packageVersionHistoryList(), other.packageVersionHistoryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPackageVersionHistoryResponse").add("PackageID", packageID())
                .add("PackageVersionHistoryList", hasPackageVersionHistoryList() ? packageVersionHistoryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageID":
            return Optional.ofNullable(clazz.cast(packageID()));
        case "PackageVersionHistoryList":
            return Optional.ofNullable(clazz.cast(packageVersionHistoryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPackageVersionHistoryResponse, T> g) {
        return obj -> g.apply((GetPackageVersionHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPackageVersionHistoryResponse> {
        /**
         * Sets the value of the PackageID property for this object.
         *
         * @param packageID
         *        The new value for the PackageID property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageID(String packageID);

        /**
         * <p>
         * List of <code>PackageVersionHistory</code> objects.
         * </p>
         * 
         * @param packageVersionHistoryList
         *        List of <code>PackageVersionHistory</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersionHistoryList(Collection<PackageVersionHistory> packageVersionHistoryList);

        /**
         * <p>
         * List of <code>PackageVersionHistory</code> objects.
         * </p>
         * 
         * @param packageVersionHistoryList
         *        List of <code>PackageVersionHistory</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersionHistoryList(PackageVersionHistory... packageVersionHistoryList);

        /**
         * <p>
         * List of <code>PackageVersionHistory</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PackageVersionHistory>.Builder} avoiding
         * the need to create one manually via {@link List<PackageVersionHistory>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PackageVersionHistory>.Builder#build()} is called
         * immediately and its result is passed to {@link #packageVersionHistoryList(List<PackageVersionHistory>)}.
         * 
         * @param packageVersionHistoryList
         *        a consumer that will call methods on {@link List<PackageVersionHistory>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageVersionHistoryList(List<PackageVersionHistory>)
         */
        Builder packageVersionHistoryList(Consumer<PackageVersionHistory.Builder>... packageVersionHistoryList);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private String packageID;

        private List<PackageVersionHistory> packageVersionHistoryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPackageVersionHistoryResponse model) {
            super(model);
            packageID(model.packageID);
            packageVersionHistoryList(model.packageVersionHistoryList);
            nextToken(model.nextToken);
        }

        public final String getPackageID() {
            return packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        @Transient
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final List<PackageVersionHistory.Builder> getPackageVersionHistoryList() {
            List<PackageVersionHistory.Builder> result = PackageVersionHistoryListCopier
                    .copyToBuilder(this.packageVersionHistoryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackageVersionHistoryList(Collection<PackageVersionHistory.BuilderImpl> packageVersionHistoryList) {
            this.packageVersionHistoryList = PackageVersionHistoryListCopier.copyFromBuilder(packageVersionHistoryList);
        }

        @Override
        @Transient
        public final Builder packageVersionHistoryList(Collection<PackageVersionHistory> packageVersionHistoryList) {
            this.packageVersionHistoryList = PackageVersionHistoryListCopier.copy(packageVersionHistoryList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder packageVersionHistoryList(PackageVersionHistory... packageVersionHistoryList) {
            packageVersionHistoryList(Arrays.asList(packageVersionHistoryList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder packageVersionHistoryList(Consumer<PackageVersionHistory.Builder>... packageVersionHistoryList) {
            packageVersionHistoryList(Stream.of(packageVersionHistoryList)
                    .map(c -> PackageVersionHistory.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetPackageVersionHistoryResponse build() {
            return new GetPackageVersionHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
