/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the zone awareness configuration for the domain cluster, such as the number of availability zones.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ZoneAwarenessConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ZoneAwarenessConfig.Builder, ZoneAwarenessConfig> {
    private static final SdkField<Integer> AVAILABILITY_ZONE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailabilityZoneCount").getter(getter(ZoneAwarenessConfig::availabilityZoneCount))
            .setter(setter(Builder::availabilityZoneCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer availabilityZoneCount;

    private ZoneAwarenessConfig(BuilderImpl builder) {
        this.availabilityZoneCount = builder.availabilityZoneCount;
    }

    /**
     * <p>
     * An integer value to indicate the number of availability zones for a domain when zone awareness is enabled. This
     * should be equal to number of subnets if VPC endpoints is enabled
     * </p>
     * 
     * @return An integer value to indicate the number of availability zones for a domain when zone awareness is
     *         enabled. This should be equal to number of subnets if VPC endpoints is enabled
     */
    public final Integer availabilityZoneCount() {
        return availabilityZoneCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZoneAwarenessConfig)) {
            return false;
        }
        ZoneAwarenessConfig other = (ZoneAwarenessConfig) obj;
        return Objects.equals(availabilityZoneCount(), other.availabilityZoneCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ZoneAwarenessConfig").add("AvailabilityZoneCount", availabilityZoneCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZoneCount":
            return Optional.ofNullable(clazz.cast(availabilityZoneCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ZoneAwarenessConfig, T> g) {
        return obj -> g.apply((ZoneAwarenessConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ZoneAwarenessConfig> {
        /**
         * <p>
         * An integer value to indicate the number of availability zones for a domain when zone awareness is enabled.
         * This should be equal to number of subnets if VPC endpoints is enabled
         * </p>
         * 
         * @param availabilityZoneCount
         *        An integer value to indicate the number of availability zones for a domain when zone awareness is
         *        enabled. This should be equal to number of subnets if VPC endpoints is enabled
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneCount(Integer availabilityZoneCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer availabilityZoneCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ZoneAwarenessConfig model) {
            availabilityZoneCount(model.availabilityZoneCount);
        }

        public final Integer getAvailabilityZoneCount() {
            return availabilityZoneCount;
        }

        public final void setAvailabilityZoneCount(Integer availabilityZoneCount) {
            this.availabilityZoneCount = availabilityZoneCount;
        }

        @Override
        @Transient
        public final Builder availabilityZoneCount(Integer availabilityZoneCount) {
            this.availabilityZoneCount = availabilityZoneCount;
            return this;
        }

        @Override
        public ZoneAwarenessConfig build() {
            return new ZoneAwarenessConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
