/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrserverless.model.ApplicationState;
import software.amazon.awssdk.services.emrserverless.model.Architecture;
import software.amazon.awssdk.services.emrserverless.model.AutoStartConfig;
import software.amazon.awssdk.services.emrserverless.model.AutoStopConfig;
import software.amazon.awssdk.services.emrserverless.model.InitialCapacityConfig;
import software.amazon.awssdk.services.emrserverless.model.InitialCapacityConfigMapCopier;
import software.amazon.awssdk.services.emrserverless.model.MaximumAllowedResources;
import software.amazon.awssdk.services.emrserverless.model.NetworkConfiguration;
import software.amazon.awssdk.services.emrserverless.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Application
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Application> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(Application.getter(Application::applicationId)).setter(Application.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Application.getter(Application::name)).setter(Application.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Application.getter(Application::arn)).setter(Application.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(Application.getter(Application::releaseLabel)).setter(Application.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Application.getter(Application::type)).setter(Application.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Application.getter(Application::stateAsString)).setter(Application.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateDetails").getter(Application.getter(Application::stateDetails)).setter(Application.setter(Builder::stateDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDetails").build()}).build();
    private static final SdkField<Map<String, InitialCapacityConfig>> INITIAL_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("initialCapacity").getter(Application.getter(Application::initialCapacity)).setter(Application.setter(Builder::initialCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialCapacity").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InitialCapacityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<MaximumAllowedResources> MAXIMUM_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maximumCapacity").getter(Application.getter(Application::maximumCapacity)).setter(Application.setter(Builder::maximumCapacity)).constructor(MaximumAllowedResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumCapacity").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Application.getter(Application::createdAt)).setter(Application.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Application.getter(Application::updatedAt)).setter(Application.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Application.getter(Application::tags)).setter(Application.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AutoStartConfig> AUTO_START_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoStartConfiguration").getter(Application.getter(Application::autoStartConfiguration)).setter(Application.setter(Builder::autoStartConfiguration)).constructor(AutoStartConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoStartConfiguration").build()}).build();
    private static final SdkField<AutoStopConfig> AUTO_STOP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoStopConfiguration").getter(Application.getter(Application::autoStopConfiguration)).setter(Application.setter(Builder::autoStopConfiguration)).constructor(AutoStopConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoStopConfiguration").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(Application.getter(Application::networkConfiguration)).setter(Application.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("architecture").getter(Application.getter(Application::architectureAsString)).setter(Application.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, NAME_FIELD, ARN_FIELD, RELEASE_LABEL_FIELD, TYPE_FIELD, STATE_FIELD, STATE_DETAILS_FIELD, INITIAL_CAPACITY_FIELD, MAXIMUM_CAPACITY_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, TAGS_FIELD, AUTO_START_CONFIGURATION_FIELD, AUTO_STOP_CONFIGURATION_FIELD, NETWORK_CONFIGURATION_FIELD, ARCHITECTURE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String name;
    private final String arn;
    private final String releaseLabel;
    private final String type;
    private final String state;
    private final String stateDetails;
    private final Map<String, InitialCapacityConfig> initialCapacity;
    private final MaximumAllowedResources maximumCapacity;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Map<String, String> tags;
    private final AutoStartConfig autoStartConfiguration;
    private final AutoStopConfig autoStopConfiguration;
    private final NetworkConfiguration networkConfiguration;
    private final String architecture;

    private Application(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.releaseLabel = builder.releaseLabel;
        this.type = builder.type;
        this.state = builder.state;
        this.stateDetails = builder.stateDetails;
        this.initialCapacity = builder.initialCapacity;
        this.maximumCapacity = builder.maximumCapacity;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.tags = builder.tags;
        this.autoStartConfiguration = builder.autoStartConfiguration;
        this.autoStopConfiguration = builder.autoStopConfiguration;
        this.networkConfiguration = builder.networkConfiguration;
        this.architecture = builder.architecture;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final String type() {
        return this.type;
    }

    public final ApplicationState state() {
        return ApplicationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateDetails() {
        return this.stateDetails;
    }

    public final boolean hasInitialCapacity() {
        return this.initialCapacity != null && !(this.initialCapacity instanceof SdkAutoConstructMap);
    }

    public final Map<String, InitialCapacityConfig> initialCapacity() {
        return this.initialCapacity;
    }

    public final MaximumAllowedResources maximumCapacity() {
        return this.maximumCapacity;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final AutoStartConfig autoStartConfiguration() {
        return this.autoStartConfiguration;
    }

    public final AutoStopConfig autoStopConfiguration() {
        return this.autoStopConfiguration;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final Architecture architecture() {
        return Architecture.fromValue(this.architecture);
    }

    public final String architectureAsString() {
        return this.architecture;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInitialCapacity() ? this.initialCapacity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoStartConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoStopConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateDetails(), other.stateDetails()) && this.hasInitialCapacity() == other.hasInitialCapacity() && Objects.equals(this.initialCapacity(), other.initialCapacity()) && Objects.equals(this.maximumCapacity(), other.maximumCapacity()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.autoStartConfiguration(), other.autoStartConfiguration()) && Objects.equals(this.autoStopConfiguration(), other.autoStopConfiguration()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.architectureAsString(), other.architectureAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Application").add("ApplicationId", (Object)this.applicationId()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("ReleaseLabel", (Object)this.releaseLabel()).add("Type", (Object)this.type()).add("State", (Object)this.stateAsString()).add("StateDetails", (Object)this.stateDetails()).add("InitialCapacity", this.hasInitialCapacity() ? this.initialCapacity() : null).add("MaximumCapacity", (Object)this.maximumCapacity()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Tags", this.hasTags() ? this.tags() : null).add("AutoStartConfiguration", (Object)this.autoStartConfiguration()).add("AutoStopConfiguration", (Object)this.autoStopConfiguration()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("Architecture", (Object)this.architectureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "stateDetails": {
                return Optional.ofNullable(clazz.cast(this.stateDetails()));
            }
            case "initialCapacity": {
                return Optional.ofNullable(clazz.cast(this.initialCapacity()));
            }
            case "maximumCapacity": {
                return Optional.ofNullable(clazz.cast(this.maximumCapacity()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "autoStartConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoStartConfiguration()));
            }
            case "autoStopConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoStopConfiguration()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architectureAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Application, T> g) {
        return obj -> g.apply((Application)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String name;
        private String arn;
        private String releaseLabel;
        private String type;
        private String state;
        private String stateDetails;
        private Map<String, InitialCapacityConfig> initialCapacity = DefaultSdkAutoConstructMap.getInstance();
        private MaximumAllowedResources maximumCapacity;
        private Instant createdAt;
        private Instant updatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private AutoStartConfig autoStartConfiguration;
        private AutoStopConfig autoStopConfiguration;
        private NetworkConfiguration networkConfiguration;
        private String architecture;

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            this.applicationId(model.applicationId);
            this.name(model.name);
            this.arn(model.arn);
            this.releaseLabel(model.releaseLabel);
            this.type(model.type);
            this.state(model.state);
            this.stateDetails(model.stateDetails);
            this.initialCapacity(model.initialCapacity);
            this.maximumCapacity(model.maximumCapacity);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.tags(model.tags);
            this.autoStartConfiguration(model.autoStartConfiguration);
            this.autoStopConfiguration(model.autoStopConfiguration);
            this.networkConfiguration(model.networkConfiguration);
            this.architecture(model.architecture);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ApplicationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateDetails() {
            return this.stateDetails;
        }

        public final void setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
        }

        @Override
        public final Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        public final Map<String, InitialCapacityConfig.Builder> getInitialCapacity() {
            Map<String, InitialCapacityConfig.Builder> result = InitialCapacityConfigMapCopier.copyToBuilder(this.initialCapacity);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInitialCapacity(Map<String, InitialCapacityConfig.BuilderImpl> initialCapacity) {
            this.initialCapacity = InitialCapacityConfigMapCopier.copyFromBuilder(initialCapacity);
        }

        @Override
        public final Builder initialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
            this.initialCapacity = InitialCapacityConfigMapCopier.copy(initialCapacity);
            return this;
        }

        public final MaximumAllowedResources.Builder getMaximumCapacity() {
            return this.maximumCapacity != null ? this.maximumCapacity.toBuilder() : null;
        }

        public final void setMaximumCapacity(MaximumAllowedResources.BuilderImpl maximumCapacity) {
            this.maximumCapacity = maximumCapacity != null ? maximumCapacity.build() : null;
        }

        @Override
        public final Builder maximumCapacity(MaximumAllowedResources maximumCapacity) {
            this.maximumCapacity = maximumCapacity;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final AutoStartConfig.Builder getAutoStartConfiguration() {
            return this.autoStartConfiguration != null ? this.autoStartConfiguration.toBuilder() : null;
        }

        public final void setAutoStartConfiguration(AutoStartConfig.BuilderImpl autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration != null ? autoStartConfiguration.build() : null;
        }

        @Override
        public final Builder autoStartConfiguration(AutoStartConfig autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration;
            return this;
        }

        public final AutoStopConfig.Builder getAutoStopConfiguration() {
            return this.autoStopConfiguration != null ? this.autoStopConfiguration.toBuilder() : null;
        }

        public final void setAutoStopConfiguration(AutoStopConfig.BuilderImpl autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration != null ? autoStopConfiguration.build() : null;
        }

        @Override
        public final Builder autoStopConfiguration(AutoStopConfig autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public Application build() {
            return new Application(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Application> {
        public Builder applicationId(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder releaseLabel(String var1);

        public Builder type(String var1);

        public Builder state(String var1);

        public Builder state(ApplicationState var1);

        public Builder stateDetails(String var1);

        public Builder initialCapacity(Map<String, InitialCapacityConfig> var1);

        public Builder maximumCapacity(MaximumAllowedResources var1);

        default public Builder maximumCapacity(Consumer<MaximumAllowedResources.Builder> maximumCapacity) {
            return this.maximumCapacity((MaximumAllowedResources)((MaximumAllowedResources.Builder)MaximumAllowedResources.builder().applyMutation(maximumCapacity)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder autoStartConfiguration(AutoStartConfig var1);

        default public Builder autoStartConfiguration(Consumer<AutoStartConfig.Builder> autoStartConfiguration) {
            return this.autoStartConfiguration((AutoStartConfig)((AutoStartConfig.Builder)AutoStartConfig.builder().applyMutation(autoStartConfiguration)).build());
        }

        public Builder autoStopConfiguration(AutoStopConfig var1);

        default public Builder autoStopConfiguration(Consumer<AutoStopConfig.Builder> autoStopConfiguration) {
            return this.autoStopConfiguration((AutoStopConfig)((AutoStopConfig.Builder)AutoStopConfig.builder().applyMutation(autoStopConfiguration)).build());
        }

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder architecture(String var1);

        public Builder architecture(Architecture var1);
    }
}

