/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrserverless.model.Hive;
import software.amazon.awssdk.services.emrserverless.model.SparkSubmit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobDriver
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobDriver> {
    private static final SdkField<SparkSubmit> SPARK_SUBMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sparkSubmit").getter(JobDriver.getter(JobDriver::sparkSubmit)).setter(JobDriver.setter(Builder::sparkSubmit)).constructor(SparkSubmit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkSubmit").build()}).build();
    private static final SdkField<Hive> HIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hive").getter(JobDriver.getter(JobDriver::hive)).setter(JobDriver.setter(Builder::hive)).constructor(Hive::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPARK_SUBMIT_FIELD, HIVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobDriver.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SparkSubmit sparkSubmit;
    private final Hive hive;
    private final Type type;

    private JobDriver(BuilderImpl builder) {
        this.sparkSubmit = builder.sparkSubmit;
        this.hive = builder.hive;
        this.type = builder.type;
    }

    public final SparkSubmit sparkSubmit() {
        return this.sparkSubmit;
    }

    public final Hive hive() {
        return this.hive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sparkSubmit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDriver)) {
            return false;
        }
        JobDriver other = (JobDriver)obj;
        return Objects.equals(this.sparkSubmit(), other.sparkSubmit()) && Objects.equals(this.hive(), other.hive());
    }

    public final String toString() {
        return ToString.builder((String)"JobDriver").add("SparkSubmit", (Object)this.sparkSubmit()).add("Hive", (Object)this.hive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sparkSubmit": {
                return Optional.ofNullable(clazz.cast(this.sparkSubmit()));
            }
            case "hive": {
                return Optional.ofNullable(clazz.cast(this.hive()));
            }
        }
        return Optional.empty();
    }

    public static JobDriver fromSparkSubmit(SparkSubmit sparkSubmit) {
        return (JobDriver)JobDriver.builder().sparkSubmit(sparkSubmit).build();
    }

    public static JobDriver fromSparkSubmit(Consumer<SparkSubmit.Builder> sparkSubmit) {
        SparkSubmit.Builder builder = SparkSubmit.builder();
        sparkSubmit.accept(builder);
        return JobDriver.fromSparkSubmit((SparkSubmit)builder.build());
    }

    public static JobDriver fromHive(Hive hive) {
        return (JobDriver)JobDriver.builder().hive(hive).build();
    }

    public static JobDriver fromHive(Consumer<Hive.Builder> hive) {
        Hive.Builder builder = Hive.builder();
        hive.accept(builder);
        return JobDriver.fromHive((Hive)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sparkSubmit", SPARK_SUBMIT_FIELD);
        map.put("hive", HIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobDriver, T> g) {
        return obj -> g.apply((JobDriver)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SPARK_SUBMIT,
        HIVE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SparkSubmit sparkSubmit;
        private Hive hive;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobDriver model) {
            this.sparkSubmit(model.sparkSubmit);
            this.hive(model.hive);
        }

        public final SparkSubmit.Builder getSparkSubmit() {
            return this.sparkSubmit != null ? this.sparkSubmit.toBuilder() : null;
        }

        public final void setSparkSubmit(SparkSubmit.BuilderImpl sparkSubmit) {
            SparkSubmit oldValue = this.sparkSubmit;
            this.sparkSubmit = sparkSubmit != null ? sparkSubmit.build() : null;
            this.handleUnionValueChange(Type.SPARK_SUBMIT, oldValue, this.sparkSubmit);
        }

        @Override
        public final Builder sparkSubmit(SparkSubmit sparkSubmit) {
            SparkSubmit oldValue = this.sparkSubmit;
            this.sparkSubmit = sparkSubmit;
            this.handleUnionValueChange(Type.SPARK_SUBMIT, oldValue, this.sparkSubmit);
            return this;
        }

        public final Hive.Builder getHive() {
            return this.hive != null ? this.hive.toBuilder() : null;
        }

        public final void setHive(Hive.BuilderImpl hive) {
            Hive oldValue = this.hive;
            this.hive = hive != null ? hive.build() : null;
            this.handleUnionValueChange(Type.HIVE, oldValue, this.hive);
        }

        @Override
        public final Builder hive(Hive hive) {
            Hive oldValue = this.hive;
            this.hive = hive;
            this.handleUnionValueChange(Type.HIVE, oldValue, this.hive);
            return this;
        }

        public JobDriver build() {
            return new JobDriver(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobDriver> {
        public Builder sparkSubmit(SparkSubmit var1);

        default public Builder sparkSubmit(Consumer<SparkSubmit.Builder> sparkSubmit) {
            return this.sparkSubmit((SparkSubmit)((SparkSubmit.Builder)SparkSubmit.builder().applyMutation(sparkSubmit)).build());
        }

        public Builder hive(Hive var1);

        default public Builder hive(Consumer<Hive.Builder> hive) {
            return this.hive((Hive)((Hive.Builder)Hive.builder().applyMutation(hive)).build());
        }
    }
}

