/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SchemaAttributeType {
    NAME("NAME"),
    NAME_FIRST("NAME_FIRST"),
    NAME_MIDDLE("NAME_MIDDLE"),
    NAME_LAST("NAME_LAST"),
    ADDRESS("ADDRESS"),
    ADDRESS_STREET1("ADDRESS_STREET1"),
    ADDRESS_STREET2("ADDRESS_STREET2"),
    ADDRESS_STREET3("ADDRESS_STREET3"),
    ADDRESS_CITY("ADDRESS_CITY"),
    ADDRESS_STATE("ADDRESS_STATE"),
    ADDRESS_COUNTRY("ADDRESS_COUNTRY"),
    ADDRESS_POSTALCODE("ADDRESS_POSTALCODE"),
    PHONE("PHONE"),
    PHONE_NUMBER("PHONE_NUMBER"),
    PHONE_COUNTRYCODE("PHONE_COUNTRYCODE"),
    EMAIL_ADDRESS("EMAIL_ADDRESS"),
    UNIQUE_ID("UNIQUE_ID"),
    DATE("DATE"),
    STRING("STRING"),
    PROVIDER_ID("PROVIDER_ID"),
    IPV4("IPV4"),
    IPV6("IPV6"),
    MAID("MAID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SchemaAttributeType> VALUE_MAP;
    private final String value;

    private SchemaAttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SchemaAttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SchemaAttributeType> knownValues() {
        EnumSet<SchemaAttributeType> knownValues = EnumSet.allOf(SchemaAttributeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SchemaAttributeType.class, SchemaAttributeType::toString);
    }
}

