/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.FailedRecord;
import software.amazon.awssdk.services.entityresolution.model.FailedRecordsListCopier;
import software.amazon.awssdk.services.entityresolution.model.MatchGroup;
import software.amazon.awssdk.services.entityresolution.model.MatchGroupsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateMatchIdResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, GenerateMatchIdResponse> {
    private static final SdkField<List<MatchGroup>> MATCH_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("matchGroups").getter(GenerateMatchIdResponse.getter(GenerateMatchIdResponse::matchGroups)).setter(GenerateMatchIdResponse.setter(Builder::matchGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MatchGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FailedRecord>> FAILED_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedRecords").getter(GenerateMatchIdResponse.getter(GenerateMatchIdResponse::failedRecords)).setter(GenerateMatchIdResponse.setter(Builder::failedRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_GROUPS_FIELD, FAILED_RECORDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerateMatchIdResponse.memberNameToFieldInitializer();
    private final List<MatchGroup> matchGroups;
    private final List<FailedRecord> failedRecords;

    private GenerateMatchIdResponse(BuilderImpl builder) {
        super(builder);
        this.matchGroups = builder.matchGroups;
        this.failedRecords = builder.failedRecords;
    }

    public final boolean hasMatchGroups() {
        return this.matchGroups != null && !(this.matchGroups instanceof SdkAutoConstructList);
    }

    public final List<MatchGroup> matchGroups() {
        return this.matchGroups;
    }

    public final boolean hasFailedRecords() {
        return this.failedRecords != null && !(this.failedRecords instanceof SdkAutoConstructList);
    }

    public final List<FailedRecord> failedRecords() {
        return this.failedRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchGroups() ? this.matchGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedRecords() ? this.failedRecords() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMatchIdResponse)) {
            return false;
        }
        GenerateMatchIdResponse other = (GenerateMatchIdResponse)((Object)obj);
        return this.hasMatchGroups() == other.hasMatchGroups() && Objects.equals(this.matchGroups(), other.matchGroups()) && this.hasFailedRecords() == other.hasFailedRecords() && Objects.equals(this.failedRecords(), other.failedRecords());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateMatchIdResponse").add("MatchGroups", this.hasMatchGroups() ? this.matchGroups() : null).add("FailedRecords", this.hasFailedRecords() ? this.failedRecords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "matchGroups": {
                return Optional.ofNullable(clazz.cast(this.matchGroups()));
            }
            case "failedRecords": {
                return Optional.ofNullable(clazz.cast(this.failedRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("matchGroups", MATCH_GROUPS_FIELD);
        map.put("failedRecords", FAILED_RECORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateMatchIdResponse, T> g) {
        return obj -> g.apply((GenerateMatchIdResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private List<MatchGroup> matchGroups = DefaultSdkAutoConstructList.getInstance();
        private List<FailedRecord> failedRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMatchIdResponse model) {
            super(model);
            this.matchGroups(model.matchGroups);
            this.failedRecords(model.failedRecords);
        }

        public final List<MatchGroup.Builder> getMatchGroups() {
            List<MatchGroup.Builder> result = MatchGroupsListCopier.copyToBuilder(this.matchGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchGroups(Collection<MatchGroup.BuilderImpl> matchGroups) {
            this.matchGroups = MatchGroupsListCopier.copyFromBuilder(matchGroups);
        }

        @Override
        public final Builder matchGroups(Collection<MatchGroup> matchGroups) {
            this.matchGroups = MatchGroupsListCopier.copy(matchGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchGroups(MatchGroup ... matchGroups) {
            this.matchGroups(Arrays.asList(matchGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchGroups(Consumer<MatchGroup.Builder> ... matchGroups) {
            this.matchGroups(Stream.of(matchGroups).map(c -> (MatchGroup)((MatchGroup.Builder)MatchGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FailedRecord.Builder> getFailedRecords() {
            List<FailedRecord.Builder> result = FailedRecordsListCopier.copyToBuilder(this.failedRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedRecords(Collection<FailedRecord.BuilderImpl> failedRecords) {
            this.failedRecords = FailedRecordsListCopier.copyFromBuilder(failedRecords);
        }

        @Override
        public final Builder failedRecords(Collection<FailedRecord> failedRecords) {
            this.failedRecords = FailedRecordsListCopier.copy(failedRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRecords(FailedRecord ... failedRecords) {
            this.failedRecords(Arrays.asList(failedRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRecords(Consumer<FailedRecord.Builder> ... failedRecords) {
            this.failedRecords(Stream.of(failedRecords).map(c -> (FailedRecord)((FailedRecord.Builder)FailedRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GenerateMatchIdResponse build() {
            return new GenerateMatchIdResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateMatchIdResponse> {
        public Builder matchGroups(Collection<MatchGroup> var1);

        public Builder matchGroups(MatchGroup ... var1);

        public Builder matchGroups(Consumer<MatchGroup.Builder> ... var1);

        public Builder failedRecords(Collection<FailedRecord> var1);

        public Builder failedRecords(FailedRecord ... var1);

        public Builder failedRecords(Consumer<FailedRecord.Builder> ... var1);
    }
}

