/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionRequest;
import software.amazon.awssdk.services.entityresolution.model.RecordAttributeMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMatchIdRequest
extends EntityResolutionRequest
implements ToCopyableBuilder<Builder, GetMatchIdRequest> {
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowName").getter(GetMatchIdRequest.getter(GetMatchIdRequest::workflowName)).setter(GetMatchIdRequest.setter(Builder::workflowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowName").build()}).build();
    private static final SdkField<Map<String, String>> RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("record").getter(GetMatchIdRequest.getter(GetMatchIdRequest::record)).setter(GetMatchIdRequest.setter(Builder::record)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("record").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> APPLY_NORMALIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("applyNormalization").getter(GetMatchIdRequest.getter(GetMatchIdRequest::applyNormalization)).setter(GetMatchIdRequest.setter(Builder::applyNormalization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyNormalization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_NAME_FIELD, RECORD_FIELD, APPLY_NORMALIZATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMatchIdRequest.memberNameToFieldInitializer();
    private final String workflowName;
    private final Map<String, String> record;
    private final Boolean applyNormalization;

    private GetMatchIdRequest(BuilderImpl builder) {
        super(builder);
        this.workflowName = builder.workflowName;
        this.record = builder.record;
        this.applyNormalization = builder.applyNormalization;
    }

    public final String workflowName() {
        return this.workflowName;
    }

    public final boolean hasRecord() {
        return this.record != null && !(this.record instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> record() {
        return this.record;
    }

    public final Boolean applyNormalization() {
        return this.applyNormalization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecord() ? this.record() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applyNormalization());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMatchIdRequest)) {
            return false;
        }
        GetMatchIdRequest other = (GetMatchIdRequest)((Object)obj);
        return Objects.equals(this.workflowName(), other.workflowName()) && this.hasRecord() == other.hasRecord() && Objects.equals(this.record(), other.record()) && Objects.equals(this.applyNormalization(), other.applyNormalization());
    }

    public final String toString() {
        return ToString.builder((String)"GetMatchIdRequest").add("WorkflowName", (Object)this.workflowName()).add("Record", (Object)(this.record() == null ? null : "*** Sensitive Data Redacted ***")).add("ApplyNormalization", (Object)this.applyNormalization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowName": {
                return Optional.ofNullable(clazz.cast(this.workflowName()));
            }
            case "record": {
                return Optional.ofNullable(clazz.cast(this.record()));
            }
            case "applyNormalization": {
                return Optional.ofNullable(clazz.cast(this.applyNormalization()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowName", WORKFLOW_NAME_FIELD);
        map.put("record", RECORD_FIELD);
        map.put("applyNormalization", APPLY_NORMALIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMatchIdRequest, T> g) {
        return obj -> g.apply((GetMatchIdRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionRequest.BuilderImpl
    implements Builder {
        private String workflowName;
        private Map<String, String> record = DefaultSdkAutoConstructMap.getInstance();
        private Boolean applyNormalization;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMatchIdRequest model) {
            super(model);
            this.workflowName(model.workflowName);
            this.record(model.record);
            this.applyNormalization(model.applyNormalization);
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final Map<String, String> getRecord() {
            if (this.record instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.record;
        }

        public final void setRecord(Map<String, String> record) {
            this.record = RecordAttributeMapCopier.copy(record);
        }

        @Override
        public final Builder record(Map<String, String> record) {
            this.record = RecordAttributeMapCopier.copy(record);
            return this;
        }

        public final Boolean getApplyNormalization() {
            return this.applyNormalization;
        }

        public final void setApplyNormalization(Boolean applyNormalization) {
            this.applyNormalization = applyNormalization;
        }

        @Override
        public final Builder applyNormalization(Boolean applyNormalization) {
            this.applyNormalization = applyNormalization;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMatchIdRequest build() {
            return new GetMatchIdRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EntityResolutionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMatchIdRequest> {
        public Builder workflowName(String var1);

        public Builder record(Map<String, String> var1);

        public Builder applyNormalization(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

