/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest;
import software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse;
import software.amazon.awssdk.services.entityresolution.model.ProviderServiceSummary;

public class ListProviderServicesIterable
implements SdkIterable<ListProviderServicesResponse> {
    private final EntityResolutionClient client;
    private final ListProviderServicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProviderServicesIterable(EntityResolutionClient client, ListProviderServicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProviderServicesResponseFetcher();
    }

    public Iterator<ListProviderServicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProviderServiceSummary> providerServiceSummaries() {
        Function<ListProviderServicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.providerServiceSummaries() != null) {
                return response.providerServiceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProviderServicesResponseFetcher
    implements SyncPageFetcher<ListProviderServicesResponse> {
        private ListProviderServicesResponseFetcher() {
        }

        public boolean hasNextPage(ListProviderServicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProviderServicesResponse nextPage(ListProviderServicesResponse previousPage) {
            if (previousPage == null) {
                return ListProviderServicesIterable.this.client.listProviderServices(ListProviderServicesIterable.this.firstRequest);
            }
            return ListProviderServicesIterable.this.client.listProviderServices((ListProviderServicesRequest)((Object)ListProviderServicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

