/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The retry strategy to use for failed jobs, if the target is an Batch job. If you specify a retry strategy here, it
 * overrides the retry strategy defined in the job definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchRetryStrategy implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchRetryStrategy.Builder, BatchRetryStrategy> {
    private static final SdkField<Integer> ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Attempts").getter(getter(BatchRetryStrategy::attempts)).setter(setter(Builder::attempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attempts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTEMPTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer attempts;

    private BatchRetryStrategy(BuilderImpl builder) {
        this.attempts = builder.attempts;
    }

    /**
     * <p>
     * The number of times to attempt to retry, if the job fails. Valid values are 1–10.
     * </p>
     * 
     * @return The number of times to attempt to retry, if the job fails. Valid values are 1–10.
     */
    public final Integer attempts() {
        return attempts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attempts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchRetryStrategy)) {
            return false;
        }
        BatchRetryStrategy other = (BatchRetryStrategy) obj;
        return Objects.equals(attempts(), other.attempts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchRetryStrategy").add("Attempts", attempts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attempts":
            return Optional.ofNullable(clazz.cast(attempts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchRetryStrategy, T> g) {
        return obj -> g.apply((BatchRetryStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchRetryStrategy> {
        /**
         * <p>
         * The number of times to attempt to retry, if the job fails. Valid values are 1–10.
         * </p>
         * 
         * @param attempts
         *        The number of times to attempt to retry, if the job fails. Valid values are 1–10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempts(Integer attempts);
    }

    static final class BuilderImpl implements Builder {
        private Integer attempts;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchRetryStrategy model) {
            attempts(model.attempts);
        }

        public final Integer getAttempts() {
            return attempts;
        }

        public final void setAttempts(Integer attempts) {
            this.attempts = attempts;
        }

        @Override
        public final Builder attempts(Integer attempts) {
            this.attempts = attempts;
            return this;
        }

        @Override
        public BatchRetryStrategy build() {
            return new BatchRetryStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
