/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the authorization parameters for the connection if API Key is specified as the authorization type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionApiKeyAuthResponseParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionApiKeyAuthResponseParameters.Builder, ConnectionApiKeyAuthResponseParameters> {
    private static final SdkField<String> API_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiKeyName").getter(getter(ConnectionApiKeyAuthResponseParameters::apiKeyName))
            .setter(setter(Builder::apiKeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiKeyName;

    private ConnectionApiKeyAuthResponseParameters(BuilderImpl builder) {
        this.apiKeyName = builder.apiKeyName;
    }

    /**
     * <p>
     * The name of the header to use for the <code>APIKeyValue</code> used for authorization.
     * </p>
     * 
     * @return The name of the header to use for the <code>APIKeyValue</code> used for authorization.
     */
    public final String apiKeyName() {
        return apiKeyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionApiKeyAuthResponseParameters)) {
            return false;
        }
        ConnectionApiKeyAuthResponseParameters other = (ConnectionApiKeyAuthResponseParameters) obj;
        return Objects.equals(apiKeyName(), other.apiKeyName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionApiKeyAuthResponseParameters").add("ApiKeyName", apiKeyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiKeyName":
            return Optional.ofNullable(clazz.cast(apiKeyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionApiKeyAuthResponseParameters, T> g) {
        return obj -> g.apply((ConnectionApiKeyAuthResponseParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionApiKeyAuthResponseParameters> {
        /**
         * <p>
         * The name of the header to use for the <code>APIKeyValue</code> used for authorization.
         * </p>
         * 
         * @param apiKeyName
         *        The name of the header to use for the <code>APIKeyValue</code> used for authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyName(String apiKeyName);
    }

    static final class BuilderImpl implements Builder {
        private String apiKeyName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionApiKeyAuthResponseParameters model) {
            apiKeyName(model.apiKeyName);
        }

        public final String getApiKeyName() {
            return apiKeyName;
        }

        public final void setApiKeyName(String apiKeyName) {
            this.apiKeyName = apiKeyName;
        }

        @Override
        public final Builder apiKeyName(String apiKeyName) {
            this.apiKeyName = apiKeyName;
            return this;
        }

        @Override
        public ConnectionApiKeyAuthResponseParameters build() {
            return new ConnectionApiKeyAuthResponseParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
