/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentResponse extends FinspaceResponse implements
        ToCopyableBuilder<CreateEnvironmentResponse.Builder, CreateEnvironmentResponse> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(CreateEnvironmentResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentArn").getter(getter(CreateEnvironmentResponse::environmentArn))
            .setter(setter(Builder::environmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()).build();

    private static final SdkField<String> ENVIRONMENT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentUrl").getter(getter(CreateEnvironmentResponse::environmentUrl))
            .setter(setter(Builder::environmentUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            ENVIRONMENT_ARN_FIELD, ENVIRONMENT_URL_FIELD));

    private final String environmentId;

    private final String environmentArn;

    private final String environmentUrl;

    private CreateEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.environmentArn = builder.environmentArn;
        this.environmentUrl = builder.environmentUrl;
    }

    /**
     * <p>
     * The unique identifier for FinSpace environment that you created.
     * </p>
     * 
     * @return The unique identifier for FinSpace environment that you created.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the FinSpace environment that you created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the FinSpace environment that you created.
     */
    public final String environmentArn() {
        return environmentArn;
    }

    /**
     * <p>
     * The sign-in url for the web application of the FinSpace environment you created.
     * </p>
     * 
     * @return The sign-in url for the web application of the FinSpace environment you created.
     */
    public final String environmentUrl() {
        return environmentUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(environmentUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentResponse)) {
            return false;
        }
        CreateEnvironmentResponse other = (CreateEnvironmentResponse) obj;
        return Objects.equals(environmentId(), other.environmentId()) && Objects.equals(environmentArn(), other.environmentArn())
                && Objects.equals(environmentUrl(), other.environmentUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentResponse").add("EnvironmentId", environmentId())
                .add("EnvironmentArn", environmentArn()).add("EnvironmentUrl", environmentUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "environmentArn":
            return Optional.ofNullable(clazz.cast(environmentArn()));
        case "environmentUrl":
            return Optional.ofNullable(clazz.cast(environmentUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentResponse, T> g) {
        return obj -> g.apply((CreateEnvironmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentResponse> {
        /**
         * <p>
         * The unique identifier for FinSpace environment that you created.
         * </p>
         * 
         * @param environmentId
         *        The unique identifier for FinSpace environment that you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the FinSpace environment that you created.
         * </p>
         * 
         * @param environmentArn
         *        The Amazon Resource Name (ARN) of the FinSpace environment that you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentArn(String environmentArn);

        /**
         * <p>
         * The sign-in url for the web application of the FinSpace environment you created.
         * </p>
         * 
         * @param environmentUrl
         *        The sign-in url for the web application of the FinSpace environment you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentUrl(String environmentUrl);
    }

    static final class BuilderImpl extends FinspaceResponse.BuilderImpl implements Builder {
        private String environmentId;

        private String environmentArn;

        private String environmentUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentResponse model) {
            super(model);
            environmentId(model.environmentId);
            environmentArn(model.environmentArn);
            environmentUrl(model.environmentUrl);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        @Transient
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getEnvironmentArn() {
            return environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        @Transient
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getEnvironmentUrl() {
            return environmentUrl;
        }

        public final void setEnvironmentUrl(String environmentUrl) {
            this.environmentUrl = environmentUrl;
        }

        @Override
        @Transient
        public final Builder environmentUrl(String environmentUrl) {
            this.environmentUrl = environmentUrl;
            return this;
        }

        @Override
        public CreateEnvironmentResponse build() {
            return new CreateEnvironmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
