/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnowflakeRoleConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnowflakeRoleConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(SnowflakeRoleConfiguration.getter(SnowflakeRoleConfiguration::enabled)).setter(SnowflakeRoleConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> SNOWFLAKE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnowflakeRole").getter(SnowflakeRoleConfiguration.getter(SnowflakeRoleConfiguration::snowflakeRole)).setter(SnowflakeRoleConfiguration.setter(Builder::snowflakeRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowflakeRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, SNOWFLAKE_ROLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String snowflakeRole;

    private SnowflakeRoleConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.snowflakeRole = builder.snowflakeRole;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String snowflakeRole() {
        return this.snowflakeRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowflakeRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeRoleConfiguration)) {
            return false;
        }
        SnowflakeRoleConfiguration other = (SnowflakeRoleConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.snowflakeRole(), other.snowflakeRole());
    }

    public final String toString() {
        return ToString.builder((String)"SnowflakeRoleConfiguration").add("Enabled", (Object)this.enabled()).add("SnowflakeRole", (Object)(this.snowflakeRole() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "SnowflakeRole": {
                return Optional.ofNullable(clazz.cast(this.snowflakeRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeRoleConfiguration, T> g) {
        return obj -> g.apply((SnowflakeRoleConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String snowflakeRole;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeRoleConfiguration model) {
            this.enabled(model.enabled);
            this.snowflakeRole(model.snowflakeRole);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getSnowflakeRole() {
            return this.snowflakeRole;
        }

        public final void setSnowflakeRole(String snowflakeRole) {
            this.snowflakeRole = snowflakeRole;
        }

        @Override
        public final Builder snowflakeRole(String snowflakeRole) {
            this.snowflakeRole = snowflakeRole;
            return this;
        }

        public SnowflakeRoleConfiguration build() {
            return new SnowflakeRoleConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnowflakeRoleConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder snowflakeRole(String var1);
    }
}

