/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the method for setting up document ID. The supported methods are Firehose generated document ID and
 * OpenSearch Service generated document ID.
 * </p>
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentIdOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentIdOptions.Builder, DocumentIdOptions> {
    private static final SdkField<String> DEFAULT_DOCUMENT_ID_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultDocumentIdFormat").getter(getter(DocumentIdOptions::defaultDocumentIdFormatAsString))
            .setter(setter(Builder::defaultDocumentIdFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultDocumentIdFormat").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DEFAULT_DOCUMENT_ID_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultDocumentIdFormat;

    private DocumentIdOptions(BuilderImpl builder) {
        this.defaultDocumentIdFormat = builder.defaultDocumentIdFormat;
    }

    /**
     * <p>
     * When the <code>FIREHOSE_DEFAULT</code> option is chosen, Firehose generates a unique document ID for each record
     * based on a unique internal identifier. The generated document ID is stable across multiple delivery attempts,
     * which helps prevent the same record from being indexed multiple times with different document IDs.
     * </p>
     * <p>
     * When the <code>NO_DOCUMENT_ID</code> option is chosen, Firehose does not include any document IDs in the requests
     * it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service domain to generate document
     * IDs. In case of multiple delivery attempts, this may cause the same record to be indexed more than once with
     * different document IDs. This option enables write-heavy operations, such as the ingestion of logs and
     * observability data, to consume less resources in the Amazon OpenSearch Service domain, resulting in improved
     * performance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultDocumentIdFormat} will return {@link DefaultDocumentIdFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #defaultDocumentIdFormatAsString}.
     * </p>
     * 
     * @return When the <code>FIREHOSE_DEFAULT</code> option is chosen, Firehose generates a unique document ID for each
     *         record based on a unique internal identifier. The generated document ID is stable across multiple
     *         delivery attempts, which helps prevent the same record from being indexed multiple times with different
     *         document IDs.</p>
     *         <p>
     *         When the <code>NO_DOCUMENT_ID</code> option is chosen, Firehose does not include any document IDs in the
     *         requests it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service domain to
     *         generate document IDs. In case of multiple delivery attempts, this may cause the same record to be
     *         indexed more than once with different document IDs. This option enables write-heavy operations, such as
     *         the ingestion of logs and observability data, to consume less resources in the Amazon OpenSearch Service
     *         domain, resulting in improved performance.
     * @see DefaultDocumentIdFormat
     */
    public final DefaultDocumentIdFormat defaultDocumentIdFormat() {
        return DefaultDocumentIdFormat.fromValue(defaultDocumentIdFormat);
    }

    /**
     * <p>
     * When the <code>FIREHOSE_DEFAULT</code> option is chosen, Firehose generates a unique document ID for each record
     * based on a unique internal identifier. The generated document ID is stable across multiple delivery attempts,
     * which helps prevent the same record from being indexed multiple times with different document IDs.
     * </p>
     * <p>
     * When the <code>NO_DOCUMENT_ID</code> option is chosen, Firehose does not include any document IDs in the requests
     * it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service domain to generate document
     * IDs. In case of multiple delivery attempts, this may cause the same record to be indexed more than once with
     * different document IDs. This option enables write-heavy operations, such as the ingestion of logs and
     * observability data, to consume less resources in the Amazon OpenSearch Service domain, resulting in improved
     * performance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultDocumentIdFormat} will return {@link DefaultDocumentIdFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #defaultDocumentIdFormatAsString}.
     * </p>
     * 
     * @return When the <code>FIREHOSE_DEFAULT</code> option is chosen, Firehose generates a unique document ID for each
     *         record based on a unique internal identifier. The generated document ID is stable across multiple
     *         delivery attempts, which helps prevent the same record from being indexed multiple times with different
     *         document IDs.</p>
     *         <p>
     *         When the <code>NO_DOCUMENT_ID</code> option is chosen, Firehose does not include any document IDs in the
     *         requests it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service domain to
     *         generate document IDs. In case of multiple delivery attempts, this may cause the same record to be
     *         indexed more than once with different document IDs. This option enables write-heavy operations, such as
     *         the ingestion of logs and observability data, to consume less resources in the Amazon OpenSearch Service
     *         domain, resulting in improved performance.
     * @see DefaultDocumentIdFormat
     */
    public final String defaultDocumentIdFormatAsString() {
        return defaultDocumentIdFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultDocumentIdFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentIdOptions)) {
            return false;
        }
        DocumentIdOptions other = (DocumentIdOptions) obj;
        return Objects.equals(defaultDocumentIdFormatAsString(), other.defaultDocumentIdFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentIdOptions").add("DefaultDocumentIdFormat", defaultDocumentIdFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultDocumentIdFormat":
            return Optional.ofNullable(clazz.cast(defaultDocumentIdFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentIdOptions, T> g) {
        return obj -> g.apply((DocumentIdOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentIdOptions> {
        /**
         * <p>
         * When the <code>FIREHOSE_DEFAULT</code> option is chosen, Firehose generates a unique document ID for each
         * record based on a unique internal identifier. The generated document ID is stable across multiple delivery
         * attempts, which helps prevent the same record from being indexed multiple times with different document IDs.
         * </p>
         * <p>
         * When the <code>NO_DOCUMENT_ID</code> option is chosen, Firehose does not include any document IDs in the
         * requests it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service domain to
         * generate document IDs. In case of multiple delivery attempts, this may cause the same record to be indexed
         * more than once with different document IDs. This option enables write-heavy operations, such as the ingestion
         * of logs and observability data, to consume less resources in the Amazon OpenSearch Service domain, resulting
         * in improved performance.
         * </p>
         * 
         * @param defaultDocumentIdFormat
         *        When the <code>FIREHOSE_DEFAULT</code> option is chosen, Firehose generates a unique document ID for
         *        each record based on a unique internal identifier. The generated document ID is stable across multiple
         *        delivery attempts, which helps prevent the same record from being indexed multiple times with
         *        different document IDs.</p>
         *        <p>
         *        When the <code>NO_DOCUMENT_ID</code> option is chosen, Firehose does not include any document IDs in
         *        the requests it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service
         *        domain to generate document IDs. In case of multiple delivery attempts, this may cause the same record
         *        to be indexed more than once with different document IDs. This option enables write-heavy operations,
         *        such as the ingestion of logs and observability data, to consume less resources in the Amazon
         *        OpenSearch Service domain, resulting in improved performance.
         * @see DefaultDocumentIdFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultDocumentIdFormat
         */
        Builder defaultDocumentIdFormat(String defaultDocumentIdFormat);

        /**
         * <p>
         * When the <code>FIREHOSE_DEFAULT</code> option is chosen, Firehose generates a unique document ID for each
         * record based on a unique internal identifier. The generated document ID is stable across multiple delivery
         * attempts, which helps prevent the same record from being indexed multiple times with different document IDs.
         * </p>
         * <p>
         * When the <code>NO_DOCUMENT_ID</code> option is chosen, Firehose does not include any document IDs in the
         * requests it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service domain to
         * generate document IDs. In case of multiple delivery attempts, this may cause the same record to be indexed
         * more than once with different document IDs. This option enables write-heavy operations, such as the ingestion
         * of logs and observability data, to consume less resources in the Amazon OpenSearch Service domain, resulting
         * in improved performance.
         * </p>
         * 
         * @param defaultDocumentIdFormat
         *        When the <code>FIREHOSE_DEFAULT</code> option is chosen, Firehose generates a unique document ID for
         *        each record based on a unique internal identifier. The generated document ID is stable across multiple
         *        delivery attempts, which helps prevent the same record from being indexed multiple times with
         *        different document IDs.</p>
         *        <p>
         *        When the <code>NO_DOCUMENT_ID</code> option is chosen, Firehose does not include any document IDs in
         *        the requests it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service
         *        domain to generate document IDs. In case of multiple delivery attempts, this may cause the same record
         *        to be indexed more than once with different document IDs. This option enables write-heavy operations,
         *        such as the ingestion of logs and observability data, to consume less resources in the Amazon
         *        OpenSearch Service domain, resulting in improved performance.
         * @see DefaultDocumentIdFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultDocumentIdFormat
         */
        Builder defaultDocumentIdFormat(DefaultDocumentIdFormat defaultDocumentIdFormat);
    }

    static final class BuilderImpl implements Builder {
        private String defaultDocumentIdFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentIdOptions model) {
            defaultDocumentIdFormat(model.defaultDocumentIdFormat);
        }

        public final String getDefaultDocumentIdFormat() {
            return defaultDocumentIdFormat;
        }

        public final void setDefaultDocumentIdFormat(String defaultDocumentIdFormat) {
            this.defaultDocumentIdFormat = defaultDocumentIdFormat;
        }

        @Override
        public final Builder defaultDocumentIdFormat(String defaultDocumentIdFormat) {
            this.defaultDocumentIdFormat = defaultDocumentIdFormat;
            return this;
        }

        @Override
        public final Builder defaultDocumentIdFormat(DefaultDocumentIdFormat defaultDocumentIdFormat) {
            this.defaultDocumentIdFormat(defaultDocumentIdFormat == null ? null : defaultDocumentIdFormat.toString());
            return this;
        }

        @Override
        public DocumentIdOptions build() {
            return new DocumentIdOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
