/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fis.model.AccountTargeting;
import software.amazon.awssdk.services.fis.model.ActionsMode;
import software.amazon.awssdk.services.fis.model.EmptyTargetResolutionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentOptions> {
    private static final SdkField<String> ACCOUNT_TARGETING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountTargeting").getter(ExperimentOptions.getter(ExperimentOptions::accountTargetingAsString)).setter(ExperimentOptions.setter(Builder::accountTargeting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountTargeting").build()}).build();
    private static final SdkField<String> EMPTY_TARGET_RESOLUTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("emptyTargetResolutionMode").getter(ExperimentOptions.getter(ExperimentOptions::emptyTargetResolutionModeAsString)).setter(ExperimentOptions.setter(Builder::emptyTargetResolutionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emptyTargetResolutionMode").build()}).build();
    private static final SdkField<String> ACTIONS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionsMode").getter(ExperimentOptions.getter(ExperimentOptions::actionsModeAsString)).setter(ExperimentOptions.setter(Builder::actionsMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_TARGETING_FIELD, EMPTY_TARGET_RESOLUTION_MODE_FIELD, ACTIONS_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExperimentOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountTargeting;
    private final String emptyTargetResolutionMode;
    private final String actionsMode;

    private ExperimentOptions(BuilderImpl builder) {
        this.accountTargeting = builder.accountTargeting;
        this.emptyTargetResolutionMode = builder.emptyTargetResolutionMode;
        this.actionsMode = builder.actionsMode;
    }

    public final AccountTargeting accountTargeting() {
        return AccountTargeting.fromValue(this.accountTargeting);
    }

    public final String accountTargetingAsString() {
        return this.accountTargeting;
    }

    public final EmptyTargetResolutionMode emptyTargetResolutionMode() {
        return EmptyTargetResolutionMode.fromValue(this.emptyTargetResolutionMode);
    }

    public final String emptyTargetResolutionModeAsString() {
        return this.emptyTargetResolutionMode;
    }

    public final ActionsMode actionsMode() {
        return ActionsMode.fromValue(this.actionsMode);
    }

    public final String actionsModeAsString() {
        return this.actionsMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountTargetingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.emptyTargetResolutionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentOptions)) {
            return false;
        }
        ExperimentOptions other = (ExperimentOptions)obj;
        return Objects.equals(this.accountTargetingAsString(), other.accountTargetingAsString()) && Objects.equals(this.emptyTargetResolutionModeAsString(), other.emptyTargetResolutionModeAsString()) && Objects.equals(this.actionsModeAsString(), other.actionsModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentOptions").add("AccountTargeting", (Object)this.accountTargetingAsString()).add("EmptyTargetResolutionMode", (Object)this.emptyTargetResolutionModeAsString()).add("ActionsMode", (Object)this.actionsModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountTargeting": {
                return Optional.ofNullable(clazz.cast(this.accountTargetingAsString()));
            }
            case "emptyTargetResolutionMode": {
                return Optional.ofNullable(clazz.cast(this.emptyTargetResolutionModeAsString()));
            }
            case "actionsMode": {
                return Optional.ofNullable(clazz.cast(this.actionsModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("accountTargeting", ACCOUNT_TARGETING_FIELD);
        map.put("emptyTargetResolutionMode", EMPTY_TARGET_RESOLUTION_MODE_FIELD);
        map.put("actionsMode", ACTIONS_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentOptions, T> g) {
        return obj -> g.apply((ExperimentOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountTargeting;
        private String emptyTargetResolutionMode;
        private String actionsMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentOptions model) {
            this.accountTargeting(model.accountTargeting);
            this.emptyTargetResolutionMode(model.emptyTargetResolutionMode);
            this.actionsMode(model.actionsMode);
        }

        public final String getAccountTargeting() {
            return this.accountTargeting;
        }

        public final void setAccountTargeting(String accountTargeting) {
            this.accountTargeting = accountTargeting;
        }

        @Override
        public final Builder accountTargeting(String accountTargeting) {
            this.accountTargeting = accountTargeting;
            return this;
        }

        @Override
        public final Builder accountTargeting(AccountTargeting accountTargeting) {
            this.accountTargeting(accountTargeting == null ? null : accountTargeting.toString());
            return this;
        }

        public final String getEmptyTargetResolutionMode() {
            return this.emptyTargetResolutionMode;
        }

        public final void setEmptyTargetResolutionMode(String emptyTargetResolutionMode) {
            this.emptyTargetResolutionMode = emptyTargetResolutionMode;
        }

        @Override
        public final Builder emptyTargetResolutionMode(String emptyTargetResolutionMode) {
            this.emptyTargetResolutionMode = emptyTargetResolutionMode;
            return this;
        }

        @Override
        public final Builder emptyTargetResolutionMode(EmptyTargetResolutionMode emptyTargetResolutionMode) {
            this.emptyTargetResolutionMode(emptyTargetResolutionMode == null ? null : emptyTargetResolutionMode.toString());
            return this;
        }

        public final String getActionsMode() {
            return this.actionsMode;
        }

        public final void setActionsMode(String actionsMode) {
            this.actionsMode = actionsMode;
        }

        @Override
        public final Builder actionsMode(String actionsMode) {
            this.actionsMode = actionsMode;
            return this;
        }

        @Override
        public final Builder actionsMode(ActionsMode actionsMode) {
            this.actionsMode(actionsMode == null ? null : actionsMode.toString());
            return this;
        }

        public ExperimentOptions build() {
            return new ExperimentOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentOptions> {
        public Builder accountTargeting(String var1);

        public Builder accountTargeting(AccountTargeting var1);

        public Builder emptyTargetResolutionMode(String var1);

        public Builder emptyTargetResolutionMode(EmptyTargetResolutionMode var1);

        public Builder actionsMode(String var1);

        public Builder actionsMode(ActionsMode var1);
    }
}

