/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EntryType {
    FMS_MANAGED_FIRST_ENTRY("FMS_MANAGED_FIRST_ENTRY"),
    FMS_MANAGED_LAST_ENTRY("FMS_MANAGED_LAST_ENTRY"),
    CUSTOM_ENTRY("CUSTOM_ENTRY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EntryType> VALUE_MAP;
    private final String value;

    private EntryType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntryType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EntryType> knownValues() {
        EnumSet<EntryType> knownValues = EnumSet.allOf(EntryType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EntryType.class, EntryType::toString);
    }
}

