/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAutoPredictorResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribeAutoPredictorResponse.Builder, DescribeAutoPredictorResponse> {
    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorArn").getter(getter(DescribeAutoPredictorResponse::predictorArn))
            .setter(setter(Builder::predictorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()).build();

    private static final SdkField<String> PREDICTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorName").getter(getter(DescribeAutoPredictorResponse::predictorName))
            .setter(setter(Builder::predictorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorName").build()).build();

    private static final SdkField<Integer> FORECAST_HORIZON_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ForecastHorizon").getter(getter(DescribeAutoPredictorResponse::forecastHorizon))
            .setter(setter(Builder::forecastHorizon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastHorizon").build()).build();

    private static final SdkField<List<String>> FORECAST_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ForecastTypes")
            .getter(getter(DescribeAutoPredictorResponse::forecastTypes))
            .setter(setter(Builder::forecastTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FORECAST_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastFrequency").getter(getter(DescribeAutoPredictorResponse::forecastFrequency))
            .setter(setter(Builder::forecastFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastFrequency").build()).build();

    private static final SdkField<List<String>> FORECAST_DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ForecastDimensions")
            .getter(getter(DescribeAutoPredictorResponse::forecastDimensions))
            .setter(setter(Builder::forecastDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DATASET_IMPORT_JOB_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DatasetImportJobArns")
            .getter(getter(DescribeAutoPredictorResponse::datasetImportJobArns))
            .setter(setter(Builder::datasetImportJobArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataConfig> DATA_CONFIG_FIELD = SdkField.<DataConfig> builder(MarshallingType.SDK_POJO)
            .memberName("DataConfig").getter(getter(DescribeAutoPredictorResponse::dataConfig))
            .setter(setter(Builder::dataConfig)).constructor(DataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataConfig").build()).build();

    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField
            .<EncryptionConfig> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfig")
            .getter(getter(DescribeAutoPredictorResponse::encryptionConfig)).setter(setter(Builder::encryptionConfig))
            .constructor(EncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()).build();

    private static final SdkField<ReferencePredictorSummary> REFERENCE_PREDICTOR_SUMMARY_FIELD = SdkField
            .<ReferencePredictorSummary> builder(MarshallingType.SDK_POJO).memberName("ReferencePredictorSummary")
            .getter(getter(DescribeAutoPredictorResponse::referencePredictorSummary))
            .setter(setter(Builder::referencePredictorSummary)).constructor(ReferencePredictorSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencePredictorSummary").build())
            .build();

    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedTimeRemainingInMinutes")
            .getter(getter(DescribeAutoPredictorResponse::estimatedTimeRemainingInMinutes))
            .setter(setter(Builder::estimatedTimeRemainingInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeAutoPredictorResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribeAutoPredictorResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeAutoPredictorResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribeAutoPredictorResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<String> OPTIMIZATION_METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationMetric").getter(getter(DescribeAutoPredictorResponse::optimizationMetricAsString))
            .setter(setter(Builder::optimizationMetric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationMetric").build())
            .build();

    private static final SdkField<ExplainabilityInfo> EXPLAINABILITY_INFO_FIELD = SdkField
            .<ExplainabilityInfo> builder(MarshallingType.SDK_POJO).memberName("ExplainabilityInfo")
            .getter(getter(DescribeAutoPredictorResponse::explainabilityInfo)).setter(setter(Builder::explainabilityInfo))
            .constructor(ExplainabilityInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_ARN_FIELD,
            PREDICTOR_NAME_FIELD, FORECAST_HORIZON_FIELD, FORECAST_TYPES_FIELD, FORECAST_FREQUENCY_FIELD,
            FORECAST_DIMENSIONS_FIELD, DATASET_IMPORT_JOB_ARNS_FIELD, DATA_CONFIG_FIELD, ENCRYPTION_CONFIG_FIELD,
            REFERENCE_PREDICTOR_SUMMARY_FIELD, ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD, STATUS_FIELD, MESSAGE_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, OPTIMIZATION_METRIC_FIELD, EXPLAINABILITY_INFO_FIELD));

    private final String predictorArn;

    private final String predictorName;

    private final Integer forecastHorizon;

    private final List<String> forecastTypes;

    private final String forecastFrequency;

    private final List<String> forecastDimensions;

    private final List<String> datasetImportJobArns;

    private final DataConfig dataConfig;

    private final EncryptionConfig encryptionConfig;

    private final ReferencePredictorSummary referencePredictorSummary;

    private final Long estimatedTimeRemainingInMinutes;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final String optimizationMetric;

    private final ExplainabilityInfo explainabilityInfo;

    private DescribeAutoPredictorResponse(BuilderImpl builder) {
        super(builder);
        this.predictorArn = builder.predictorArn;
        this.predictorName = builder.predictorName;
        this.forecastHorizon = builder.forecastHorizon;
        this.forecastTypes = builder.forecastTypes;
        this.forecastFrequency = builder.forecastFrequency;
        this.forecastDimensions = builder.forecastDimensions;
        this.datasetImportJobArns = builder.datasetImportJobArns;
        this.dataConfig = builder.dataConfig;
        this.encryptionConfig = builder.encryptionConfig;
        this.referencePredictorSummary = builder.referencePredictorSummary;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.optimizationMetric = builder.optimizationMetric;
        this.explainabilityInfo = builder.explainabilityInfo;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the predictor
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the predictor
     */
    public final String predictorArn() {
        return predictorArn;
    }

    /**
     * <p>
     * The name of the predictor.
     * </p>
     * 
     * @return The name of the predictor.
     */
    public final String predictorName() {
        return predictorName;
    }

    /**
     * <p>
     * The number of time-steps that the model predicts. The forecast horizon is also called the prediction length.
     * </p>
     * 
     * @return The number of time-steps that the model predicts. The forecast horizon is also called the prediction
     *         length.
     */
    public final Integer forecastHorizon() {
        return forecastHorizon;
    }

    /**
     * For responses, this returns true if the service returned a value for the ForecastTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasForecastTypes() {
        return forecastTypes != null && !(forecastTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The forecast types used during predictor training. Default value is ["0.1","0.5","0.9"].
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForecastTypes} method.
     * </p>
     * 
     * @return The forecast types used during predictor training. Default value is ["0.1","0.5","0.9"].
     */
    public final List<String> forecastTypes() {
        return forecastTypes;
    }

    /**
     * <p>
     * The frequency of predictions in a forecast.
     * </p>
     * <p>
     * Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes),
     * 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every year and "5min"
     * indicates every five minutes.
     * </p>
     * 
     * @return The frequency of predictions in a forecast.</p>
     *         <p>
     *         Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15
     *         minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every
     *         year and "5min" indicates every five minutes.
     */
    public final String forecastFrequency() {
        return forecastFrequency;
    }

    /**
     * For responses, this returns true if the service returned a value for the ForecastDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasForecastDimensions() {
        return forecastDimensions != null && !(forecastDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of dimension (field) names that specify the attributes used to group your time series.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForecastDimensions} method.
     * </p>
     * 
     * @return An array of dimension (field) names that specify the attributes used to group your time series.
     */
    public final List<String> forecastDimensions() {
        return forecastDimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatasetImportJobArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatasetImportJobArns() {
        return datasetImportJobArns != null && !(datasetImportJobArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the ARNs of the dataset import jobs used to import training data for the predictor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasetImportJobArns} method.
     * </p>
     * 
     * @return An array of the ARNs of the dataset import jobs used to import training data for the predictor.
     */
    public final List<String> datasetImportJobArns() {
        return datasetImportJobArns;
    }

    /**
     * <p>
     * The data configuration for your dataset group and any additional datasets.
     * </p>
     * 
     * @return The data configuration for your dataset group and any additional datasets.
     */
    public final DataConfig dataConfig() {
        return dataConfig;
    }

    /**
     * Returns the value of the EncryptionConfig property for this object.
     * 
     * @return The value of the EncryptionConfig property for this object.
     */
    public final EncryptionConfig encryptionConfig() {
        return encryptionConfig;
    }

    /**
     * <p>
     * The ARN and state of the reference predictor. This parameter is only valid for retrained or upgraded predictors.
     * </p>
     * 
     * @return The ARN and state of the reference predictor. This parameter is only valid for retrained or upgraded
     *         predictors.
     */
    public final ReferencePredictorSummary referencePredictorSummary() {
        return referencePredictorSummary;
    }

    /**
     * <p>
     * The estimated time remaining in minutes for the predictor training job to complete.
     * </p>
     * 
     * @return The estimated time remaining in minutes for the predictor training job to complete.
     */
    public final Long estimatedTimeRemainingInMinutes() {
        return estimatedTimeRemainingInMinutes;
    }

    /**
     * <p>
     * The status of the predictor. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the predictor. States include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * In the event of an error, a message detailing the cause of the error.
     * </p>
     * 
     * @return In the event of an error, a message detailing the cause of the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The timestamp of the CreateAutoPredictor request.
     * </p>
     * 
     * @return The timestamp of the CreateAutoPredictor request.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * <p>
     * The accuracy metric used to optimize the predictor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationMetric} will return {@link OptimizationMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #optimizationMetricAsString}.
     * </p>
     * 
     * @return The accuracy metric used to optimize the predictor.
     * @see OptimizationMetric
     */
    public final OptimizationMetric optimizationMetric() {
        return OptimizationMetric.fromValue(optimizationMetric);
    }

    /**
     * <p>
     * The accuracy metric used to optimize the predictor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationMetric} will return {@link OptimizationMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #optimizationMetricAsString}.
     * </p>
     * 
     * @return The accuracy metric used to optimize the predictor.
     * @see OptimizationMetric
     */
    public final String optimizationMetricAsString() {
        return optimizationMetric;
    }

    /**
     * <p>
     * Provides the status and ARN of the Predictor Explainability.
     * </p>
     * 
     * @return Provides the status and ARN of the Predictor Explainability.
     */
    public final ExplainabilityInfo explainabilityInfo() {
        return explainabilityInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(predictorName());
        hashCode = 31 * hashCode + Objects.hashCode(forecastHorizon());
        hashCode = 31 * hashCode + Objects.hashCode(hasForecastTypes() ? forecastTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(forecastFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(hasForecastDimensions() ? forecastDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasetImportJobArns() ? datasetImportJobArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(referencePredictorSummary());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationMetricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoPredictorResponse)) {
            return false;
        }
        DescribeAutoPredictorResponse other = (DescribeAutoPredictorResponse) obj;
        return Objects.equals(predictorArn(), other.predictorArn()) && Objects.equals(predictorName(), other.predictorName())
                && Objects.equals(forecastHorizon(), other.forecastHorizon()) && hasForecastTypes() == other.hasForecastTypes()
                && Objects.equals(forecastTypes(), other.forecastTypes())
                && Objects.equals(forecastFrequency(), other.forecastFrequency())
                && hasForecastDimensions() == other.hasForecastDimensions()
                && Objects.equals(forecastDimensions(), other.forecastDimensions())
                && hasDatasetImportJobArns() == other.hasDatasetImportJobArns()
                && Objects.equals(datasetImportJobArns(), other.datasetImportJobArns())
                && Objects.equals(dataConfig(), other.dataConfig())
                && Objects.equals(encryptionConfig(), other.encryptionConfig())
                && Objects.equals(referencePredictorSummary(), other.referencePredictorSummary())
                && Objects.equals(estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes())
                && Objects.equals(status(), other.status()) && Objects.equals(message(), other.message())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && Objects.equals(optimizationMetricAsString(), other.optimizationMetricAsString())
                && Objects.equals(explainabilityInfo(), other.explainabilityInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAutoPredictorResponse").add("PredictorArn", predictorArn())
                .add("PredictorName", predictorName()).add("ForecastHorizon", forecastHorizon())
                .add("ForecastTypes", hasForecastTypes() ? forecastTypes() : null).add("ForecastFrequency", forecastFrequency())
                .add("ForecastDimensions", hasForecastDimensions() ? forecastDimensions() : null)
                .add("DatasetImportJobArns", hasDatasetImportJobArns() ? datasetImportJobArns() : null)
                .add("DataConfig", dataConfig()).add("EncryptionConfig", encryptionConfig())
                .add("ReferencePredictorSummary", referencePredictorSummary())
                .add("EstimatedTimeRemainingInMinutes", estimatedTimeRemainingInMinutes()).add("Status", status())
                .add("Message", message()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).add("OptimizationMetric", optimizationMetricAsString())
                .add("ExplainabilityInfo", explainabilityInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredictorArn":
            return Optional.ofNullable(clazz.cast(predictorArn()));
        case "PredictorName":
            return Optional.ofNullable(clazz.cast(predictorName()));
        case "ForecastHorizon":
            return Optional.ofNullable(clazz.cast(forecastHorizon()));
        case "ForecastTypes":
            return Optional.ofNullable(clazz.cast(forecastTypes()));
        case "ForecastFrequency":
            return Optional.ofNullable(clazz.cast(forecastFrequency()));
        case "ForecastDimensions":
            return Optional.ofNullable(clazz.cast(forecastDimensions()));
        case "DatasetImportJobArns":
            return Optional.ofNullable(clazz.cast(datasetImportJobArns()));
        case "DataConfig":
            return Optional.ofNullable(clazz.cast(dataConfig()));
        case "EncryptionConfig":
            return Optional.ofNullable(clazz.cast(encryptionConfig()));
        case "ReferencePredictorSummary":
            return Optional.ofNullable(clazz.cast(referencePredictorSummary()));
        case "EstimatedTimeRemainingInMinutes":
            return Optional.ofNullable(clazz.cast(estimatedTimeRemainingInMinutes()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "OptimizationMetric":
            return Optional.ofNullable(clazz.cast(optimizationMetricAsString()));
        case "ExplainabilityInfo":
            return Optional.ofNullable(clazz.cast(explainabilityInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutoPredictorResponse, T> g) {
        return obj -> g.apply((DescribeAutoPredictorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAutoPredictorResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the predictor
         * </p>
         * 
         * @param predictorArn
         *        The Amazon Resource Name (ARN) of the predictor
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorArn(String predictorArn);

        /**
         * <p>
         * The name of the predictor.
         * </p>
         * 
         * @param predictorName
         *        The name of the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorName(String predictorName);

        /**
         * <p>
         * The number of time-steps that the model predicts. The forecast horizon is also called the prediction length.
         * </p>
         * 
         * @param forecastHorizon
         *        The number of time-steps that the model predicts. The forecast horizon is also called the prediction
         *        length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastHorizon(Integer forecastHorizon);

        /**
         * <p>
         * The forecast types used during predictor training. Default value is ["0.1","0.5","0.9"].
         * </p>
         * 
         * @param forecastTypes
         *        The forecast types used during predictor training. Default value is ["0.1","0.5","0.9"].
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastTypes(Collection<String> forecastTypes);

        /**
         * <p>
         * The forecast types used during predictor training. Default value is ["0.1","0.5","0.9"].
         * </p>
         * 
         * @param forecastTypes
         *        The forecast types used during predictor training. Default value is ["0.1","0.5","0.9"].
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastTypes(String... forecastTypes);

        /**
         * <p>
         * The frequency of predictions in a forecast.
         * </p>
         * <p>
         * Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes),
         * 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every year and "5min"
         * indicates every five minutes.
         * </p>
         * 
         * @param forecastFrequency
         *        The frequency of predictions in a forecast.</p>
         *        <p>
         *        Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15
         *        minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every
         *        year and "5min" indicates every five minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastFrequency(String forecastFrequency);

        /**
         * <p>
         * An array of dimension (field) names that specify the attributes used to group your time series.
         * </p>
         * 
         * @param forecastDimensions
         *        An array of dimension (field) names that specify the attributes used to group your time series.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastDimensions(Collection<String> forecastDimensions);

        /**
         * <p>
         * An array of dimension (field) names that specify the attributes used to group your time series.
         * </p>
         * 
         * @param forecastDimensions
         *        An array of dimension (field) names that specify the attributes used to group your time series.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastDimensions(String... forecastDimensions);

        /**
         * <p>
         * An array of the ARNs of the dataset import jobs used to import training data for the predictor.
         * </p>
         * 
         * @param datasetImportJobArns
         *        An array of the ARNs of the dataset import jobs used to import training data for the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobArns(Collection<String> datasetImportJobArns);

        /**
         * <p>
         * An array of the ARNs of the dataset import jobs used to import training data for the predictor.
         * </p>
         * 
         * @param datasetImportJobArns
         *        An array of the ARNs of the dataset import jobs used to import training data for the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobArns(String... datasetImportJobArns);

        /**
         * <p>
         * The data configuration for your dataset group and any additional datasets.
         * </p>
         * 
         * @param dataConfig
         *        The data configuration for your dataset group and any additional datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataConfig(DataConfig dataConfig);

        /**
         * <p>
         * The data configuration for your dataset group and any additional datasets.
         * </p>
         * This is a convenience that creates an instance of the {@link DataConfig.Builder} avoiding the need to create
         * one manually via {@link DataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #dataConfig(DataConfig)}.
         * 
         * @param dataConfig
         *        a consumer that will call methods on {@link DataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataConfig(DataConfig)
         */
        default Builder dataConfig(Consumer<DataConfig.Builder> dataConfig) {
            return dataConfig(DataConfig.builder().applyMutation(dataConfig).build());
        }

        /**
         * Sets the value of the EncryptionConfig property for this object.
         *
         * @param encryptionConfig
         *        The new value for the EncryptionConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(EncryptionConfig encryptionConfig);

        /**
         * Sets the value of the EncryptionConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link EncryptionConfig.Builder} avoiding the need to
         * create one manually via {@link EncryptionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionConfig(EncryptionConfig)}.
         * 
         * @param encryptionConfig
         *        a consumer that will call methods on {@link EncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfig(EncryptionConfig)
         */
        default Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return encryptionConfig(EncryptionConfig.builder().applyMutation(encryptionConfig).build());
        }

        /**
         * <p>
         * The ARN and state of the reference predictor. This parameter is only valid for retrained or upgraded
         * predictors.
         * </p>
         * 
         * @param referencePredictorSummary
         *        The ARN and state of the reference predictor. This parameter is only valid for retrained or upgraded
         *        predictors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencePredictorSummary(ReferencePredictorSummary referencePredictorSummary);

        /**
         * <p>
         * The ARN and state of the reference predictor. This parameter is only valid for retrained or upgraded
         * predictors.
         * </p>
         * This is a convenience that creates an instance of the {@link ReferencePredictorSummary.Builder} avoiding the
         * need to create one manually via {@link ReferencePredictorSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReferencePredictorSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #referencePredictorSummary(ReferencePredictorSummary)}.
         * 
         * @param referencePredictorSummary
         *        a consumer that will call methods on {@link ReferencePredictorSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referencePredictorSummary(ReferencePredictorSummary)
         */
        default Builder referencePredictorSummary(Consumer<ReferencePredictorSummary.Builder> referencePredictorSummary) {
            return referencePredictorSummary(ReferencePredictorSummary.builder().applyMutation(referencePredictorSummary).build());
        }

        /**
         * <p>
         * The estimated time remaining in minutes for the predictor training job to complete.
         * </p>
         * 
         * @param estimatedTimeRemainingInMinutes
         *        The estimated time remaining in minutes for the predictor training job to complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes);

        /**
         * <p>
         * The status of the predictor. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the predictor. States include: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * In the event of an error, a message detailing the cause of the error.
         * </p>
         * 
         * @param message
         *        In the event of an error, a message detailing the cause of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The timestamp of the CreateAutoPredictor request.
         * </p>
         * 
         * @param creationTime
         *        The timestamp of the CreateAutoPredictor request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The accuracy metric used to optimize the predictor.
         * </p>
         * 
         * @param optimizationMetric
         *        The accuracy metric used to optimize the predictor.
         * @see OptimizationMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationMetric
         */
        Builder optimizationMetric(String optimizationMetric);

        /**
         * <p>
         * The accuracy metric used to optimize the predictor.
         * </p>
         * 
         * @param optimizationMetric
         *        The accuracy metric used to optimize the predictor.
         * @see OptimizationMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationMetric
         */
        Builder optimizationMetric(OptimizationMetric optimizationMetric);

        /**
         * <p>
         * Provides the status and ARN of the Predictor Explainability.
         * </p>
         * 
         * @param explainabilityInfo
         *        Provides the status and ARN of the Predictor Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityInfo(ExplainabilityInfo explainabilityInfo);

        /**
         * <p>
         * Provides the status and ARN of the Predictor Explainability.
         * </p>
         * This is a convenience that creates an instance of the {@link ExplainabilityInfo.Builder} avoiding the need to
         * create one manually via {@link ExplainabilityInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExplainabilityInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #explainabilityInfo(ExplainabilityInfo)}.
         * 
         * @param explainabilityInfo
         *        a consumer that will call methods on {@link ExplainabilityInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #explainabilityInfo(ExplainabilityInfo)
         */
        default Builder explainabilityInfo(Consumer<ExplainabilityInfo.Builder> explainabilityInfo) {
            return explainabilityInfo(ExplainabilityInfo.builder().applyMutation(explainabilityInfo).build());
        }
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String predictorArn;

        private String predictorName;

        private Integer forecastHorizon;

        private List<String> forecastTypes = DefaultSdkAutoConstructList.getInstance();

        private String forecastFrequency;

        private List<String> forecastDimensions = DefaultSdkAutoConstructList.getInstance();

        private List<String> datasetImportJobArns = DefaultSdkAutoConstructList.getInstance();

        private DataConfig dataConfig;

        private EncryptionConfig encryptionConfig;

        private ReferencePredictorSummary referencePredictorSummary;

        private Long estimatedTimeRemainingInMinutes;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private String optimizationMetric;

        private ExplainabilityInfo explainabilityInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoPredictorResponse model) {
            super(model);
            predictorArn(model.predictorArn);
            predictorName(model.predictorName);
            forecastHorizon(model.forecastHorizon);
            forecastTypes(model.forecastTypes);
            forecastFrequency(model.forecastFrequency);
            forecastDimensions(model.forecastDimensions);
            datasetImportJobArns(model.datasetImportJobArns);
            dataConfig(model.dataConfig);
            encryptionConfig(model.encryptionConfig);
            referencePredictorSummary(model.referencePredictorSummary);
            estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            optimizationMetric(model.optimizationMetric);
            explainabilityInfo(model.explainabilityInfo);
        }

        public final String getPredictorArn() {
            return predictorArn;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        @Override
        @Transient
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final String getPredictorName() {
            return predictorName;
        }

        public final void setPredictorName(String predictorName) {
            this.predictorName = predictorName;
        }

        @Override
        @Transient
        public final Builder predictorName(String predictorName) {
            this.predictorName = predictorName;
            return this;
        }

        public final Integer getForecastHorizon() {
            return forecastHorizon;
        }

        public final void setForecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
        }

        @Override
        @Transient
        public final Builder forecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
            return this;
        }

        public final Collection<String> getForecastTypes() {
            if (forecastTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return forecastTypes;
        }

        public final void setForecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
        }

        @Override
        @Transient
        public final Builder forecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder forecastTypes(String... forecastTypes) {
            forecastTypes(Arrays.asList(forecastTypes));
            return this;
        }

        public final String getForecastFrequency() {
            return forecastFrequency;
        }

        public final void setForecastFrequency(String forecastFrequency) {
            this.forecastFrequency = forecastFrequency;
        }

        @Override
        @Transient
        public final Builder forecastFrequency(String forecastFrequency) {
            this.forecastFrequency = forecastFrequency;
            return this;
        }

        public final Collection<String> getForecastDimensions() {
            if (forecastDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return forecastDimensions;
        }

        public final void setForecastDimensions(Collection<String> forecastDimensions) {
            this.forecastDimensions = ForecastDimensionsCopier.copy(forecastDimensions);
        }

        @Override
        @Transient
        public final Builder forecastDimensions(Collection<String> forecastDimensions) {
            this.forecastDimensions = ForecastDimensionsCopier.copy(forecastDimensions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder forecastDimensions(String... forecastDimensions) {
            forecastDimensions(Arrays.asList(forecastDimensions));
            return this;
        }

        public final Collection<String> getDatasetImportJobArns() {
            if (datasetImportJobArns instanceof SdkAutoConstructList) {
                return null;
            }
            return datasetImportJobArns;
        }

        public final void setDatasetImportJobArns(Collection<String> datasetImportJobArns) {
            this.datasetImportJobArns = ArnListCopier.copy(datasetImportJobArns);
        }

        @Override
        @Transient
        public final Builder datasetImportJobArns(Collection<String> datasetImportJobArns) {
            this.datasetImportJobArns = ArnListCopier.copy(datasetImportJobArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder datasetImportJobArns(String... datasetImportJobArns) {
            datasetImportJobArns(Arrays.asList(datasetImportJobArns));
            return this;
        }

        public final DataConfig.Builder getDataConfig() {
            return dataConfig != null ? dataConfig.toBuilder() : null;
        }

        public final void setDataConfig(DataConfig.BuilderImpl dataConfig) {
            this.dataConfig = dataConfig != null ? dataConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder dataConfig(DataConfig dataConfig) {
            this.dataConfig = dataConfig;
            return this;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return encryptionConfig != null ? encryptionConfig.toBuilder() : null;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final ReferencePredictorSummary.Builder getReferencePredictorSummary() {
            return referencePredictorSummary != null ? referencePredictorSummary.toBuilder() : null;
        }

        public final void setReferencePredictorSummary(ReferencePredictorSummary.BuilderImpl referencePredictorSummary) {
            this.referencePredictorSummary = referencePredictorSummary != null ? referencePredictorSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder referencePredictorSummary(ReferencePredictorSummary referencePredictorSummary) {
            this.referencePredictorSummary = referencePredictorSummary;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        @Transient
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        @Transient
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final String getOptimizationMetric() {
            return optimizationMetric;
        }

        public final void setOptimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
        }

        @Override
        @Transient
        public final Builder optimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
            return this;
        }

        @Override
        @Transient
        public final Builder optimizationMetric(OptimizationMetric optimizationMetric) {
            this.optimizationMetric(optimizationMetric == null ? null : optimizationMetric.toString());
            return this;
        }

        public final ExplainabilityInfo.Builder getExplainabilityInfo() {
            return explainabilityInfo != null ? explainabilityInfo.toBuilder() : null;
        }

        public final void setExplainabilityInfo(ExplainabilityInfo.BuilderImpl explainabilityInfo) {
            this.explainabilityInfo = explainabilityInfo != null ? explainabilityInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder explainabilityInfo(ExplainabilityInfo explainabilityInfo) {
            this.explainabilityInfo = explainabilityInfo;
            return this;
        }

        @Override
        public DescribeAutoPredictorResponse build() {
            return new DescribeAutoPredictorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
