/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExplainabilityResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribeExplainabilityResponse.Builder, DescribeExplainabilityResponse> {
    private static final SdkField<String> EXPLAINABILITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExplainabilityArn").getter(getter(DescribeExplainabilityResponse::explainabilityArn))
            .setter(setter(Builder::explainabilityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityArn").build()).build();

    private static final SdkField<String> EXPLAINABILITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExplainabilityName").getter(getter(DescribeExplainabilityResponse::explainabilityName))
            .setter(setter(Builder::explainabilityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityName").build())
            .build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DescribeExplainabilityResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<ExplainabilityConfig> EXPLAINABILITY_CONFIG_FIELD = SdkField
            .<ExplainabilityConfig> builder(MarshallingType.SDK_POJO).memberName("ExplainabilityConfig")
            .getter(getter(DescribeExplainabilityResponse::explainabilityConfig)).setter(setter(Builder::explainabilityConfig))
            .constructor(ExplainabilityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityConfig").build())
            .build();

    private static final SdkField<Boolean> ENABLE_VISUALIZATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableVisualization").getter(getter(DescribeExplainabilityResponse::enableVisualization))
            .setter(setter(Builder::enableVisualization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableVisualization").build())
            .build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(DescribeExplainabilityResponse::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.<Schema> builder(MarshallingType.SDK_POJO).memberName("Schema")
            .getter(getter(DescribeExplainabilityResponse::schema)).setter(setter(Builder::schema)).constructor(Schema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<String> START_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartDateTime").getter(getter(DescribeExplainabilityResponse::startDateTime))
            .setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateTime").build()).build();

    private static final SdkField<String> END_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndDateTime").getter(getter(DescribeExplainabilityResponse::endDateTime))
            .setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateTime").build()).build();

    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedTimeRemainingInMinutes")
            .getter(getter(DescribeExplainabilityResponse::estimatedTimeRemainingInMinutes))
            .setter(setter(Builder::estimatedTimeRemainingInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes")
                    .build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribeExplainabilityResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeExplainabilityResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeExplainabilityResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribeExplainabilityResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITY_ARN_FIELD,
            EXPLAINABILITY_NAME_FIELD, RESOURCE_ARN_FIELD, EXPLAINABILITY_CONFIG_FIELD, ENABLE_VISUALIZATION_FIELD,
            DATA_SOURCE_FIELD, SCHEMA_FIELD, START_DATE_TIME_FIELD, END_DATE_TIME_FIELD,
            ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD, MESSAGE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD));

    private final String explainabilityArn;

    private final String explainabilityName;

    private final String resourceArn;

    private final ExplainabilityConfig explainabilityConfig;

    private final Boolean enableVisualization;

    private final DataSource dataSource;

    private final Schema schema;

    private final String startDateTime;

    private final String endDateTime;

    private final Long estimatedTimeRemainingInMinutes;

    private final String message;

    private final String status;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private DescribeExplainabilityResponse(BuilderImpl builder) {
        super(builder);
        this.explainabilityArn = builder.explainabilityArn;
        this.explainabilityName = builder.explainabilityName;
        this.resourceArn = builder.resourceArn;
        this.explainabilityConfig = builder.explainabilityConfig;
        this.enableVisualization = builder.enableVisualization;
        this.dataSource = builder.dataSource;
        this.schema = builder.schema;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.message = builder.message;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Explainability.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Explainability.
     */
    public final String explainabilityArn() {
        return explainabilityArn;
    }

    /**
     * <p>
     * The name of the Explainability.
     * </p>
     * 
     * @return The name of the Explainability.
     */
    public final String explainabilityName() {
        return explainabilityName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The configuration settings that define the granularity of time series and time points for the Explainability.
     * </p>
     * 
     * @return The configuration settings that define the granularity of time series and time points for the
     *         Explainability.
     */
    public final ExplainabilityConfig explainabilityConfig() {
        return explainabilityConfig;
    }

    /**
     * <p>
     * Whether the visualization was enabled for the Explainability resource.
     * </p>
     * 
     * @return Whether the visualization was enabled for the Explainability resource.
     */
    public final Boolean enableVisualization() {
        return enableVisualization;
    }

    /**
     * Returns the value of the DataSource property for this object.
     * 
     * @return The value of the DataSource property for this object.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * Returns the value of the Schema property for this object.
     * 
     * @return The value of the Schema property for this object.
     */
    public final Schema schema() {
        return schema;
    }

    /**
     * <p>
     * If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, the first time point in the Explainability.
     * </p>
     * 
     * @return If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, the first time point in the
     *         Explainability.
     */
    public final String startDateTime() {
        return startDateTime;
    }

    /**
     * <p>
     * If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, the last time point in the Explainability.
     * </p>
     * 
     * @return If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, the last time point in the
     *         Explainability.
     */
    public final String endDateTime() {
        return endDateTime;
    }

    /**
     * <p>
     * The estimated time remaining in minutes for the <a>CreateExplainability</a> job to complete.
     * </p>
     * 
     * @return The estimated time remaining in minutes for the <a>CreateExplainability</a> job to complete.
     */
    public final Long estimatedTimeRemainingInMinutes() {
        return estimatedTimeRemainingInMinutes;
    }

    /**
     * <p>
     * If an error occurred, a message about the error.
     * </p>
     * 
     * @return If an error occurred, a message about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The status of the Explainability resource. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the Explainability resource. States include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * When the Explainability resource was created.
     * </p>
     * 
     * @return When the Explainability resource was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityArn());
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(enableVisualization());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExplainabilityResponse)) {
            return false;
        }
        DescribeExplainabilityResponse other = (DescribeExplainabilityResponse) obj;
        return Objects.equals(explainabilityArn(), other.explainabilityArn())
                && Objects.equals(explainabilityName(), other.explainabilityName())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(explainabilityConfig(), other.explainabilityConfig())
                && Objects.equals(enableVisualization(), other.enableVisualization())
                && Objects.equals(dataSource(), other.dataSource()) && Objects.equals(schema(), other.schema())
                && Objects.equals(startDateTime(), other.startDateTime()) && Objects.equals(endDateTime(), other.endDateTime())
                && Objects.equals(estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes())
                && Objects.equals(message(), other.message()) && Objects.equals(status(), other.status())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExplainabilityResponse").add("ExplainabilityArn", explainabilityArn())
                .add("ExplainabilityName", explainabilityName()).add("ResourceArn", resourceArn())
                .add("ExplainabilityConfig", explainabilityConfig()).add("EnableVisualization", enableVisualization())
                .add("DataSource", dataSource()).add("Schema", schema()).add("StartDateTime", startDateTime())
                .add("EndDateTime", endDateTime()).add("EstimatedTimeRemainingInMinutes", estimatedTimeRemainingInMinutes())
                .add("Message", message()).add("Status", status()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExplainabilityArn":
            return Optional.ofNullable(clazz.cast(explainabilityArn()));
        case "ExplainabilityName":
            return Optional.ofNullable(clazz.cast(explainabilityName()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ExplainabilityConfig":
            return Optional.ofNullable(clazz.cast(explainabilityConfig()));
        case "EnableVisualization":
            return Optional.ofNullable(clazz.cast(enableVisualization()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "StartDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "EndDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        case "EstimatedTimeRemainingInMinutes":
            return Optional.ofNullable(clazz.cast(estimatedTimeRemainingInMinutes()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExplainabilityResponse, T> g) {
        return obj -> g.apply((DescribeExplainabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExplainabilityResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Explainability.
         * </p>
         * 
         * @param explainabilityArn
         *        The Amazon Resource Name (ARN) of the Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityArn(String explainabilityArn);

        /**
         * <p>
         * The name of the Explainability.
         * </p>
         * 
         * @param explainabilityName
         *        The name of the Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityName(String explainabilityName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability
         *        resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The configuration settings that define the granularity of time series and time points for the Explainability.
         * </p>
         * 
         * @param explainabilityConfig
         *        The configuration settings that define the granularity of time series and time points for the
         *        Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityConfig(ExplainabilityConfig explainabilityConfig);

        /**
         * <p>
         * The configuration settings that define the granularity of time series and time points for the Explainability.
         * </p>
         * This is a convenience that creates an instance of the {@link ExplainabilityConfig.Builder} avoiding the need
         * to create one manually via {@link ExplainabilityConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExplainabilityConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #explainabilityConfig(ExplainabilityConfig)}.
         * 
         * @param explainabilityConfig
         *        a consumer that will call methods on {@link ExplainabilityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #explainabilityConfig(ExplainabilityConfig)
         */
        default Builder explainabilityConfig(Consumer<ExplainabilityConfig.Builder> explainabilityConfig) {
            return explainabilityConfig(ExplainabilityConfig.builder().applyMutation(explainabilityConfig).build());
        }

        /**
         * <p>
         * Whether the visualization was enabled for the Explainability resource.
         * </p>
         * 
         * @param enableVisualization
         *        Whether the visualization was enabled for the Explainability resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableVisualization(Boolean enableVisualization);

        /**
         * Sets the value of the DataSource property for this object.
         *
         * @param dataSource
         *        The new value for the DataSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * Sets the value of the DataSource property for this object.
         *
         * This is a convenience that creates an instance of the {@link DataSource.Builder} avoiding the need to create
         * one manually via {@link DataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * Sets the value of the Schema property for this object.
         *
         * @param schema
         *        The new value for the Schema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Schema schema);

        /**
         * Sets the value of the Schema property for this object.
         *
         * This is a convenience that creates an instance of the {@link Schema.Builder} avoiding the need to create one
         * manually via {@link Schema#builder()}.
         *
         * When the {@link Consumer} completes, {@link Schema.Builder#build()} is called immediately and its result is
         * passed to {@link #schema(Schema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link Schema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(Schema)
         */
        default Builder schema(Consumer<Schema.Builder> schema) {
            return schema(Schema.builder().applyMutation(schema).build());
        }

        /**
         * <p>
         * If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, the first time point in the
         * Explainability.
         * </p>
         * 
         * @param startDateTime
         *        If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, the first time point in the
         *        Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateTime(String startDateTime);

        /**
         * <p>
         * If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, the last time point in the
         * Explainability.
         * </p>
         * 
         * @param endDateTime
         *        If <code>TimePointGranularity</code> is set to <code>SPECIFIC</code>, the last time point in the
         *        Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(String endDateTime);

        /**
         * <p>
         * The estimated time remaining in minutes for the <a>CreateExplainability</a> job to complete.
         * </p>
         * 
         * @param estimatedTimeRemainingInMinutes
         *        The estimated time remaining in minutes for the <a>CreateExplainability</a> job to complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes);

        /**
         * <p>
         * If an error occurred, a message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, a message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The status of the Explainability resource. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Explainability resource. States include: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * When the Explainability resource was created.
         * </p>
         * 
         * @param creationTime
         *        When the Explainability resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String explainabilityArn;

        private String explainabilityName;

        private String resourceArn;

        private ExplainabilityConfig explainabilityConfig;

        private Boolean enableVisualization;

        private DataSource dataSource;

        private Schema schema;

        private String startDateTime;

        private String endDateTime;

        private Long estimatedTimeRemainingInMinutes;

        private String message;

        private String status;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExplainabilityResponse model) {
            super(model);
            explainabilityArn(model.explainabilityArn);
            explainabilityName(model.explainabilityName);
            resourceArn(model.resourceArn);
            explainabilityConfig(model.explainabilityConfig);
            enableVisualization(model.enableVisualization);
            dataSource(model.dataSource);
            schema(model.schema);
            startDateTime(model.startDateTime);
            endDateTime(model.endDateTime);
            estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            message(model.message);
            status(model.status);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getExplainabilityArn() {
            return explainabilityArn;
        }

        public final void setExplainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
        }

        @Override
        @Transient
        public final Builder explainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
            return this;
        }

        public final String getExplainabilityName() {
            return explainabilityName;
        }

        public final void setExplainabilityName(String explainabilityName) {
            this.explainabilityName = explainabilityName;
        }

        @Override
        @Transient
        public final Builder explainabilityName(String explainabilityName) {
            this.explainabilityName = explainabilityName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final ExplainabilityConfig.Builder getExplainabilityConfig() {
            return explainabilityConfig != null ? explainabilityConfig.toBuilder() : null;
        }

        public final void setExplainabilityConfig(ExplainabilityConfig.BuilderImpl explainabilityConfig) {
            this.explainabilityConfig = explainabilityConfig != null ? explainabilityConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder explainabilityConfig(ExplainabilityConfig explainabilityConfig) {
            this.explainabilityConfig = explainabilityConfig;
            return this;
        }

        public final Boolean getEnableVisualization() {
            return enableVisualization;
        }

        public final void setEnableVisualization(Boolean enableVisualization) {
            this.enableVisualization = enableVisualization;
        }

        @Override
        @Transient
        public final Builder enableVisualization(Boolean enableVisualization) {
            this.enableVisualization = enableVisualization;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        @Transient
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Schema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        @Transient
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public final String getStartDateTime() {
            return startDateTime;
        }

        public final void setStartDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        @Transient
        public final Builder startDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final String getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        @Transient
        public final Builder endDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        @Transient
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        @Transient
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public DescribeExplainabilityResponse build() {
            return new DescribeExplainabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
