/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccuracyMetricsResponse extends ForecastResponse implements
        ToCopyableBuilder<GetAccuracyMetricsResponse.Builder, GetAccuracyMetricsResponse> {
    private static final SdkField<List<EvaluationResult>> PREDICTOR_EVALUATION_RESULTS_FIELD = SdkField
            .<List<EvaluationResult>> builder(MarshallingType.LIST)
            .memberName("PredictorEvaluationResults")
            .getter(getter(GetAccuracyMetricsResponse::predictorEvaluationResults))
            .setter(setter(Builder::predictorEvaluationResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorEvaluationResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_AUTO_PREDICTOR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsAutoPredictor").getter(getter(GetAccuracyMetricsResponse::isAutoPredictor))
            .setter(setter(Builder::isAutoPredictor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAutoPredictor").build()).build();

    private static final SdkField<String> AUTO_ML_OVERRIDE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLOverrideStrategy").getter(getter(GetAccuracyMetricsResponse::autoMLOverrideStrategyAsString))
            .setter(setter(Builder::autoMLOverrideStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLOverrideStrategy").build())
            .build();

    private static final SdkField<String> OPTIMIZATION_METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationMetric").getter(getter(GetAccuracyMetricsResponse::optimizationMetricAsString))
            .setter(setter(Builder::optimizationMetric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationMetric").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREDICTOR_EVALUATION_RESULTS_FIELD, IS_AUTO_PREDICTOR_FIELD, AUTO_ML_OVERRIDE_STRATEGY_FIELD,
            OPTIMIZATION_METRIC_FIELD));

    private final List<EvaluationResult> predictorEvaluationResults;

    private final Boolean isAutoPredictor;

    private final String autoMLOverrideStrategy;

    private final String optimizationMetric;

    private GetAccuracyMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.predictorEvaluationResults = builder.predictorEvaluationResults;
        this.isAutoPredictor = builder.isAutoPredictor;
        this.autoMLOverrideStrategy = builder.autoMLOverrideStrategy;
        this.optimizationMetric = builder.optimizationMetric;
    }

    /**
     * For responses, this returns true if the service returned a value for the PredictorEvaluationResults property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPredictorEvaluationResults() {
        return predictorEvaluationResults != null && !(predictorEvaluationResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of results from evaluating the predictor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPredictorEvaluationResults} method.
     * </p>
     * 
     * @return An array of results from evaluating the predictor.
     */
    public final List<EvaluationResult> predictorEvaluationResults() {
        return predictorEvaluationResults;
    }

    /**
     * <p>
     * Whether the predictor was created with <a>CreateAutoPredictor</a>.
     * </p>
     * 
     * @return Whether the predictor was created with <a>CreateAutoPredictor</a>.
     */
    public final Boolean isAutoPredictor() {
        return isAutoPredictor;
    }

    /**
     * <note>
     * <p>
     * The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact AWS Support
     * or your account manager to learn more about access privileges.
     * </p>
     * </note>
     * <p>
     * The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified, the AutoML
     * strategy optimizes predictor accuracy.
     * </p>
     * <p>
     * This parameter is only valid for predictors trained using AutoML.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLOverrideStrategy} will return {@link AutoMLOverrideStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoMLOverrideStrategyAsString}.
     * </p>
     * 
     * @return <p>
     *         The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact AWS
     *         Support or your account manager to learn more about access privileges.
     *         </p>
     *         </note>
     *         <p>
     *         The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified, the
     *         AutoML strategy optimizes predictor accuracy.
     *         </p>
     *         <p>
     *         This parameter is only valid for predictors trained using AutoML.
     * @see AutoMLOverrideStrategy
     */
    public final AutoMLOverrideStrategy autoMLOverrideStrategy() {
        return AutoMLOverrideStrategy.fromValue(autoMLOverrideStrategy);
    }

    /**
     * <note>
     * <p>
     * The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact AWS Support
     * or your account manager to learn more about access privileges.
     * </p>
     * </note>
     * <p>
     * The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified, the AutoML
     * strategy optimizes predictor accuracy.
     * </p>
     * <p>
     * This parameter is only valid for predictors trained using AutoML.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLOverrideStrategy} will return {@link AutoMLOverrideStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoMLOverrideStrategyAsString}.
     * </p>
     * 
     * @return <p>
     *         The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact AWS
     *         Support or your account manager to learn more about access privileges.
     *         </p>
     *         </note>
     *         <p>
     *         The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified, the
     *         AutoML strategy optimizes predictor accuracy.
     *         </p>
     *         <p>
     *         This parameter is only valid for predictors trained using AutoML.
     * @see AutoMLOverrideStrategy
     */
    public final String autoMLOverrideStrategyAsString() {
        return autoMLOverrideStrategy;
    }

    /**
     * <p>
     * The accuracy metric used to optimize the predictor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationMetric} will return {@link OptimizationMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #optimizationMetricAsString}.
     * </p>
     * 
     * @return The accuracy metric used to optimize the predictor.
     * @see OptimizationMetric
     */
    public final OptimizationMetric optimizationMetric() {
        return OptimizationMetric.fromValue(optimizationMetric);
    }

    /**
     * <p>
     * The accuracy metric used to optimize the predictor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationMetric} will return {@link OptimizationMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #optimizationMetricAsString}.
     * </p>
     * 
     * @return The accuracy metric used to optimize the predictor.
     * @see OptimizationMetric
     */
    public final String optimizationMetricAsString() {
        return optimizationMetric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPredictorEvaluationResults() ? predictorEvaluationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isAutoPredictor());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLOverrideStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationMetricAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccuracyMetricsResponse)) {
            return false;
        }
        GetAccuracyMetricsResponse other = (GetAccuracyMetricsResponse) obj;
        return hasPredictorEvaluationResults() == other.hasPredictorEvaluationResults()
                && Objects.equals(predictorEvaluationResults(), other.predictorEvaluationResults())
                && Objects.equals(isAutoPredictor(), other.isAutoPredictor())
                && Objects.equals(autoMLOverrideStrategyAsString(), other.autoMLOverrideStrategyAsString())
                && Objects.equals(optimizationMetricAsString(), other.optimizationMetricAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccuracyMetricsResponse")
                .add("PredictorEvaluationResults", hasPredictorEvaluationResults() ? predictorEvaluationResults() : null)
                .add("IsAutoPredictor", isAutoPredictor()).add("AutoMLOverrideStrategy", autoMLOverrideStrategyAsString())
                .add("OptimizationMetric", optimizationMetricAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredictorEvaluationResults":
            return Optional.ofNullable(clazz.cast(predictorEvaluationResults()));
        case "IsAutoPredictor":
            return Optional.ofNullable(clazz.cast(isAutoPredictor()));
        case "AutoMLOverrideStrategy":
            return Optional.ofNullable(clazz.cast(autoMLOverrideStrategyAsString()));
        case "OptimizationMetric":
            return Optional.ofNullable(clazz.cast(optimizationMetricAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccuracyMetricsResponse, T> g) {
        return obj -> g.apply((GetAccuracyMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccuracyMetricsResponse> {
        /**
         * <p>
         * An array of results from evaluating the predictor.
         * </p>
         * 
         * @param predictorEvaluationResults
         *        An array of results from evaluating the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorEvaluationResults(Collection<EvaluationResult> predictorEvaluationResults);

        /**
         * <p>
         * An array of results from evaluating the predictor.
         * </p>
         * 
         * @param predictorEvaluationResults
         *        An array of results from evaluating the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorEvaluationResults(EvaluationResult... predictorEvaluationResults);

        /**
         * <p>
         * An array of results from evaluating the predictor.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EvaluationResult>.Builder} avoiding the
         * need to create one manually via {@link List<EvaluationResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EvaluationResult>.Builder#build()} is called immediately and
         * its result is passed to {@link #predictorEvaluationResults(List<EvaluationResult>)}.
         * 
         * @param predictorEvaluationResults
         *        a consumer that will call methods on {@link List<EvaluationResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictorEvaluationResults(List<EvaluationResult>)
         */
        Builder predictorEvaluationResults(Consumer<EvaluationResult.Builder>... predictorEvaluationResults);

        /**
         * <p>
         * Whether the predictor was created with <a>CreateAutoPredictor</a>.
         * </p>
         * 
         * @param isAutoPredictor
         *        Whether the predictor was created with <a>CreateAutoPredictor</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAutoPredictor(Boolean isAutoPredictor);

        /**
         * <note>
         * <p>
         * The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact AWS
         * Support or your account manager to learn more about access privileges.
         * </p>
         * </note>
         * <p>
         * The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified, the
         * AutoML strategy optimizes predictor accuracy.
         * </p>
         * <p>
         * This parameter is only valid for predictors trained using AutoML.
         * </p>
         * 
         * @param autoMLOverrideStrategy
         *        <p>
         *        The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact
         *        AWS Support or your account manager to learn more about access privileges.
         *        </p>
         *        </note>
         *        <p>
         *        The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified,
         *        the AutoML strategy optimizes predictor accuracy.
         *        </p>
         *        <p>
         *        This parameter is only valid for predictors trained using AutoML.
         * @see AutoMLOverrideStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLOverrideStrategy
         */
        Builder autoMLOverrideStrategy(String autoMLOverrideStrategy);

        /**
         * <note>
         * <p>
         * The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact AWS
         * Support or your account manager to learn more about access privileges.
         * </p>
         * </note>
         * <p>
         * The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified, the
         * AutoML strategy optimizes predictor accuracy.
         * </p>
         * <p>
         * This parameter is only valid for predictors trained using AutoML.
         * </p>
         * 
         * @param autoMLOverrideStrategy
         *        <p>
         *        The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact
         *        AWS Support or your account manager to learn more about access privileges.
         *        </p>
         *        </note>
         *        <p>
         *        The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified,
         *        the AutoML strategy optimizes predictor accuracy.
         *        </p>
         *        <p>
         *        This parameter is only valid for predictors trained using AutoML.
         * @see AutoMLOverrideStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLOverrideStrategy
         */
        Builder autoMLOverrideStrategy(AutoMLOverrideStrategy autoMLOverrideStrategy);

        /**
         * <p>
         * The accuracy metric used to optimize the predictor.
         * </p>
         * 
         * @param optimizationMetric
         *        The accuracy metric used to optimize the predictor.
         * @see OptimizationMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationMetric
         */
        Builder optimizationMetric(String optimizationMetric);

        /**
         * <p>
         * The accuracy metric used to optimize the predictor.
         * </p>
         * 
         * @param optimizationMetric
         *        The accuracy metric used to optimize the predictor.
         * @see OptimizationMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationMetric
         */
        Builder optimizationMetric(OptimizationMetric optimizationMetric);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<EvaluationResult> predictorEvaluationResults = DefaultSdkAutoConstructList.getInstance();

        private Boolean isAutoPredictor;

        private String autoMLOverrideStrategy;

        private String optimizationMetric;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccuracyMetricsResponse model) {
            super(model);
            predictorEvaluationResults(model.predictorEvaluationResults);
            isAutoPredictor(model.isAutoPredictor);
            autoMLOverrideStrategy(model.autoMLOverrideStrategy);
            optimizationMetric(model.optimizationMetric);
        }

        public final List<EvaluationResult.Builder> getPredictorEvaluationResults() {
            List<EvaluationResult.Builder> result = PredictorEvaluationResultsCopier
                    .copyToBuilder(this.predictorEvaluationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredictorEvaluationResults(Collection<EvaluationResult.BuilderImpl> predictorEvaluationResults) {
            this.predictorEvaluationResults = PredictorEvaluationResultsCopier.copyFromBuilder(predictorEvaluationResults);
        }

        @Override
        @Transient
        public final Builder predictorEvaluationResults(Collection<EvaluationResult> predictorEvaluationResults) {
            this.predictorEvaluationResults = PredictorEvaluationResultsCopier.copy(predictorEvaluationResults);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder predictorEvaluationResults(EvaluationResult... predictorEvaluationResults) {
            predictorEvaluationResults(Arrays.asList(predictorEvaluationResults));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder predictorEvaluationResults(Consumer<EvaluationResult.Builder>... predictorEvaluationResults) {
            predictorEvaluationResults(Stream.of(predictorEvaluationResults)
                    .map(c -> EvaluationResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsAutoPredictor() {
            return isAutoPredictor;
        }

        public final void setIsAutoPredictor(Boolean isAutoPredictor) {
            this.isAutoPredictor = isAutoPredictor;
        }

        @Override
        @Transient
        public final Builder isAutoPredictor(Boolean isAutoPredictor) {
            this.isAutoPredictor = isAutoPredictor;
            return this;
        }

        public final String getAutoMLOverrideStrategy() {
            return autoMLOverrideStrategy;
        }

        public final void setAutoMLOverrideStrategy(String autoMLOverrideStrategy) {
            this.autoMLOverrideStrategy = autoMLOverrideStrategy;
        }

        @Override
        @Transient
        public final Builder autoMLOverrideStrategy(String autoMLOverrideStrategy) {
            this.autoMLOverrideStrategy = autoMLOverrideStrategy;
            return this;
        }

        @Override
        @Transient
        public final Builder autoMLOverrideStrategy(AutoMLOverrideStrategy autoMLOverrideStrategy) {
            this.autoMLOverrideStrategy(autoMLOverrideStrategy == null ? null : autoMLOverrideStrategy.toString());
            return this;
        }

        public final String getOptimizationMetric() {
            return optimizationMetric;
        }

        public final void setOptimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
        }

        @Override
        @Transient
        public final Builder optimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
            return this;
        }

        @Override
        @Transient
        public final Builder optimizationMetric(OptimizationMetric optimizationMetric) {
            this.optimizationMetric(optimizationMetric == null ? null : optimizationMetric.toString());
            return this;
        }

        @Override
        public GetAccuracyMetricsResponse build() {
            return new GetAccuracyMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
