/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The weighted loss value for a quantile. This object is part of the <a>Metrics</a> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WeightedQuantileLoss implements SdkPojo, Serializable,
        ToCopyableBuilder<WeightedQuantileLoss.Builder, WeightedQuantileLoss> {
    private static final SdkField<Double> QUANTILE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Quantile").getter(getter(WeightedQuantileLoss::quantile)).setter(setter(Builder::quantile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantile").build()).build();

    private static final SdkField<Double> LOSS_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LossValue").getter(getter(WeightedQuantileLoss::lossValue)).setter(setter(Builder::lossValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LossValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTILE_FIELD,
            LOSS_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double quantile;

    private final Double lossValue;

    private WeightedQuantileLoss(BuilderImpl builder) {
        this.quantile = builder.quantile;
        this.lossValue = builder.lossValue;
    }

    /**
     * <p>
     * The quantile. Quantiles divide a probability distribution into regions of equal probability. For example, if the
     * distribution was divided into 5 regions of equal probability, the quantiles would be 0.2, 0.4, 0.6, and 0.8.
     * </p>
     * 
     * @return The quantile. Quantiles divide a probability distribution into regions of equal probability. For example,
     *         if the distribution was divided into 5 regions of equal probability, the quantiles would be 0.2, 0.4,
     *         0.6, and 0.8.
     */
    public final Double quantile() {
        return quantile;
    }

    /**
     * <p>
     * The difference between the predicted value and the actual value over the quantile, weighted (normalized) by
     * dividing by the sum over all quantiles.
     * </p>
     * 
     * @return The difference between the predicted value and the actual value over the quantile, weighted (normalized)
     *         by dividing by the sum over all quantiles.
     */
    public final Double lossValue() {
        return lossValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quantile());
        hashCode = 31 * hashCode + Objects.hashCode(lossValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeightedQuantileLoss)) {
            return false;
        }
        WeightedQuantileLoss other = (WeightedQuantileLoss) obj;
        return Objects.equals(quantile(), other.quantile()) && Objects.equals(lossValue(), other.lossValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WeightedQuantileLoss").add("Quantile", quantile()).add("LossValue", lossValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quantile":
            return Optional.ofNullable(clazz.cast(quantile()));
        case "LossValue":
            return Optional.ofNullable(clazz.cast(lossValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WeightedQuantileLoss, T> g) {
        return obj -> g.apply((WeightedQuantileLoss) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WeightedQuantileLoss> {
        /**
         * <p>
         * The quantile. Quantiles divide a probability distribution into regions of equal probability. For example, if
         * the distribution was divided into 5 regions of equal probability, the quantiles would be 0.2, 0.4, 0.6, and
         * 0.8.
         * </p>
         * 
         * @param quantile
         *        The quantile. Quantiles divide a probability distribution into regions of equal probability. For
         *        example, if the distribution was divided into 5 regions of equal probability, the quantiles would be
         *        0.2, 0.4, 0.6, and 0.8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantile(Double quantile);

        /**
         * <p>
         * The difference between the predicted value and the actual value over the quantile, weighted (normalized) by
         * dividing by the sum over all quantiles.
         * </p>
         * 
         * @param lossValue
         *        The difference between the predicted value and the actual value over the quantile, weighted
         *        (normalized) by dividing by the sum over all quantiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lossValue(Double lossValue);
    }

    static final class BuilderImpl implements Builder {
        private Double quantile;

        private Double lossValue;

        private BuilderImpl() {
        }

        private BuilderImpl(WeightedQuantileLoss model) {
            quantile(model.quantile);
            lossValue(model.lossValue);
        }

        public final Double getQuantile() {
            return quantile;
        }

        public final void setQuantile(Double quantile) {
            this.quantile = quantile;
        }

        @Override
        @Transient
        public final Builder quantile(Double quantile) {
            this.quantile = quantile;
            return this;
        }

        public final Double getLossValue() {
            return lossValue;
        }

        public final void setLossValue(Double lossValue) {
            this.lossValue = lossValue;
        }

        @Override
        @Transient
        public final Builder lossValue(Double lossValue) {
            this.lossValue = lossValue;
            return this;
        }

        @Override
        public WeightedQuantileLoss build() {
            return new WeightedQuantileLoss(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
