/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.Condition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeSeriesCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeSeriesCondition> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(TimeSeriesCondition.getter(TimeSeriesCondition::attributeName)).setter(TimeSeriesCondition.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeValue").getter(TimeSeriesCondition.getter(TimeSeriesCondition::attributeValue)).setter(TimeSeriesCondition.setter(Builder::attributeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()}).build();
    private static final SdkField<String> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Condition").getter(TimeSeriesCondition.getter(TimeSeriesCondition::conditionAsString)).setter(TimeSeriesCondition.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD, ATTRIBUTE_VALUE_FIELD, CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TimeSeriesCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final String attributeValue;
    private final String condition;

    private TimeSeriesCondition(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
        this.condition = builder.condition;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final String attributeValue() {
        return this.attributeValue;
    }

    public final Condition condition() {
        return Condition.fromValue(this.condition);
    }

    public final String conditionAsString() {
        return this.condition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesCondition)) {
            return false;
        }
        TimeSeriesCondition other = (TimeSeriesCondition)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.attributeValue(), other.attributeValue()) && Objects.equals(this.conditionAsString(), other.conditionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TimeSeriesCondition").add("AttributeName", (Object)this.attributeName()).add("AttributeValue", (Object)this.attributeValue()).add("Condition", (Object)this.conditionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "AttributeValue": {
                return Optional.ofNullable(clazz.cast(this.attributeValue()));
            }
            case "Condition": {
                return Optional.ofNullable(clazz.cast(this.conditionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("AttributeValue", ATTRIBUTE_VALUE_FIELD);
        map.put("Condition", CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesCondition, T> g) {
        return obj -> g.apply((TimeSeriesCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private String attributeValue;
        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesCondition model) {
            this.attributeName(model.attributeName);
            this.attributeValue(model.attributeValue);
            this.condition(model.condition);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getAttributeValue() {
            return this.attributeValue;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final String getCondition() {
            return this.condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(Condition condition) {
            this.condition(condition == null ? null : condition.toString());
            return this;
        }

        public TimeSeriesCondition build() {
            return new TimeSeriesCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeSeriesCondition> {
        public Builder attributeName(String var1);

        public Builder attributeValue(String var1);

        public Builder condition(String var1);

        public Builder condition(Condition var1);
    }
}

