/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.freetier.FreeTierClient;
import software.amazon.awssdk.services.freetier.internal.UserAgentUtils;
import software.amazon.awssdk.services.freetier.model.ActivitySummary;
import software.amazon.awssdk.services.freetier.model.ListAccountActivitiesRequest;
import software.amazon.awssdk.services.freetier.model.ListAccountActivitiesResponse;

public class ListAccountActivitiesIterable
implements SdkIterable<ListAccountActivitiesResponse> {
    private final FreeTierClient client;
    private final ListAccountActivitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountActivitiesIterable(FreeTierClient client, ListAccountActivitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountActivitiesResponseFetcher();
    }

    public Iterator<ListAccountActivitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActivitySummary> activities() {
        Function<ListAccountActivitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.activities() != null) {
                return response.activities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountActivitiesResponseFetcher
    implements SyncPageFetcher<ListAccountActivitiesResponse> {
        private ListAccountActivitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountActivitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccountActivitiesResponse nextPage(ListAccountActivitiesResponse previousPage) {
            if (previousPage == null) {
                return ListAccountActivitiesIterable.this.client.listAccountActivities(ListAccountActivitiesIterable.this.firstRequest);
            }
            return ListAccountActivitiesIterable.this.client.listAccountActivities((ListAccountActivitiesRequest)((Object)ListAccountActivitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

