/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.freetier.model.MonetaryAmount;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivityReward
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActivityReward> {
    private static final SdkField<MonetaryAmount> CREDIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("credit").getter(ActivityReward.getter(ActivityReward::credit)).setter(ActivityReward.setter(Builder::credit)).constructor(MonetaryAmount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActivityReward.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final MonetaryAmount credit;
    private final Type type;

    private ActivityReward(BuilderImpl builder) {
        this.credit = builder.credit;
        this.type = builder.type;
    }

    public final MonetaryAmount credit() {
        return this.credit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.credit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityReward)) {
            return false;
        }
        ActivityReward other = (ActivityReward)obj;
        return Objects.equals(this.credit(), other.credit());
    }

    public final String toString() {
        return ToString.builder((String)"ActivityReward").add("Credit", (Object)this.credit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "credit": {
                return Optional.ofNullable(clazz.cast(this.credit()));
            }
        }
        return Optional.empty();
    }

    public static ActivityReward fromCredit(MonetaryAmount credit) {
        return (ActivityReward)ActivityReward.builder().credit(credit).build();
    }

    public static ActivityReward fromCredit(Consumer<MonetaryAmount.Builder> credit) {
        MonetaryAmount.Builder builder = MonetaryAmount.builder();
        credit.accept(builder);
        return ActivityReward.fromCredit((MonetaryAmount)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<MonetaryAmount>> map = new HashMap<String, SdkField<MonetaryAmount>>();
        map.put("credit", CREDIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActivityReward, T> g) {
        return obj -> g.apply((ActivityReward)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CREDIT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private MonetaryAmount credit;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityReward model) {
            this.credit(model.credit);
        }

        public final MonetaryAmount.Builder getCredit() {
            return this.credit != null ? this.credit.toBuilder() : null;
        }

        public final void setCredit(MonetaryAmount.BuilderImpl credit) {
            MonetaryAmount oldValue = this.credit;
            this.credit = credit != null ? credit.build() : null;
            this.handleUnionValueChange(Type.CREDIT, oldValue, this.credit);
        }

        @Override
        public final Builder credit(MonetaryAmount credit) {
            MonetaryAmount oldValue = this.credit;
            this.credit = credit;
            this.handleUnionValueChange(Type.CREDIT, oldValue, this.credit);
            return this;
        }

        public ActivityReward build() {
            return new ActivityReward(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActivityReward> {
        public Builder credit(MonetaryAmount var1);

        default public Builder credit(Consumer<MonetaryAmount.Builder> credit) {
            return this.credit((MonetaryAmount)((MonetaryAmount.Builder)MonetaryAmount.builder().applyMutation(credit)).build());
        }
    }
}

