/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.freetier.model.ActivityReward;
import software.amazon.awssdk.services.freetier.model.ActivityStatus;
import software.amazon.awssdk.services.freetier.model.FreeTierResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountActivityResponse
extends FreeTierResponse
implements ToCopyableBuilder<Builder, GetAccountActivityResponse> {
    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activityId").getter(GetAccountActivityResponse.getter(GetAccountActivityResponse::activityId)).setter(GetAccountActivityResponse.setter(Builder::activityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(GetAccountActivityResponse.getter(GetAccountActivityResponse::title)).setter(GetAccountActivityResponse.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetAccountActivityResponse.getter(GetAccountActivityResponse::description)).setter(GetAccountActivityResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetAccountActivityResponse.getter(GetAccountActivityResponse::statusAsString)).setter(GetAccountActivityResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> INSTRUCTIONS_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instructionsUrl").getter(GetAccountActivityResponse.getter(GetAccountActivityResponse::instructionsUrl)).setter(GetAccountActivityResponse.setter(Builder::instructionsUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructionsUrl").build()}).build();
    private static final SdkField<ActivityReward> REWARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reward").getter(GetAccountActivityResponse.getter(GetAccountActivityResponse::reward)).setter(GetAccountActivityResponse.setter(Builder::reward)).constructor(ActivityReward::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reward").build()}).build();
    private static final SdkField<Integer> ESTIMATED_TIME_TO_COMPLETE_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("estimatedTimeToCompleteInMinutes").getter(GetAccountActivityResponse.getter(GetAccountActivityResponse::estimatedTimeToCompleteInMinutes)).setter(GetAccountActivityResponse.setter(Builder::estimatedTimeToCompleteInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedTimeToCompleteInMinutes").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresAt").getter(GetAccountActivityResponse.getter(GetAccountActivityResponse::expiresAt)).setter(GetAccountActivityResponse.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(GetAccountActivityResponse.getter(GetAccountActivityResponse::startedAt)).setter(GetAccountActivityResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedAt").getter(GetAccountActivityResponse.getter(GetAccountActivityResponse::completedAt)).setter(GetAccountActivityResponse.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, INSTRUCTIONS_URL_FIELD, REWARD_FIELD, ESTIMATED_TIME_TO_COMPLETE_IN_MINUTES_FIELD, EXPIRES_AT_FIELD, STARTED_AT_FIELD, COMPLETED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAccountActivityResponse.memberNameToFieldInitializer();
    private final String activityId;
    private final String title;
    private final String description;
    private final String status;
    private final String instructionsUrl;
    private final ActivityReward reward;
    private final Integer estimatedTimeToCompleteInMinutes;
    private final Instant expiresAt;
    private final Instant startedAt;
    private final Instant completedAt;

    private GetAccountActivityResponse(BuilderImpl builder) {
        super(builder);
        this.activityId = builder.activityId;
        this.title = builder.title;
        this.description = builder.description;
        this.status = builder.status;
        this.instructionsUrl = builder.instructionsUrl;
        this.reward = builder.reward;
        this.estimatedTimeToCompleteInMinutes = builder.estimatedTimeToCompleteInMinutes;
        this.expiresAt = builder.expiresAt;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
    }

    public final String activityId() {
        return this.activityId;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final ActivityStatus status() {
        return ActivityStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String instructionsUrl() {
        return this.instructionsUrl;
    }

    public final ActivityReward reward() {
        return this.reward;
    }

    public final Integer estimatedTimeToCompleteInMinutes() {
        return this.estimatedTimeToCompleteInMinutes;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.activityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instructionsUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.reward());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeToCompleteInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountActivityResponse)) {
            return false;
        }
        GetAccountActivityResponse other = (GetAccountActivityResponse)((Object)obj);
        return Objects.equals(this.activityId(), other.activityId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.instructionsUrl(), other.instructionsUrl()) && Objects.equals(this.reward(), other.reward()) && Objects.equals(this.estimatedTimeToCompleteInMinutes(), other.estimatedTimeToCompleteInMinutes()) && Objects.equals(this.expiresAt(), other.expiresAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.completedAt(), other.completedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccountActivityResponse").add("ActivityId", (Object)this.activityId()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("InstructionsUrl", (Object)this.instructionsUrl()).add("Reward", (Object)this.reward()).add("EstimatedTimeToCompleteInMinutes", (Object)this.estimatedTimeToCompleteInMinutes()).add("ExpiresAt", (Object)this.expiresAt()).add("StartedAt", (Object)this.startedAt()).add("CompletedAt", (Object)this.completedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activityId": {
                return Optional.ofNullable(clazz.cast(this.activityId()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "instructionsUrl": {
                return Optional.ofNullable(clazz.cast(this.instructionsUrl()));
            }
            case "reward": {
                return Optional.ofNullable(clazz.cast(this.reward()));
            }
            case "estimatedTimeToCompleteInMinutes": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeToCompleteInMinutes()));
            }
            case "expiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "completedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("activityId", ACTIVITY_ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("instructionsUrl", INSTRUCTIONS_URL_FIELD);
        map.put("reward", REWARD_FIELD);
        map.put("estimatedTimeToCompleteInMinutes", ESTIMATED_TIME_TO_COMPLETE_IN_MINUTES_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("completedAt", COMPLETED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountActivityResponse, T> g) {
        return obj -> g.apply((GetAccountActivityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FreeTierResponse.BuilderImpl
    implements Builder {
        private String activityId;
        private String title;
        private String description;
        private String status;
        private String instructionsUrl;
        private ActivityReward reward;
        private Integer estimatedTimeToCompleteInMinutes;
        private Instant expiresAt;
        private Instant startedAt;
        private Instant completedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountActivityResponse model) {
            super(model);
            this.activityId(model.activityId);
            this.title(model.title);
            this.description(model.description);
            this.status(model.status);
            this.instructionsUrl(model.instructionsUrl);
            this.reward(model.reward);
            this.estimatedTimeToCompleteInMinutes(model.estimatedTimeToCompleteInMinutes);
            this.expiresAt(model.expiresAt);
            this.startedAt(model.startedAt);
            this.completedAt(model.completedAt);
        }

        public final String getActivityId() {
            return this.activityId;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActivityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getInstructionsUrl() {
            return this.instructionsUrl;
        }

        public final void setInstructionsUrl(String instructionsUrl) {
            this.instructionsUrl = instructionsUrl;
        }

        @Override
        public final Builder instructionsUrl(String instructionsUrl) {
            this.instructionsUrl = instructionsUrl;
            return this;
        }

        public final ActivityReward.Builder getReward() {
            return this.reward != null ? this.reward.toBuilder() : null;
        }

        public final void setReward(ActivityReward.BuilderImpl reward) {
            this.reward = reward != null ? reward.build() : null;
        }

        @Override
        public final Builder reward(ActivityReward reward) {
            this.reward = reward;
            return this;
        }

        public final Integer getEstimatedTimeToCompleteInMinutes() {
            return this.estimatedTimeToCompleteInMinutes;
        }

        public final void setEstimatedTimeToCompleteInMinutes(Integer estimatedTimeToCompleteInMinutes) {
            this.estimatedTimeToCompleteInMinutes = estimatedTimeToCompleteInMinutes;
        }

        @Override
        public final Builder estimatedTimeToCompleteInMinutes(Integer estimatedTimeToCompleteInMinutes) {
            this.estimatedTimeToCompleteInMinutes = estimatedTimeToCompleteInMinutes;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        @Override
        public GetAccountActivityResponse build() {
            return new GetAccountActivityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FreeTierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccountActivityResponse> {
        public Builder activityId(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(ActivityStatus var1);

        public Builder instructionsUrl(String var1);

        public Builder reward(ActivityReward var1);

        default public Builder reward(Consumer<ActivityReward.Builder> reward) {
            return this.reward((ActivityReward)((ActivityReward.Builder)ActivityReward.builder().applyMutation(reward)).build());
        }

        public Builder estimatedTimeToCompleteInMinutes(Integer var1);

        public Builder expiresAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder completedAt(Instant var1);
    }
}

