/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDataRepositoryAssociationRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, DeleteDataRepositoryAssociationRequest> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(DeleteDataRepositoryAssociationRequest.getter(DeleteDataRepositoryAssociationRequest::associationId)).setter(DeleteDataRepositoryAssociationRequest.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(DeleteDataRepositoryAssociationRequest.getter(DeleteDataRepositoryAssociationRequest::clientRequestToken)).setter(DeleteDataRepositoryAssociationRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DELETE_DATA_IN_FILE_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteDataInFileSystem").getter(DeleteDataRepositoryAssociationRequest.getter(DeleteDataRepositoryAssociationRequest::deleteDataInFileSystem)).setter(DeleteDataRepositoryAssociationRequest.setter(Builder::deleteDataInFileSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteDataInFileSystem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, DELETE_DATA_IN_FILE_SYSTEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteDataRepositoryAssociationRequest.memberNameToFieldInitializer();
    private final String associationId;
    private final String clientRequestToken;
    private final Boolean deleteDataInFileSystem;

    private DeleteDataRepositoryAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.clientRequestToken = builder.clientRequestToken;
        this.deleteDataInFileSystem = builder.deleteDataInFileSystem;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final Boolean deleteDataInFileSystem() {
        return this.deleteDataInFileSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteDataInFileSystem());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataRepositoryAssociationRequest)) {
            return false;
        }
        DeleteDataRepositoryAssociationRequest other = (DeleteDataRepositoryAssociationRequest)((Object)obj);
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.deleteDataInFileSystem(), other.deleteDataInFileSystem());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDataRepositoryAssociationRequest").add("AssociationId", (Object)this.associationId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("DeleteDataInFileSystem", (Object)this.deleteDataInFileSystem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "DeleteDataInFileSystem": {
                return Optional.ofNullable(clazz.cast(this.deleteDataInFileSystem()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("DeleteDataInFileSystem", DELETE_DATA_IN_FILE_SYSTEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDataRepositoryAssociationRequest, T> g) {
        return obj -> g.apply((DeleteDataRepositoryAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String associationId;
        private String clientRequestToken;
        private Boolean deleteDataInFileSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataRepositoryAssociationRequest model) {
            super(model);
            this.associationId(model.associationId);
            this.clientRequestToken(model.clientRequestToken);
            this.deleteDataInFileSystem(model.deleteDataInFileSystem);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Boolean getDeleteDataInFileSystem() {
            return this.deleteDataInFileSystem;
        }

        public final void setDeleteDataInFileSystem(Boolean deleteDataInFileSystem) {
            this.deleteDataInFileSystem = deleteDataInFileSystem;
        }

        @Override
        public final Builder deleteDataInFileSystem(Boolean deleteDataInFileSystem) {
            this.deleteDataInFileSystem = deleteDataInFileSystem;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDataRepositoryAssociationRequest build() {
            return new DeleteDataRepositoryAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDataRepositoryAssociationRequest> {
        public Builder associationId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder deleteDataInFileSystem(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

