/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.CreateAndAttachS3AccessPointOpenZFSConfiguration;
import software.amazon.awssdk.services.fsx.model.CreateAndAttachS3AccessPointS3Configuration;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.S3AccessPointAttachmentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAndAttachS3AccessPointRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, CreateAndAttachS3AccessPointRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateAndAttachS3AccessPointRequest.getter(CreateAndAttachS3AccessPointRequest::clientRequestToken)).setter(CreateAndAttachS3AccessPointRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateAndAttachS3AccessPointRequest.getter(CreateAndAttachS3AccessPointRequest::name)).setter(CreateAndAttachS3AccessPointRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateAndAttachS3AccessPointRequest.getter(CreateAndAttachS3AccessPointRequest::typeAsString)).setter(CreateAndAttachS3AccessPointRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<CreateAndAttachS3AccessPointOpenZFSConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenZFSConfiguration").getter(CreateAndAttachS3AccessPointRequest.getter(CreateAndAttachS3AccessPointRequest::openZFSConfiguration)).setter(CreateAndAttachS3AccessPointRequest.setter(Builder::openZFSConfiguration)).constructor(CreateAndAttachS3AccessPointOpenZFSConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build()}).build();
    private static final SdkField<CreateAndAttachS3AccessPointS3Configuration> S3_ACCESS_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3AccessPoint").getter(CreateAndAttachS3AccessPointRequest.getter(CreateAndAttachS3AccessPointRequest::s3AccessPoint)).setter(CreateAndAttachS3AccessPointRequest.setter(Builder::s3AccessPoint)).constructor(CreateAndAttachS3AccessPointS3Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3AccessPoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, NAME_FIELD, TYPE_FIELD, OPEN_ZFS_CONFIGURATION_FIELD, S3_ACCESS_POINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAndAttachS3AccessPointRequest.memberNameToFieldInitializer();
    private final String clientRequestToken;
    private final String name;
    private final String type;
    private final CreateAndAttachS3AccessPointOpenZFSConfiguration openZFSConfiguration;
    private final CreateAndAttachS3AccessPointS3Configuration s3AccessPoint;

    private CreateAndAttachS3AccessPointRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.name = builder.name;
        this.type = builder.type;
        this.openZFSConfiguration = builder.openZFSConfiguration;
        this.s3AccessPoint = builder.s3AccessPoint;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String name() {
        return this.name;
    }

    public final S3AccessPointAttachmentType type() {
        return S3AccessPointAttachmentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final CreateAndAttachS3AccessPointOpenZFSConfiguration openZFSConfiguration() {
        return this.openZFSConfiguration;
    }

    public final CreateAndAttachS3AccessPointS3Configuration s3AccessPoint() {
        return this.s3AccessPoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.openZFSConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AccessPoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAndAttachS3AccessPointRequest)) {
            return false;
        }
        CreateAndAttachS3AccessPointRequest other = (CreateAndAttachS3AccessPointRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.openZFSConfiguration(), other.openZFSConfiguration()) && Objects.equals(this.s3AccessPoint(), other.s3AccessPoint());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAndAttachS3AccessPointRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("OpenZFSConfiguration", (Object)this.openZFSConfiguration()).add("S3AccessPoint", (Object)this.s3AccessPoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "OpenZFSConfiguration": {
                return Optional.ofNullable(clazz.cast(this.openZFSConfiguration()));
            }
            case "S3AccessPoint": {
                return Optional.ofNullable(clazz.cast(this.s3AccessPoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("OpenZFSConfiguration", OPEN_ZFS_CONFIGURATION_FIELD);
        map.put("S3AccessPoint", S3_ACCESS_POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAndAttachS3AccessPointRequest, T> g) {
        return obj -> g.apply((CreateAndAttachS3AccessPointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String name;
        private String type;
        private CreateAndAttachS3AccessPointOpenZFSConfiguration openZFSConfiguration;
        private CreateAndAttachS3AccessPointS3Configuration s3AccessPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAndAttachS3AccessPointRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.name(model.name);
            this.type(model.type);
            this.openZFSConfiguration(model.openZFSConfiguration);
            this.s3AccessPoint(model.s3AccessPoint);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(S3AccessPointAttachmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CreateAndAttachS3AccessPointOpenZFSConfiguration.Builder getOpenZFSConfiguration() {
            return this.openZFSConfiguration != null ? this.openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(CreateAndAttachS3AccessPointOpenZFSConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        public final Builder openZFSConfiguration(CreateAndAttachS3AccessPointOpenZFSConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        public final CreateAndAttachS3AccessPointS3Configuration.Builder getS3AccessPoint() {
            return this.s3AccessPoint != null ? this.s3AccessPoint.toBuilder() : null;
        }

        public final void setS3AccessPoint(CreateAndAttachS3AccessPointS3Configuration.BuilderImpl s3AccessPoint) {
            this.s3AccessPoint = s3AccessPoint != null ? s3AccessPoint.build() : null;
        }

        @Override
        public final Builder s3AccessPoint(CreateAndAttachS3AccessPointS3Configuration s3AccessPoint) {
            this.s3AccessPoint = s3AccessPoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAndAttachS3AccessPointRequest build() {
            return new CreateAndAttachS3AccessPointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAndAttachS3AccessPointRequest> {
        public Builder clientRequestToken(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(S3AccessPointAttachmentType var1);

        public Builder openZFSConfiguration(CreateAndAttachS3AccessPointOpenZFSConfiguration var1);

        default public Builder openZFSConfiguration(Consumer<CreateAndAttachS3AccessPointOpenZFSConfiguration.Builder> openZFSConfiguration) {
            return this.openZFSConfiguration((CreateAndAttachS3AccessPointOpenZFSConfiguration)((CreateAndAttachS3AccessPointOpenZFSConfiguration.Builder)CreateAndAttachS3AccessPointOpenZFSConfiguration.builder().applyMutation(openZFSConfiguration)).build());
        }

        public Builder s3AccessPoint(CreateAndAttachS3AccessPointS3Configuration var1);

        default public Builder s3AccessPoint(Consumer<CreateAndAttachS3AccessPointS3Configuration.Builder> s3AccessPoint) {
            return this.s3AccessPoint((CreateAndAttachS3AccessPointS3Configuration)((CreateAndAttachS3AccessPointS3Configuration.Builder)CreateAndAttachS3AccessPointS3Configuration.builder().applyMutation(s3AccessPoint)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

