/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeS3AccessPointAttachmentsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeS3AccessPointAttachmentsResponse;
import software.amazon.awssdk.services.fsx.model.S3AccessPointAttachment;

public class DescribeS3AccessPointAttachmentsIterable
implements SdkIterable<DescribeS3AccessPointAttachmentsResponse> {
    private final FSxClient client;
    private final DescribeS3AccessPointAttachmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeS3AccessPointAttachmentsIterable(FSxClient client, DescribeS3AccessPointAttachmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeS3AccessPointAttachmentsResponseFetcher();
    }

    public Iterator<DescribeS3AccessPointAttachmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<S3AccessPointAttachment> s3AccessPointAttachments() {
        Function<DescribeS3AccessPointAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.s3AccessPointAttachments() != null) {
                return response.s3AccessPointAttachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeS3AccessPointAttachmentsResponseFetcher
    implements SyncPageFetcher<DescribeS3AccessPointAttachmentsResponse> {
        private DescribeS3AccessPointAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeS3AccessPointAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeS3AccessPointAttachmentsResponse nextPage(DescribeS3AccessPointAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeS3AccessPointAttachmentsIterable.this.client.describeS3AccessPointAttachments(DescribeS3AccessPointAttachmentsIterable.this.firstRequest);
            }
            return DescribeS3AccessPointAttachmentsIterable.this.client.describeS3AccessPointAttachments((DescribeS3AccessPointAttachmentsRequest)((Object)DescribeS3AccessPointAttachmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

