/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.services.fsx.model.FileCache;
import software.amazon.awssdk.services.fsx.model.FileCachesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFileCachesResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, DescribeFileCachesResponse> {
    private static final SdkField<List<FileCache>> FILE_CACHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileCaches").getter(DescribeFileCachesResponse.getter(DescribeFileCachesResponse::fileCaches)).setter(DescribeFileCachesResponse.setter(Builder::fileCaches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCaches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileCache::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFileCachesResponse.getter(DescribeFileCachesResponse::nextToken)).setter(DescribeFileCachesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_CACHES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFileCachesResponse.memberNameToFieldInitializer();
    private final List<FileCache> fileCaches;
    private final String nextToken;

    private DescribeFileCachesResponse(BuilderImpl builder) {
        super(builder);
        this.fileCaches = builder.fileCaches;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFileCaches() {
        return this.fileCaches != null && !(this.fileCaches instanceof SdkAutoConstructList);
    }

    public final List<FileCache> fileCaches() {
        return this.fileCaches;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileCaches() ? this.fileCaches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileCachesResponse)) {
            return false;
        }
        DescribeFileCachesResponse other = (DescribeFileCachesResponse)((Object)obj);
        return this.hasFileCaches() == other.hasFileCaches() && Objects.equals(this.fileCaches(), other.fileCaches()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFileCachesResponse").add("FileCaches", this.hasFileCaches() ? this.fileCaches() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileCaches": {
                return Optional.ofNullable(clazz.cast(this.fileCaches()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FileCaches", FILE_CACHES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFileCachesResponse, T> g) {
        return obj -> g.apply((DescribeFileCachesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private List<FileCache> fileCaches = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileCachesResponse model) {
            super(model);
            this.fileCaches(model.fileCaches);
            this.nextToken(model.nextToken);
        }

        public final List<FileCache.Builder> getFileCaches() {
            List<FileCache.Builder> result = FileCachesCopier.copyToBuilder(this.fileCaches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileCaches(Collection<FileCache.BuilderImpl> fileCaches) {
            this.fileCaches = FileCachesCopier.copyFromBuilder(fileCaches);
        }

        @Override
        public final Builder fileCaches(Collection<FileCache> fileCaches) {
            this.fileCaches = FileCachesCopier.copy(fileCaches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileCaches(FileCache ... fileCaches) {
            this.fileCaches(Arrays.asList(fileCaches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileCaches(Consumer<FileCache.Builder> ... fileCaches) {
            this.fileCaches(Stream.of(fileCaches).map(c -> (FileCache)((FileCache.Builder)FileCache.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFileCachesResponse build() {
            return new DescribeFileCachesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFileCachesResponse> {
        public Builder fileCaches(Collection<FileCache> var1);

        public Builder fileCaches(FileCache ... var1);

        public Builder fileCaches(Consumer<FileCache.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

