/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxAsyncClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeS3AccessPointAttachmentsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeS3AccessPointAttachmentsResponse;
import software.amazon.awssdk.services.fsx.model.S3AccessPointAttachment;

public class DescribeS3AccessPointAttachmentsPublisher
implements SdkPublisher<DescribeS3AccessPointAttachmentsResponse> {
    private final FSxAsyncClient client;
    private final DescribeS3AccessPointAttachmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeS3AccessPointAttachmentsPublisher(FSxAsyncClient client, DescribeS3AccessPointAttachmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeS3AccessPointAttachmentsPublisher(FSxAsyncClient client, DescribeS3AccessPointAttachmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeS3AccessPointAttachmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeS3AccessPointAttachmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<S3AccessPointAttachment> s3AccessPointAttachments() {
        Function<DescribeS3AccessPointAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.s3AccessPointAttachments() != null) {
                return response.s3AccessPointAttachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeS3AccessPointAttachmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeS3AccessPointAttachmentsResponseFetcher
    implements AsyncPageFetcher<DescribeS3AccessPointAttachmentsResponse> {
        private DescribeS3AccessPointAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeS3AccessPointAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeS3AccessPointAttachmentsResponse> nextPage(DescribeS3AccessPointAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeS3AccessPointAttachmentsPublisher.this.client.describeS3AccessPointAttachments(DescribeS3AccessPointAttachmentsPublisher.this.firstRequest);
            }
            return DescribeS3AccessPointAttachmentsPublisher.this.client.describeS3AccessPointAttachments((DescribeS3AccessPointAttachmentsRequest)((Object)DescribeS3AccessPointAttachmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

