/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.AdministrativeAction;
import software.amazon.awssdk.services.fsx.model.AdministrativeActionsCopier;
import software.amazon.awssdk.services.fsx.model.LifecycleTransitionReason;
import software.amazon.awssdk.services.fsx.model.OntapVolumeConfiguration;
import software.amazon.awssdk.services.fsx.model.OpenZFSVolumeConfiguration;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.services.fsx.model.VolumeLifecycle;
import software.amazon.awssdk.services.fsx.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Volume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Volume> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Volume.getter(Volume::creationTime)).setter(Volume.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(Volume.getter(Volume::fileSystemId)).setter(Volume.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(Volume.getter(Volume::lifecycleAsString)).setter(Volume.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Volume.getter(Volume::name)).setter(Volume.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<OntapVolumeConfiguration> ONTAP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OntapConfiguration").getter(Volume.getter(Volume::ontapConfiguration)).setter(Volume.setter(Builder::ontapConfiguration)).constructor(OntapVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapConfiguration").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceARN").getter(Volume.getter(Volume::resourceARN)).setter(Volume.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Volume.getter(Volume::tags)).setter(Volume.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(Volume.getter(Volume::volumeId)).setter(Volume.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeType").getter(Volume.getter(Volume::volumeTypeAsString)).setter(Volume.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()}).build();
    private static final SdkField<LifecycleTransitionReason> LIFECYCLE_TRANSITION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LifecycleTransitionReason").getter(Volume.getter(Volume::lifecycleTransitionReason)).setter(Volume.setter(Builder::lifecycleTransitionReason)).constructor(LifecycleTransitionReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleTransitionReason").build()}).build();
    private static final SdkField<List<AdministrativeAction>> ADMINISTRATIVE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdministrativeActions").getter(Volume.getter(Volume::administrativeActions)).setter(Volume.setter(Builder::administrativeActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrativeActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdministrativeAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OpenZFSVolumeConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenZFSConfiguration").getter(Volume.getter(Volume::openZFSConfiguration)).setter(Volume.setter(Builder::openZFSConfiguration)).constructor(OpenZFSVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, FILE_SYSTEM_ID_FIELD, LIFECYCLE_FIELD, NAME_FIELD, ONTAP_CONFIGURATION_FIELD, RESOURCE_ARN_FIELD, TAGS_FIELD, VOLUME_ID_FIELD, VOLUME_TYPE_FIELD, LIFECYCLE_TRANSITION_REASON_FIELD, ADMINISTRATIVE_ACTIONS_FIELD, OPEN_ZFS_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Volume.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String fileSystemId;
    private final String lifecycle;
    private final String name;
    private final OntapVolumeConfiguration ontapConfiguration;
    private final String resourceARN;
    private final List<Tag> tags;
    private final String volumeId;
    private final String volumeType;
    private final LifecycleTransitionReason lifecycleTransitionReason;
    private final List<AdministrativeAction> administrativeActions;
    private final OpenZFSVolumeConfiguration openZFSConfiguration;

    private Volume(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.fileSystemId = builder.fileSystemId;
        this.lifecycle = builder.lifecycle;
        this.name = builder.name;
        this.ontapConfiguration = builder.ontapConfiguration;
        this.resourceARN = builder.resourceARN;
        this.tags = builder.tags;
        this.volumeId = builder.volumeId;
        this.volumeType = builder.volumeType;
        this.lifecycleTransitionReason = builder.lifecycleTransitionReason;
        this.administrativeActions = builder.administrativeActions;
        this.openZFSConfiguration = builder.openZFSConfiguration;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final VolumeLifecycle lifecycle() {
        return VolumeLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final String name() {
        return this.name;
    }

    public final OntapVolumeConfiguration ontapConfiguration() {
        return this.ontapConfiguration;
    }

    public final String resourceARN() {
        return this.resourceARN;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public final String volumeTypeAsString() {
        return this.volumeType;
    }

    public final LifecycleTransitionReason lifecycleTransitionReason() {
        return this.lifecycleTransitionReason;
    }

    public final boolean hasAdministrativeActions() {
        return this.administrativeActions != null && !(this.administrativeActions instanceof SdkAutoConstructList);
    }

    public final List<AdministrativeAction> administrativeActions() {
        return this.administrativeActions;
    }

    public final OpenZFSVolumeConfiguration openZFSConfiguration() {
        return this.openZFSConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ontapConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdministrativeActions() ? this.administrativeActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.openZFSConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ontapConfiguration(), other.ontapConfiguration()) && Objects.equals(this.resourceARN(), other.resourceARN()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString()) && Objects.equals(this.lifecycleTransitionReason(), other.lifecycleTransitionReason()) && this.hasAdministrativeActions() == other.hasAdministrativeActions() && Objects.equals(this.administrativeActions(), other.administrativeActions()) && Objects.equals(this.openZFSConfiguration(), other.openZFSConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Volume").add("CreationTime", (Object)this.creationTime()).add("FileSystemId", (Object)this.fileSystemId()).add("Lifecycle", (Object)this.lifecycleAsString()).add("Name", (Object)this.name()).add("OntapConfiguration", (Object)this.ontapConfiguration()).add("ResourceARN", (Object)this.resourceARN()).add("Tags", this.hasTags() ? this.tags() : null).add("VolumeId", (Object)this.volumeId()).add("VolumeType", (Object)this.volumeTypeAsString()).add("LifecycleTransitionReason", (Object)this.lifecycleTransitionReason()).add("AdministrativeActions", this.hasAdministrativeActions() ? this.administrativeActions() : null).add("OpenZFSConfiguration", (Object)this.openZFSConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OntapConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ontapConfiguration()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
            case "LifecycleTransitionReason": {
                return Optional.ofNullable(clazz.cast(this.lifecycleTransitionReason()));
            }
            case "AdministrativeActions": {
                return Optional.ofNullable(clazz.cast(this.administrativeActions()));
            }
            case "OpenZFSConfiguration": {
                return Optional.ofNullable(clazz.cast(this.openZFSConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("OntapConfiguration", ONTAP_CONFIGURATION_FIELD);
        map.put("ResourceARN", RESOURCE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("LifecycleTransitionReason", LIFECYCLE_TRANSITION_REASON_FIELD);
        map.put("AdministrativeActions", ADMINISTRATIVE_ACTIONS_FIELD);
        map.put("OpenZFSConfiguration", OPEN_ZFS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String fileSystemId;
        private String lifecycle;
        private String name;
        private OntapVolumeConfiguration ontapConfiguration;
        private String resourceARN;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String volumeId;
        private String volumeType;
        private LifecycleTransitionReason lifecycleTransitionReason;
        private List<AdministrativeAction> administrativeActions = DefaultSdkAutoConstructList.getInstance();
        private OpenZFSVolumeConfiguration openZFSConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            this.creationTime(model.creationTime);
            this.fileSystemId(model.fileSystemId);
            this.lifecycle(model.lifecycle);
            this.name(model.name);
            this.ontapConfiguration(model.ontapConfiguration);
            this.resourceARN(model.resourceARN);
            this.tags(model.tags);
            this.volumeId(model.volumeId);
            this.volumeType(model.volumeType);
            this.lifecycleTransitionReason(model.lifecycleTransitionReason);
            this.administrativeActions(model.administrativeActions);
            this.openZFSConfiguration(model.openZFSConfiguration);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(VolumeLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final OntapVolumeConfiguration.Builder getOntapConfiguration() {
            return this.ontapConfiguration != null ? this.ontapConfiguration.toBuilder() : null;
        }

        public final void setOntapConfiguration(OntapVolumeConfiguration.BuilderImpl ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration != null ? ontapConfiguration.build() : null;
        }

        @Override
        public final Builder ontapConfiguration(OntapVolumeConfiguration ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final LifecycleTransitionReason.Builder getLifecycleTransitionReason() {
            return this.lifecycleTransitionReason != null ? this.lifecycleTransitionReason.toBuilder() : null;
        }

        public final void setLifecycleTransitionReason(LifecycleTransitionReason.BuilderImpl lifecycleTransitionReason) {
            this.lifecycleTransitionReason = lifecycleTransitionReason != null ? lifecycleTransitionReason.build() : null;
        }

        @Override
        public final Builder lifecycleTransitionReason(LifecycleTransitionReason lifecycleTransitionReason) {
            this.lifecycleTransitionReason = lifecycleTransitionReason;
            return this;
        }

        public final List<AdministrativeAction.Builder> getAdministrativeActions() {
            List<AdministrativeAction.Builder> result = AdministrativeActionsCopier.copyToBuilder(this.administrativeActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdministrativeActions(Collection<AdministrativeAction.BuilderImpl> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copyFromBuilder(administrativeActions);
        }

        @Override
        public final Builder administrativeActions(Collection<AdministrativeAction> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copy(administrativeActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrativeActions(AdministrativeAction ... administrativeActions) {
            this.administrativeActions(Arrays.asList(administrativeActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrativeActions(Consumer<AdministrativeAction.Builder> ... administrativeActions) {
            this.administrativeActions(Stream.of(administrativeActions).map(c -> (AdministrativeAction)((AdministrativeAction.Builder)AdministrativeAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OpenZFSVolumeConfiguration.Builder getOpenZFSConfiguration() {
            return this.openZFSConfiguration != null ? this.openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(OpenZFSVolumeConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        public final Builder openZFSConfiguration(OpenZFSVolumeConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        public Volume build() {
            return new Volume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Volume> {
        public Builder creationTime(Instant var1);

        public Builder fileSystemId(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(VolumeLifecycle var1);

        public Builder name(String var1);

        public Builder ontapConfiguration(OntapVolumeConfiguration var1);

        default public Builder ontapConfiguration(Consumer<OntapVolumeConfiguration.Builder> ontapConfiguration) {
            return this.ontapConfiguration((OntapVolumeConfiguration)((OntapVolumeConfiguration.Builder)OntapVolumeConfiguration.builder().applyMutation(ontapConfiguration)).build());
        }

        public Builder resourceARN(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder volumeId(String var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);

        public Builder lifecycleTransitionReason(LifecycleTransitionReason var1);

        default public Builder lifecycleTransitionReason(Consumer<LifecycleTransitionReason.Builder> lifecycleTransitionReason) {
            return this.lifecycleTransitionReason((LifecycleTransitionReason)((LifecycleTransitionReason.Builder)LifecycleTransitionReason.builder().applyMutation(lifecycleTransitionReason)).build());
        }

        public Builder administrativeActions(Collection<AdministrativeAction> var1);

        public Builder administrativeActions(AdministrativeAction ... var1);

        public Builder administrativeActions(Consumer<AdministrativeAction.Builder> ... var1);

        public Builder openZFSConfiguration(OpenZFSVolumeConfiguration var1);

        default public Builder openZFSConfiguration(Consumer<OpenZFSVolumeConfiguration.Builder> openZFSConfiguration) {
            return this.openZFSConfiguration((OpenZFSVolumeConfiguration)((OpenZFSVolumeConfiguration.Builder)OpenZFSVolumeConfiguration.builder().applyMutation(openZFSConfiguration)).build());
        }
    }
}

