/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePlayerSessionsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, DescribePlayerSessionsRequest> {
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionId").getter(DescribePlayerSessionsRequest.getter(DescribePlayerSessionsRequest::gameSessionId)).setter(DescribePlayerSessionsRequest.setter(Builder::gameSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()}).build();
    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerId").getter(DescribePlayerSessionsRequest.getter(DescribePlayerSessionsRequest::playerId)).setter(DescribePlayerSessionsRequest.setter(Builder::playerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerId").build()}).build();
    private static final SdkField<String> PLAYER_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerSessionId").getter(DescribePlayerSessionsRequest.getter(DescribePlayerSessionsRequest::playerSessionId)).setter(DescribePlayerSessionsRequest.setter(Builder::playerSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerSessionId").build()}).build();
    private static final SdkField<String> PLAYER_SESSION_STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerSessionStatusFilter").getter(DescribePlayerSessionsRequest.getter(DescribePlayerSessionsRequest::playerSessionStatusFilter)).setter(DescribePlayerSessionsRequest.setter(Builder::playerSessionStatusFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerSessionStatusFilter").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribePlayerSessionsRequest.getter(DescribePlayerSessionsRequest::limit)).setter(DescribePlayerSessionsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribePlayerSessionsRequest.getter(DescribePlayerSessionsRequest::nextToken)).setter(DescribePlayerSessionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_ID_FIELD, PLAYER_ID_FIELD, PLAYER_SESSION_ID_FIELD, PLAYER_SESSION_STATUS_FILTER_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePlayerSessionsRequest.memberNameToFieldInitializer();
    private final String gameSessionId;
    private final String playerId;
    private final String playerSessionId;
    private final String playerSessionStatusFilter;
    private final Integer limit;
    private final String nextToken;

    private DescribePlayerSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.playerId = builder.playerId;
        this.playerSessionId = builder.playerSessionId;
        this.playerSessionStatusFilter = builder.playerSessionStatusFilter;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final String gameSessionId() {
        return this.gameSessionId;
    }

    public final String playerId() {
        return this.playerId;
    }

    public final String playerSessionId() {
        return this.playerSessionId;
    }

    public final String playerSessionStatusFilter() {
        return this.playerSessionStatusFilter;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionStatusFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlayerSessionsRequest)) {
            return false;
        }
        DescribePlayerSessionsRequest other = (DescribePlayerSessionsRequest)((Object)obj);
        return Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.playerSessionId(), other.playerSessionId()) && Objects.equals(this.playerSessionStatusFilter(), other.playerSessionStatusFilter()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePlayerSessionsRequest").add("GameSessionId", (Object)this.gameSessionId()).add("PlayerId", (Object)(this.playerId() == null ? null : "*** Sensitive Data Redacted ***")).add("PlayerSessionId", (Object)this.playerSessionId()).add("PlayerSessionStatusFilter", (Object)this.playerSessionStatusFilter()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.ofNullable(clazz.cast(this.gameSessionId()));
            }
            case "PlayerId": {
                return Optional.ofNullable(clazz.cast(this.playerId()));
            }
            case "PlayerSessionId": {
                return Optional.ofNullable(clazz.cast(this.playerSessionId()));
            }
            case "PlayerSessionStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.playerSessionStatusFilter()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GameSessionId", GAME_SESSION_ID_FIELD);
        map.put("PlayerId", PLAYER_ID_FIELD);
        map.put("PlayerSessionId", PLAYER_SESSION_ID_FIELD);
        map.put("PlayerSessionStatusFilter", PLAYER_SESSION_STATUS_FILTER_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePlayerSessionsRequest, T> g) {
        return obj -> g.apply((DescribePlayerSessionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameSessionId;
        private String playerId;
        private String playerSessionId;
        private String playerSessionStatusFilter;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlayerSessionsRequest model) {
            super(model);
            this.gameSessionId(model.gameSessionId);
            this.playerId(model.playerId);
            this.playerSessionId(model.playerSessionId);
            this.playerSessionStatusFilter(model.playerSessionStatusFilter);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final String getPlayerSessionId() {
            return this.playerSessionId;
        }

        public final void setPlayerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
        }

        @Override
        public final Builder playerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
            return this;
        }

        public final String getPlayerSessionStatusFilter() {
            return this.playerSessionStatusFilter;
        }

        public final void setPlayerSessionStatusFilter(String playerSessionStatusFilter) {
            this.playerSessionStatusFilter = playerSessionStatusFilter;
        }

        @Override
        public final Builder playerSessionStatusFilter(String playerSessionStatusFilter) {
            this.playerSessionStatusFilter = playerSessionStatusFilter;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePlayerSessionsRequest build() {
            return new DescribePlayerSessionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePlayerSessionsRequest> {
        public Builder gameSessionId(String var1);

        public Builder playerId(String var1);

        public Builder playerSessionId(String var1);

        public Builder playerSessionStatusFilter(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

