/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinition;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinitionListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContainerGroupDefinitionsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, ListContainerGroupDefinitionsResponse> {
    private static final SdkField<List<ContainerGroupDefinition>> CONTAINER_GROUP_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerGroupDefinitions").getter(ListContainerGroupDefinitionsResponse.getter(ListContainerGroupDefinitionsResponse::containerGroupDefinitions)).setter(ListContainerGroupDefinitionsResponse.setter(Builder::containerGroupDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerGroupDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListContainerGroupDefinitionsResponse.getter(ListContainerGroupDefinitionsResponse::nextToken)).setter(ListContainerGroupDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_GROUP_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListContainerGroupDefinitionsResponse.memberNameToFieldInitializer();
    private final List<ContainerGroupDefinition> containerGroupDefinitions;
    private final String nextToken;

    private ListContainerGroupDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.containerGroupDefinitions = builder.containerGroupDefinitions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasContainerGroupDefinitions() {
        return this.containerGroupDefinitions != null && !(this.containerGroupDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ContainerGroupDefinition> containerGroupDefinitions() {
        return this.containerGroupDefinitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerGroupDefinitions() ? this.containerGroupDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContainerGroupDefinitionsResponse)) {
            return false;
        }
        ListContainerGroupDefinitionsResponse other = (ListContainerGroupDefinitionsResponse)((Object)obj);
        return this.hasContainerGroupDefinitions() == other.hasContainerGroupDefinitions() && Objects.equals(this.containerGroupDefinitions(), other.containerGroupDefinitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListContainerGroupDefinitionsResponse").add("ContainerGroupDefinitions", this.hasContainerGroupDefinitions() ? this.containerGroupDefinitions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerGroupDefinitions": {
                return Optional.ofNullable(clazz.cast(this.containerGroupDefinitions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContainerGroupDefinitions", CONTAINER_GROUP_DEFINITIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListContainerGroupDefinitionsResponse, T> g) {
        return obj -> g.apply((ListContainerGroupDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<ContainerGroupDefinition> containerGroupDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContainerGroupDefinitionsResponse model) {
            super(model);
            this.containerGroupDefinitions(model.containerGroupDefinitions);
            this.nextToken(model.nextToken);
        }

        public final List<ContainerGroupDefinition.Builder> getContainerGroupDefinitions() {
            List<ContainerGroupDefinition.Builder> result = ContainerGroupDefinitionListCopier.copyToBuilder(this.containerGroupDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerGroupDefinitions(Collection<ContainerGroupDefinition.BuilderImpl> containerGroupDefinitions) {
            this.containerGroupDefinitions = ContainerGroupDefinitionListCopier.copyFromBuilder(containerGroupDefinitions);
        }

        @Override
        public final Builder containerGroupDefinitions(Collection<ContainerGroupDefinition> containerGroupDefinitions) {
            this.containerGroupDefinitions = ContainerGroupDefinitionListCopier.copy(containerGroupDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerGroupDefinitions(ContainerGroupDefinition ... containerGroupDefinitions) {
            this.containerGroupDefinitions(Arrays.asList(containerGroupDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerGroupDefinitions(Consumer<ContainerGroupDefinition.Builder> ... containerGroupDefinitions) {
            this.containerGroupDefinitions(Stream.of(containerGroupDefinitions).map(c -> (ContainerGroupDefinition)((ContainerGroupDefinition.Builder)ContainerGroupDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContainerGroupDefinitionsResponse build() {
            return new ListContainerGroupDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContainerGroupDefinitionsResponse> {
        public Builder containerGroupDefinitions(Collection<ContainerGroupDefinition> var1);

        public Builder containerGroupDefinitions(ContainerGroupDefinition ... var1);

        public Builder containerGroupDefinitions(Consumer<ContainerGroupDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

