/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.FleetDeployment;
import software.amazon.awssdk.services.gamelift.model.ListFleetDeploymentsRequest;
import software.amazon.awssdk.services.gamelift.model.ListFleetDeploymentsResponse;

public class ListFleetDeploymentsPublisher
implements SdkPublisher<ListFleetDeploymentsResponse> {
    private final GameLiftAsyncClient client;
    private final ListFleetDeploymentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFleetDeploymentsPublisher(GameLiftAsyncClient client, ListFleetDeploymentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFleetDeploymentsPublisher(GameLiftAsyncClient client, ListFleetDeploymentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFleetDeploymentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFleetDeploymentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FleetDeployment> fleetDeployments() {
        Function<ListFleetDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleetDeployments() != null) {
                return response.fleetDeployments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFleetDeploymentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFleetDeploymentsResponseFetcher
    implements AsyncPageFetcher<ListFleetDeploymentsResponse> {
        private ListFleetDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFleetDeploymentsResponse> nextPage(ListFleetDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListFleetDeploymentsPublisher.this.client.listFleetDeployments(ListFleetDeploymentsPublisher.this.firstRequest);
            }
            return ListFleetDeploymentsPublisher.this.client.listFleetDeployments((ListFleetDeploymentsRequest)((Object)ListFleetDeploymentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

