/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.FleetDeployment;
import software.amazon.awssdk.services.gamelift.model.ListFleetDeploymentsRequest;
import software.amazon.awssdk.services.gamelift.model.ListFleetDeploymentsResponse;

public class ListFleetDeploymentsIterable
implements SdkIterable<ListFleetDeploymentsResponse> {
    private final GameLiftClient client;
    private final ListFleetDeploymentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFleetDeploymentsIterable(GameLiftClient client, ListFleetDeploymentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFleetDeploymentsResponseFetcher();
    }

    public Iterator<ListFleetDeploymentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FleetDeployment> fleetDeployments() {
        Function<ListFleetDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleetDeployments() != null) {
                return response.fleetDeployments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFleetDeploymentsResponseFetcher
    implements SyncPageFetcher<ListFleetDeploymentsResponse> {
        private ListFleetDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFleetDeploymentsResponse nextPage(ListFleetDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListFleetDeploymentsIterable.this.client.listFleetDeployments(ListFleetDeploymentsIterable.this.firstRequest);
            }
            return ListFleetDeploymentsIterable.this.client.listFleetDeployments((ListFleetDeploymentsRequest)((Object)ListFleetDeploymentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

