/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StreamSessionStatusReason {
    INTERNAL_ERROR("internalError"),
    INVALID_SIGNAL_REQUEST("invalidSignalRequest"),
    PLACEMENT_TIMEOUT("placementTimeout"),
    APPLICATION_LOG_S3_DESTINATION_ERROR("applicationLogS3DestinationError"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamSessionStatusReason> VALUE_MAP;
    private final String value;

    private StreamSessionStatusReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamSessionStatusReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamSessionStatusReason> knownValues() {
        EnumSet<StreamSessionStatusReason> knownValues = EnumSet.allOf(StreamSessionStatusReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StreamSessionStatusReason.class, StreamSessionStatusReason::toString);
    }
}

