/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StreamSessionStatus {
    ACTIVATING("ACTIVATING"),
    ACTIVE("ACTIVE"),
    CONNECTED("CONNECTED"),
    PENDING_CLIENT_RECONNECTION("PENDING_CLIENT_RECONNECTION"),
    RECONNECTING("RECONNECTING"),
    TERMINATING("TERMINATING"),
    TERMINATED("TERMINATED"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamSessionStatus> VALUE_MAP;
    private final String value;

    private StreamSessionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamSessionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamSessionStatus> knownValues() {
        EnumSet<StreamSessionStatus> knownValues = EnumSet.allOf(StreamSessionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StreamSessionStatus.class, StreamSessionStatus::toString);
    }
}

