/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LabelSize {
    SMALL("Small"),
    LARGE("Large"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LabelSize> VALUE_MAP;
    private final String value;

    private LabelSize(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LabelSize fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LabelSize> knownValues() {
        EnumSet<LabelSize> knownValues = EnumSet.allOf(LabelSize.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LabelSize.class, LabelSize::toString);
    }
}

