/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TravelMode {
    TRANSIT("Transit"),
    TRUCK("Truck"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TravelMode> VALUE_MAP;
    private final String value;

    private TravelMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TravelMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TravelMode> knownValues() {
        EnumSet<TravelMode> knownValues = EnumSet.allOf(TravelMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TravelMode.class, TravelMode::toString);
    }
}

