/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.geoplaces.model.QueryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuggestQueryResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuggestQueryResult> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(SuggestQueryResult.getter(SuggestQueryResult::queryId)).setter(SuggestQueryResult.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<String> QUERY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryType").getter(SuggestQueryResult.getter(SuggestQueryResult::queryTypeAsString)).setter(SuggestQueryResult.setter(Builder::queryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, QUERY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SuggestQueryResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queryId;
    private final String queryType;

    private SuggestQueryResult(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryType = builder.queryType;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final QueryType queryType() {
        return QueryType.fromValue(this.queryType);
    }

    public final String queryTypeAsString() {
        return this.queryType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestQueryResult)) {
            return false;
        }
        SuggestQueryResult other = (SuggestQueryResult)obj;
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.queryTypeAsString(), other.queryTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SuggestQueryResult").add("QueryId", (Object)this.queryId()).add("QueryType", (Object)this.queryTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "QueryType": {
                return Optional.ofNullable(clazz.cast(this.queryTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("QueryType", QUERY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuggestQueryResult, T> g) {
        return obj -> g.apply((SuggestQueryResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryId;
        private String queryType;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestQueryResult model) {
            this.queryId(model.queryId);
            this.queryType(model.queryType);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryType() {
            return this.queryType;
        }

        public final void setQueryType(String queryType) {
            this.queryType = queryType;
        }

        @Override
        public final Builder queryType(String queryType) {
            this.queryType = queryType;
            return this;
        }

        @Override
        public final Builder queryType(QueryType queryType) {
            this.queryType(queryType == null ? null : queryType.toString());
            return this;
        }

        public SuggestQueryResult build() {
            return new SuggestQueryResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuggestQueryResult> {
        public Builder queryId(String var1);

        public Builder queryType(String var1);

        public Builder queryType(QueryType var1);
    }
}

