/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.GeoPlacesRequest;
import software.amazon.awssdk.services.geoplaces.model.PositionCopier;
import software.amazon.awssdk.services.geoplaces.model.ReverseGeocodeAdditionalFeature;
import software.amazon.awssdk.services.geoplaces.model.ReverseGeocodeAdditionalFeatureListCopier;
import software.amazon.awssdk.services.geoplaces.model.ReverseGeocodeFilter;
import software.amazon.awssdk.services.geoplaces.model.ReverseGeocodeIntendedUse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReverseGeocodeRequest
extends GeoPlacesRequest
implements ToCopyableBuilder<Builder, ReverseGeocodeRequest> {
    private static final SdkField<List<Double>> QUERY_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryPosition").getter(ReverseGeocodeRequest.getter(ReverseGeocodeRequest::queryPosition)).setter(ReverseGeocodeRequest.setter(Builder::queryPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> QUERY_RADIUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("QueryRadius").getter(ReverseGeocodeRequest.getter(ReverseGeocodeRequest::queryRadius)).setter(ReverseGeocodeRequest.setter(Builder::queryRadius)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryRadius").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ReverseGeocodeRequest.getter(ReverseGeocodeRequest::maxResults)).setter(ReverseGeocodeRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<ReverseGeocodeFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(ReverseGeocodeRequest.getter(ReverseGeocodeRequest::filter)).setter(ReverseGeocodeRequest.setter(Builder::filter)).constructor(ReverseGeocodeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalFeatures").getter(ReverseGeocodeRequest.getter(ReverseGeocodeRequest::additionalFeaturesAsStrings)).setter(ReverseGeocodeRequest.setter(Builder::additionalFeaturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(ReverseGeocodeRequest.getter(ReverseGeocodeRequest::language)).setter(ReverseGeocodeRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(ReverseGeocodeRequest.getter(ReverseGeocodeRequest::politicalView)).setter(ReverseGeocodeRequest.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()}).build();
    private static final SdkField<String> INTENDED_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntendedUse").getter(ReverseGeocodeRequest.getter(ReverseGeocodeRequest::intendedUseAsString)).setter(ReverseGeocodeRequest.setter(Builder::intendedUse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntendedUse").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(ReverseGeocodeRequest.getter(ReverseGeocodeRequest::key)).setter(ReverseGeocodeRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final SdkField<Double> HEADING_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Heading").getter(ReverseGeocodeRequest.getter(ReverseGeocodeRequest::heading)).setter(ReverseGeocodeRequest.setter(Builder::heading)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Heading").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_POSITION_FIELD, QUERY_RADIUS_FIELD, MAX_RESULTS_FIELD, FILTER_FIELD, ADDITIONAL_FEATURES_FIELD, LANGUAGE_FIELD, POLITICAL_VIEW_FIELD, INTENDED_USE_FIELD, KEY_FIELD, HEADING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReverseGeocodeRequest.memberNameToFieldInitializer();
    private final List<Double> queryPosition;
    private final Long queryRadius;
    private final Integer maxResults;
    private final ReverseGeocodeFilter filter;
    private final List<String> additionalFeatures;
    private final String language;
    private final String politicalView;
    private final String intendedUse;
    private final String key;
    private final Double heading;

    private ReverseGeocodeRequest(BuilderImpl builder) {
        super(builder);
        this.queryPosition = builder.queryPosition;
        this.queryRadius = builder.queryRadius;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
        this.additionalFeatures = builder.additionalFeatures;
        this.language = builder.language;
        this.politicalView = builder.politicalView;
        this.intendedUse = builder.intendedUse;
        this.key = builder.key;
        this.heading = builder.heading;
    }

    public final boolean hasQueryPosition() {
        return this.queryPosition != null && !(this.queryPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> queryPosition() {
        return this.queryPosition;
    }

    public final Long queryRadius() {
        return this.queryRadius;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ReverseGeocodeFilter filter() {
        return this.filter;
    }

    public final List<ReverseGeocodeAdditionalFeature> additionalFeatures() {
        return ReverseGeocodeAdditionalFeatureListCopier.copyStringToEnum(this.additionalFeatures);
    }

    public final boolean hasAdditionalFeatures() {
        return this.additionalFeatures != null && !(this.additionalFeatures instanceof SdkAutoConstructList);
    }

    public final List<String> additionalFeaturesAsStrings() {
        return this.additionalFeatures;
    }

    public final String language() {
        return this.language;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final ReverseGeocodeIntendedUse intendedUse() {
        return ReverseGeocodeIntendedUse.fromValue(this.intendedUse);
    }

    public final String intendedUseAsString() {
        return this.intendedUse;
    }

    public final String key() {
        return this.key;
    }

    public final Double heading() {
        return this.heading;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryPosition() ? this.queryPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryRadius());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalFeatures() ? this.additionalFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.intendedUseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.heading());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReverseGeocodeRequest)) {
            return false;
        }
        ReverseGeocodeRequest other = (ReverseGeocodeRequest)((Object)obj);
        return this.hasQueryPosition() == other.hasQueryPosition() && Objects.equals(this.queryPosition(), other.queryPosition()) && Objects.equals(this.queryRadius(), other.queryRadius()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.filter(), other.filter()) && this.hasAdditionalFeatures() == other.hasAdditionalFeatures() && Objects.equals(this.additionalFeaturesAsStrings(), other.additionalFeaturesAsStrings()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.politicalView(), other.politicalView()) && Objects.equals(this.intendedUseAsString(), other.intendedUseAsString()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.heading(), other.heading());
    }

    public final String toString() {
        return ToString.builder((String)"ReverseGeocodeRequest").add("QueryPosition", (Object)(this.queryPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("QueryRadius", (Object)(this.queryRadius() == null ? null : "*** Sensitive Data Redacted ***")).add("MaxResults", (Object)this.maxResults()).add("Filter", (Object)this.filter()).add("AdditionalFeatures", this.hasAdditionalFeatures() ? this.additionalFeaturesAsStrings() : null).add("Language", (Object)this.language()).add("PoliticalView", (Object)(this.politicalView() == null ? null : "*** Sensitive Data Redacted ***")).add("IntendedUse", (Object)this.intendedUseAsString()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).add("Heading", (Object)(this.heading() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryPosition": {
                return Optional.ofNullable(clazz.cast(this.queryPosition()));
            }
            case "QueryRadius": {
                return Optional.ofNullable(clazz.cast(this.queryRadius()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "AdditionalFeatures": {
                return Optional.ofNullable(clazz.cast(this.additionalFeaturesAsStrings()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "IntendedUse": {
                return Optional.ofNullable(clazz.cast(this.intendedUseAsString()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Heading": {
                return Optional.ofNullable(clazz.cast(this.heading()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueryPosition", QUERY_POSITION_FIELD);
        map.put("QueryRadius", QUERY_RADIUS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("AdditionalFeatures", ADDITIONAL_FEATURES_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("PoliticalView", POLITICAL_VIEW_FIELD);
        map.put("IntendedUse", INTENDED_USE_FIELD);
        map.put("key", KEY_FIELD);
        map.put("Heading", HEADING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReverseGeocodeRequest, T> g) {
        return obj -> g.apply((ReverseGeocodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoPlacesRequest.BuilderImpl
    implements Builder {
        private List<Double> queryPosition = DefaultSdkAutoConstructList.getInstance();
        private Long queryRadius;
        private Integer maxResults;
        private ReverseGeocodeFilter filter;
        private List<String> additionalFeatures = DefaultSdkAutoConstructList.getInstance();
        private String language;
        private String politicalView;
        private String intendedUse;
        private String key;
        private Double heading;

        private BuilderImpl() {
        }

        private BuilderImpl(ReverseGeocodeRequest model) {
            super(model);
            this.queryPosition(model.queryPosition);
            this.queryRadius(model.queryRadius);
            this.maxResults(model.maxResults);
            this.filter(model.filter);
            this.additionalFeaturesWithStrings(model.additionalFeatures);
            this.language(model.language);
            this.politicalView(model.politicalView);
            this.intendedUse(model.intendedUse);
            this.key(model.key);
            this.heading(model.heading);
        }

        public final Collection<Double> getQueryPosition() {
            if (this.queryPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queryPosition;
        }

        public final void setQueryPosition(Collection<Double> queryPosition) {
            this.queryPosition = PositionCopier.copy(queryPosition);
        }

        @Override
        public final Builder queryPosition(Collection<Double> queryPosition) {
            this.queryPosition = PositionCopier.copy(queryPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryPosition(Double ... queryPosition) {
            this.queryPosition(Arrays.asList(queryPosition));
            return this;
        }

        public final Long getQueryRadius() {
            return this.queryRadius;
        }

        public final void setQueryRadius(Long queryRadius) {
            this.queryRadius = queryRadius;
        }

        @Override
        public final Builder queryRadius(Long queryRadius) {
            this.queryRadius = queryRadius;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ReverseGeocodeFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(ReverseGeocodeFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ReverseGeocodeFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Collection<String> getAdditionalFeatures() {
            if (this.additionalFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalFeatures;
        }

        public final void setAdditionalFeatures(Collection<String> additionalFeatures) {
            this.additionalFeatures = ReverseGeocodeAdditionalFeatureListCopier.copy(additionalFeatures);
        }

        @Override
        public final Builder additionalFeaturesWithStrings(Collection<String> additionalFeatures) {
            this.additionalFeatures = ReverseGeocodeAdditionalFeatureListCopier.copy(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeaturesWithStrings(String ... additionalFeatures) {
            this.additionalFeaturesWithStrings(Arrays.asList(additionalFeatures));
            return this;
        }

        @Override
        public final Builder additionalFeatures(Collection<ReverseGeocodeAdditionalFeature> additionalFeatures) {
            this.additionalFeatures = ReverseGeocodeAdditionalFeatureListCopier.copyEnumToString(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeatures(ReverseGeocodeAdditionalFeature ... additionalFeatures) {
            this.additionalFeatures(Arrays.asList(additionalFeatures));
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getIntendedUse() {
            return this.intendedUse;
        }

        public final void setIntendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
        }

        @Override
        public final Builder intendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
            return this;
        }

        @Override
        public final Builder intendedUse(ReverseGeocodeIntendedUse intendedUse) {
            this.intendedUse(intendedUse == null ? null : intendedUse.toString());
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Double getHeading() {
            return this.heading;
        }

        public final void setHeading(Double heading) {
            this.heading = heading;
        }

        @Override
        public final Builder heading(Double heading) {
            this.heading = heading;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReverseGeocodeRequest build() {
            return new ReverseGeocodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GeoPlacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReverseGeocodeRequest> {
        public Builder queryPosition(Collection<Double> var1);

        public Builder queryPosition(Double ... var1);

        public Builder queryRadius(Long var1);

        public Builder maxResults(Integer var1);

        public Builder filter(ReverseGeocodeFilter var1);

        default public Builder filter(Consumer<ReverseGeocodeFilter.Builder> filter) {
            return this.filter((ReverseGeocodeFilter)((ReverseGeocodeFilter.Builder)ReverseGeocodeFilter.builder().applyMutation(filter)).build());
        }

        public Builder additionalFeaturesWithStrings(Collection<String> var1);

        public Builder additionalFeaturesWithStrings(String ... var1);

        public Builder additionalFeatures(Collection<ReverseGeocodeAdditionalFeature> var1);

        public Builder additionalFeatures(ReverseGeocodeAdditionalFeature ... var1);

        public Builder language(String var1);

        public Builder politicalView(String var1);

        public Builder intendedUse(String var1);

        public Builder intendedUse(ReverseGeocodeIntendedUse var1);

        public Builder key(String var1);

        public Builder heading(Double var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

