/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.LocalizedString;
import software.amazon.awssdk.services.georoutes.model.LocalizedStringListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteContinueStepDetails;
import software.amazon.awssdk.services.georoutes.model.RouteKeepStepDetails;
import software.amazon.awssdk.services.georoutes.model.RoutePedestrianTravelStepType;
import software.amazon.awssdk.services.georoutes.model.RouteRoad;
import software.amazon.awssdk.services.georoutes.model.RouteRoundaboutEnterStepDetails;
import software.amazon.awssdk.services.georoutes.model.RouteRoundaboutExitStepDetails;
import software.amazon.awssdk.services.georoutes.model.RouteRoundaboutPassStepDetails;
import software.amazon.awssdk.services.georoutes.model.RouteSignpost;
import software.amazon.awssdk.services.georoutes.model.RouteTurnStepDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutePedestrianTravelStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutePedestrianTravelStep> {
    private static final SdkField<RouteContinueStepDetails> CONTINUE_STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContinueStepDetails").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::continueStepDetails)).setter(RoutePedestrianTravelStep.setter(Builder::continueStepDetails)).constructor(RouteContinueStepDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinueStepDetails").build()}).build();
    private static final SdkField<RouteRoad> CURRENT_ROAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentRoad").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::currentRoad)).setter(RoutePedestrianTravelStep.setter(Builder::currentRoad)).constructor(RouteRoad::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentRoad").build()}).build();
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Distance").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::distance)).setter(RoutePedestrianTravelStep.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::duration)).setter(RoutePedestrianTravelStep.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<List<LocalizedString>> EXIT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExitNumber").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::exitNumber)).setter(RoutePedestrianTravelStep.setter(Builder::exitNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExitNumber").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalizedString::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> GEOMETRY_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GeometryOffset").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::geometryOffset)).setter(RoutePedestrianTravelStep.setter(Builder::geometryOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeometryOffset").build()}).build();
    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Instruction").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::instruction)).setter(RoutePedestrianTravelStep.setter(Builder::instruction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instruction").build()}).build();
    private static final SdkField<RouteKeepStepDetails> KEEP_STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeepStepDetails").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::keepStepDetails)).setter(RoutePedestrianTravelStep.setter(Builder::keepStepDetails)).constructor(RouteKeepStepDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeepStepDetails").build()}).build();
    private static final SdkField<RouteRoad> NEXT_ROAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NextRoad").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::nextRoad)).setter(RoutePedestrianTravelStep.setter(Builder::nextRoad)).constructor(RouteRoad::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextRoad").build()}).build();
    private static final SdkField<RouteRoundaboutEnterStepDetails> ROUNDABOUT_ENTER_STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoundaboutEnterStepDetails").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::roundaboutEnterStepDetails)).setter(RoutePedestrianTravelStep.setter(Builder::roundaboutEnterStepDetails)).constructor(RouteRoundaboutEnterStepDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoundaboutEnterStepDetails").build()}).build();
    private static final SdkField<RouteRoundaboutExitStepDetails> ROUNDABOUT_EXIT_STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoundaboutExitStepDetails").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::roundaboutExitStepDetails)).setter(RoutePedestrianTravelStep.setter(Builder::roundaboutExitStepDetails)).constructor(RouteRoundaboutExitStepDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoundaboutExitStepDetails").build()}).build();
    private static final SdkField<RouteRoundaboutPassStepDetails> ROUNDABOUT_PASS_STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoundaboutPassStepDetails").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::roundaboutPassStepDetails)).setter(RoutePedestrianTravelStep.setter(Builder::roundaboutPassStepDetails)).constructor(RouteRoundaboutPassStepDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoundaboutPassStepDetails").build()}).build();
    private static final SdkField<RouteSignpost> SIGNPOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Signpost").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::signpost)).setter(RoutePedestrianTravelStep.setter(Builder::signpost)).constructor(RouteSignpost::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signpost").build()}).build();
    private static final SdkField<RouteTurnStepDetails> TURN_STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TurnStepDetails").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::turnStepDetails)).setter(RoutePedestrianTravelStep.setter(Builder::turnStepDetails)).constructor(RouteTurnStepDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TurnStepDetails").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RoutePedestrianTravelStep.getter(RoutePedestrianTravelStep::typeAsString)).setter(RoutePedestrianTravelStep.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINUE_STEP_DETAILS_FIELD, CURRENT_ROAD_FIELD, DISTANCE_FIELD, DURATION_FIELD, EXIT_NUMBER_FIELD, GEOMETRY_OFFSET_FIELD, INSTRUCTION_FIELD, KEEP_STEP_DETAILS_FIELD, NEXT_ROAD_FIELD, ROUNDABOUT_ENTER_STEP_DETAILS_FIELD, ROUNDABOUT_EXIT_STEP_DETAILS_FIELD, ROUNDABOUT_PASS_STEP_DETAILS_FIELD, SIGNPOST_FIELD, TURN_STEP_DETAILS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoutePedestrianTravelStep.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RouteContinueStepDetails continueStepDetails;
    private final RouteRoad currentRoad;
    private final Long distance;
    private final Long duration;
    private final List<LocalizedString> exitNumber;
    private final Integer geometryOffset;
    private final String instruction;
    private final RouteKeepStepDetails keepStepDetails;
    private final RouteRoad nextRoad;
    private final RouteRoundaboutEnterStepDetails roundaboutEnterStepDetails;
    private final RouteRoundaboutExitStepDetails roundaboutExitStepDetails;
    private final RouteRoundaboutPassStepDetails roundaboutPassStepDetails;
    private final RouteSignpost signpost;
    private final RouteTurnStepDetails turnStepDetails;
    private final String type;

    private RoutePedestrianTravelStep(BuilderImpl builder) {
        this.continueStepDetails = builder.continueStepDetails;
        this.currentRoad = builder.currentRoad;
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.exitNumber = builder.exitNumber;
        this.geometryOffset = builder.geometryOffset;
        this.instruction = builder.instruction;
        this.keepStepDetails = builder.keepStepDetails;
        this.nextRoad = builder.nextRoad;
        this.roundaboutEnterStepDetails = builder.roundaboutEnterStepDetails;
        this.roundaboutExitStepDetails = builder.roundaboutExitStepDetails;
        this.roundaboutPassStepDetails = builder.roundaboutPassStepDetails;
        this.signpost = builder.signpost;
        this.turnStepDetails = builder.turnStepDetails;
        this.type = builder.type;
    }

    public final RouteContinueStepDetails continueStepDetails() {
        return this.continueStepDetails;
    }

    public final RouteRoad currentRoad() {
        return this.currentRoad;
    }

    public final Long distance() {
        return this.distance;
    }

    public final Long duration() {
        return this.duration;
    }

    public final boolean hasExitNumber() {
        return this.exitNumber != null && !(this.exitNumber instanceof SdkAutoConstructList);
    }

    public final List<LocalizedString> exitNumber() {
        return this.exitNumber;
    }

    public final Integer geometryOffset() {
        return this.geometryOffset;
    }

    public final String instruction() {
        return this.instruction;
    }

    public final RouteKeepStepDetails keepStepDetails() {
        return this.keepStepDetails;
    }

    public final RouteRoad nextRoad() {
        return this.nextRoad;
    }

    public final RouteRoundaboutEnterStepDetails roundaboutEnterStepDetails() {
        return this.roundaboutEnterStepDetails;
    }

    public final RouteRoundaboutExitStepDetails roundaboutExitStepDetails() {
        return this.roundaboutExitStepDetails;
    }

    public final RouteRoundaboutPassStepDetails roundaboutPassStepDetails() {
        return this.roundaboutPassStepDetails;
    }

    public final RouteSignpost signpost() {
        return this.signpost;
    }

    public final RouteTurnStepDetails turnStepDetails() {
        return this.turnStepDetails;
    }

    public final RoutePedestrianTravelStepType type() {
        return RoutePedestrianTravelStepType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.continueStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRoad());
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExitNumber() ? this.exitNumber() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.geometryOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.instruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.keepStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextRoad());
        hashCode = 31 * hashCode + Objects.hashCode(this.roundaboutEnterStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.roundaboutExitStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.roundaboutPassStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.signpost());
        hashCode = 31 * hashCode + Objects.hashCode(this.turnStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutePedestrianTravelStep)) {
            return false;
        }
        RoutePedestrianTravelStep other = (RoutePedestrianTravelStep)obj;
        return Objects.equals(this.continueStepDetails(), other.continueStepDetails()) && Objects.equals(this.currentRoad(), other.currentRoad()) && Objects.equals(this.distance(), other.distance()) && Objects.equals(this.duration(), other.duration()) && this.hasExitNumber() == other.hasExitNumber() && Objects.equals(this.exitNumber(), other.exitNumber()) && Objects.equals(this.geometryOffset(), other.geometryOffset()) && Objects.equals(this.instruction(), other.instruction()) && Objects.equals(this.keepStepDetails(), other.keepStepDetails()) && Objects.equals(this.nextRoad(), other.nextRoad()) && Objects.equals(this.roundaboutEnterStepDetails(), other.roundaboutEnterStepDetails()) && Objects.equals(this.roundaboutExitStepDetails(), other.roundaboutExitStepDetails()) && Objects.equals(this.roundaboutPassStepDetails(), other.roundaboutPassStepDetails()) && Objects.equals(this.signpost(), other.signpost()) && Objects.equals(this.turnStepDetails(), other.turnStepDetails()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RoutePedestrianTravelStep").add("ContinueStepDetails", (Object)this.continueStepDetails()).add("CurrentRoad", (Object)this.currentRoad()).add("Distance", (Object)(this.distance() == null ? null : "*** Sensitive Data Redacted ***")).add("Duration", (Object)(this.duration() == null ? null : "*** Sensitive Data Redacted ***")).add("ExitNumber", this.hasExitNumber() ? this.exitNumber() : null).add("GeometryOffset", (Object)this.geometryOffset()).add("Instruction", (Object)(this.instruction() == null ? null : "*** Sensitive Data Redacted ***")).add("KeepStepDetails", (Object)this.keepStepDetails()).add("NextRoad", (Object)this.nextRoad()).add("RoundaboutEnterStepDetails", (Object)this.roundaboutEnterStepDetails()).add("RoundaboutExitStepDetails", (Object)this.roundaboutExitStepDetails()).add("RoundaboutPassStepDetails", (Object)this.roundaboutPassStepDetails()).add("Signpost", (Object)this.signpost()).add("TurnStepDetails", (Object)this.turnStepDetails()).add("Type", (Object)(this.typeAsString() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContinueStepDetails": {
                return Optional.ofNullable(clazz.cast(this.continueStepDetails()));
            }
            case "CurrentRoad": {
                return Optional.ofNullable(clazz.cast(this.currentRoad()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "ExitNumber": {
                return Optional.ofNullable(clazz.cast(this.exitNumber()));
            }
            case "GeometryOffset": {
                return Optional.ofNullable(clazz.cast(this.geometryOffset()));
            }
            case "Instruction": {
                return Optional.ofNullable(clazz.cast(this.instruction()));
            }
            case "KeepStepDetails": {
                return Optional.ofNullable(clazz.cast(this.keepStepDetails()));
            }
            case "NextRoad": {
                return Optional.ofNullable(clazz.cast(this.nextRoad()));
            }
            case "RoundaboutEnterStepDetails": {
                return Optional.ofNullable(clazz.cast(this.roundaboutEnterStepDetails()));
            }
            case "RoundaboutExitStepDetails": {
                return Optional.ofNullable(clazz.cast(this.roundaboutExitStepDetails()));
            }
            case "RoundaboutPassStepDetails": {
                return Optional.ofNullable(clazz.cast(this.roundaboutPassStepDetails()));
            }
            case "Signpost": {
                return Optional.ofNullable(clazz.cast(this.signpost()));
            }
            case "TurnStepDetails": {
                return Optional.ofNullable(clazz.cast(this.turnStepDetails()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContinueStepDetails", CONTINUE_STEP_DETAILS_FIELD);
        map.put("CurrentRoad", CURRENT_ROAD_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("ExitNumber", EXIT_NUMBER_FIELD);
        map.put("GeometryOffset", GEOMETRY_OFFSET_FIELD);
        map.put("Instruction", INSTRUCTION_FIELD);
        map.put("KeepStepDetails", KEEP_STEP_DETAILS_FIELD);
        map.put("NextRoad", NEXT_ROAD_FIELD);
        map.put("RoundaboutEnterStepDetails", ROUNDABOUT_ENTER_STEP_DETAILS_FIELD);
        map.put("RoundaboutExitStepDetails", ROUNDABOUT_EXIT_STEP_DETAILS_FIELD);
        map.put("RoundaboutPassStepDetails", ROUNDABOUT_PASS_STEP_DETAILS_FIELD);
        map.put("Signpost", SIGNPOST_FIELD);
        map.put("TurnStepDetails", TURN_STEP_DETAILS_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutePedestrianTravelStep, T> g) {
        return obj -> g.apply((RoutePedestrianTravelStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RouteContinueStepDetails continueStepDetails;
        private RouteRoad currentRoad;
        private Long distance;
        private Long duration;
        private List<LocalizedString> exitNumber = DefaultSdkAutoConstructList.getInstance();
        private Integer geometryOffset;
        private String instruction;
        private RouteKeepStepDetails keepStepDetails;
        private RouteRoad nextRoad;
        private RouteRoundaboutEnterStepDetails roundaboutEnterStepDetails;
        private RouteRoundaboutExitStepDetails roundaboutExitStepDetails;
        private RouteRoundaboutPassStepDetails roundaboutPassStepDetails;
        private RouteSignpost signpost;
        private RouteTurnStepDetails turnStepDetails;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutePedestrianTravelStep model) {
            this.continueStepDetails(model.continueStepDetails);
            this.currentRoad(model.currentRoad);
            this.distance(model.distance);
            this.duration(model.duration);
            this.exitNumber(model.exitNumber);
            this.geometryOffset(model.geometryOffset);
            this.instruction(model.instruction);
            this.keepStepDetails(model.keepStepDetails);
            this.nextRoad(model.nextRoad);
            this.roundaboutEnterStepDetails(model.roundaboutEnterStepDetails);
            this.roundaboutExitStepDetails(model.roundaboutExitStepDetails);
            this.roundaboutPassStepDetails(model.roundaboutPassStepDetails);
            this.signpost(model.signpost);
            this.turnStepDetails(model.turnStepDetails);
            this.type(model.type);
        }

        public final RouteContinueStepDetails.Builder getContinueStepDetails() {
            return this.continueStepDetails != null ? this.continueStepDetails.toBuilder() : null;
        }

        public final void setContinueStepDetails(RouteContinueStepDetails.BuilderImpl continueStepDetails) {
            this.continueStepDetails = continueStepDetails != null ? continueStepDetails.build() : null;
        }

        @Override
        public final Builder continueStepDetails(RouteContinueStepDetails continueStepDetails) {
            this.continueStepDetails = continueStepDetails;
            return this;
        }

        public final RouteRoad.Builder getCurrentRoad() {
            return this.currentRoad != null ? this.currentRoad.toBuilder() : null;
        }

        public final void setCurrentRoad(RouteRoad.BuilderImpl currentRoad) {
            this.currentRoad = currentRoad != null ? currentRoad.build() : null;
        }

        @Override
        public final Builder currentRoad(RouteRoad currentRoad) {
            this.currentRoad = currentRoad;
            return this;
        }

        public final Long getDistance() {
            return this.distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final List<LocalizedString.Builder> getExitNumber() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.exitNumber);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExitNumber(Collection<LocalizedString.BuilderImpl> exitNumber) {
            this.exitNumber = LocalizedStringListCopier.copyFromBuilder(exitNumber);
        }

        @Override
        public final Builder exitNumber(Collection<LocalizedString> exitNumber) {
            this.exitNumber = LocalizedStringListCopier.copy(exitNumber);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exitNumber(LocalizedString ... exitNumber) {
            this.exitNumber(Arrays.asList(exitNumber));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exitNumber(Consumer<LocalizedString.Builder> ... exitNumber) {
            this.exitNumber(Stream.of(exitNumber).map(c -> (LocalizedString)((LocalizedString.Builder)LocalizedString.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getGeometryOffset() {
            return this.geometryOffset;
        }

        public final void setGeometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
        }

        @Override
        public final Builder geometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
            return this;
        }

        public final String getInstruction() {
            return this.instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final RouteKeepStepDetails.Builder getKeepStepDetails() {
            return this.keepStepDetails != null ? this.keepStepDetails.toBuilder() : null;
        }

        public final void setKeepStepDetails(RouteKeepStepDetails.BuilderImpl keepStepDetails) {
            this.keepStepDetails = keepStepDetails != null ? keepStepDetails.build() : null;
        }

        @Override
        public final Builder keepStepDetails(RouteKeepStepDetails keepStepDetails) {
            this.keepStepDetails = keepStepDetails;
            return this;
        }

        public final RouteRoad.Builder getNextRoad() {
            return this.nextRoad != null ? this.nextRoad.toBuilder() : null;
        }

        public final void setNextRoad(RouteRoad.BuilderImpl nextRoad) {
            this.nextRoad = nextRoad != null ? nextRoad.build() : null;
        }

        @Override
        public final Builder nextRoad(RouteRoad nextRoad) {
            this.nextRoad = nextRoad;
            return this;
        }

        public final RouteRoundaboutEnterStepDetails.Builder getRoundaboutEnterStepDetails() {
            return this.roundaboutEnterStepDetails != null ? this.roundaboutEnterStepDetails.toBuilder() : null;
        }

        public final void setRoundaboutEnterStepDetails(RouteRoundaboutEnterStepDetails.BuilderImpl roundaboutEnterStepDetails) {
            this.roundaboutEnterStepDetails = roundaboutEnterStepDetails != null ? roundaboutEnterStepDetails.build() : null;
        }

        @Override
        public final Builder roundaboutEnterStepDetails(RouteRoundaboutEnterStepDetails roundaboutEnterStepDetails) {
            this.roundaboutEnterStepDetails = roundaboutEnterStepDetails;
            return this;
        }

        public final RouteRoundaboutExitStepDetails.Builder getRoundaboutExitStepDetails() {
            return this.roundaboutExitStepDetails != null ? this.roundaboutExitStepDetails.toBuilder() : null;
        }

        public final void setRoundaboutExitStepDetails(RouteRoundaboutExitStepDetails.BuilderImpl roundaboutExitStepDetails) {
            this.roundaboutExitStepDetails = roundaboutExitStepDetails != null ? roundaboutExitStepDetails.build() : null;
        }

        @Override
        public final Builder roundaboutExitStepDetails(RouteRoundaboutExitStepDetails roundaboutExitStepDetails) {
            this.roundaboutExitStepDetails = roundaboutExitStepDetails;
            return this;
        }

        public final RouteRoundaboutPassStepDetails.Builder getRoundaboutPassStepDetails() {
            return this.roundaboutPassStepDetails != null ? this.roundaboutPassStepDetails.toBuilder() : null;
        }

        public final void setRoundaboutPassStepDetails(RouteRoundaboutPassStepDetails.BuilderImpl roundaboutPassStepDetails) {
            this.roundaboutPassStepDetails = roundaboutPassStepDetails != null ? roundaboutPassStepDetails.build() : null;
        }

        @Override
        public final Builder roundaboutPassStepDetails(RouteRoundaboutPassStepDetails roundaboutPassStepDetails) {
            this.roundaboutPassStepDetails = roundaboutPassStepDetails;
            return this;
        }

        public final RouteSignpost.Builder getSignpost() {
            return this.signpost != null ? this.signpost.toBuilder() : null;
        }

        public final void setSignpost(RouteSignpost.BuilderImpl signpost) {
            this.signpost = signpost != null ? signpost.build() : null;
        }

        @Override
        public final Builder signpost(RouteSignpost signpost) {
            this.signpost = signpost;
            return this;
        }

        public final RouteTurnStepDetails.Builder getTurnStepDetails() {
            return this.turnStepDetails != null ? this.turnStepDetails.toBuilder() : null;
        }

        public final void setTurnStepDetails(RouteTurnStepDetails.BuilderImpl turnStepDetails) {
            this.turnStepDetails = turnStepDetails != null ? turnStepDetails.build() : null;
        }

        @Override
        public final Builder turnStepDetails(RouteTurnStepDetails turnStepDetails) {
            this.turnStepDetails = turnStepDetails;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RoutePedestrianTravelStepType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RoutePedestrianTravelStep build() {
            return new RoutePedestrianTravelStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutePedestrianTravelStep> {
        public Builder continueStepDetails(RouteContinueStepDetails var1);

        default public Builder continueStepDetails(Consumer<RouteContinueStepDetails.Builder> continueStepDetails) {
            return this.continueStepDetails((RouteContinueStepDetails)((RouteContinueStepDetails.Builder)RouteContinueStepDetails.builder().applyMutation(continueStepDetails)).build());
        }

        public Builder currentRoad(RouteRoad var1);

        default public Builder currentRoad(Consumer<RouteRoad.Builder> currentRoad) {
            return this.currentRoad((RouteRoad)((RouteRoad.Builder)RouteRoad.builder().applyMutation(currentRoad)).build());
        }

        public Builder distance(Long var1);

        public Builder duration(Long var1);

        public Builder exitNumber(Collection<LocalizedString> var1);

        public Builder exitNumber(LocalizedString ... var1);

        public Builder exitNumber(Consumer<LocalizedString.Builder> ... var1);

        public Builder geometryOffset(Integer var1);

        public Builder instruction(String var1);

        public Builder keepStepDetails(RouteKeepStepDetails var1);

        default public Builder keepStepDetails(Consumer<RouteKeepStepDetails.Builder> keepStepDetails) {
            return this.keepStepDetails((RouteKeepStepDetails)((RouteKeepStepDetails.Builder)RouteKeepStepDetails.builder().applyMutation(keepStepDetails)).build());
        }

        public Builder nextRoad(RouteRoad var1);

        default public Builder nextRoad(Consumer<RouteRoad.Builder> nextRoad) {
            return this.nextRoad((RouteRoad)((RouteRoad.Builder)RouteRoad.builder().applyMutation(nextRoad)).build());
        }

        public Builder roundaboutEnterStepDetails(RouteRoundaboutEnterStepDetails var1);

        default public Builder roundaboutEnterStepDetails(Consumer<RouteRoundaboutEnterStepDetails.Builder> roundaboutEnterStepDetails) {
            return this.roundaboutEnterStepDetails((RouteRoundaboutEnterStepDetails)((RouteRoundaboutEnterStepDetails.Builder)RouteRoundaboutEnterStepDetails.builder().applyMutation(roundaboutEnterStepDetails)).build());
        }

        public Builder roundaboutExitStepDetails(RouteRoundaboutExitStepDetails var1);

        default public Builder roundaboutExitStepDetails(Consumer<RouteRoundaboutExitStepDetails.Builder> roundaboutExitStepDetails) {
            return this.roundaboutExitStepDetails((RouteRoundaboutExitStepDetails)((RouteRoundaboutExitStepDetails.Builder)RouteRoundaboutExitStepDetails.builder().applyMutation(roundaboutExitStepDetails)).build());
        }

        public Builder roundaboutPassStepDetails(RouteRoundaboutPassStepDetails var1);

        default public Builder roundaboutPassStepDetails(Consumer<RouteRoundaboutPassStepDetails.Builder> roundaboutPassStepDetails) {
            return this.roundaboutPassStepDetails((RouteRoundaboutPassStepDetails)((RouteRoundaboutPassStepDetails.Builder)RouteRoundaboutPassStepDetails.builder().applyMutation(roundaboutPassStepDetails)).build());
        }

        public Builder signpost(RouteSignpost var1);

        default public Builder signpost(Consumer<RouteSignpost.Builder> signpost) {
            return this.signpost((RouteSignpost)((RouteSignpost.Builder)RouteSignpost.builder().applyMutation(signpost)).build());
        }

        public Builder turnStepDetails(RouteTurnStepDetails var1);

        default public Builder turnStepDetails(Consumer<RouteTurnStepDetails.Builder> turnStepDetails) {
            return this.turnStepDetails((RouteTurnStepDetails)((RouteTurnStepDetails.Builder)RouteTurnStepDetails.builder().applyMutation(turnStepDetails)).build());
        }

        public Builder type(String var1);

        public Builder type(RoutePedestrianTravelStepType var1);
    }
}

