/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.CalculateRoutesRequestLanguagesListCopier;
import software.amazon.awssdk.services.georoutes.model.GeoRoutesRequest;
import software.amazon.awssdk.services.georoutes.model.GeometryFormat;
import software.amazon.awssdk.services.georoutes.model.MeasurementSystem;
import software.amazon.awssdk.services.georoutes.model.PositionCopier;
import software.amazon.awssdk.services.georoutes.model.RouteAllowOptions;
import software.amazon.awssdk.services.georoutes.model.RouteAvoidanceOptions;
import software.amazon.awssdk.services.georoutes.model.RouteDestinationOptions;
import software.amazon.awssdk.services.georoutes.model.RouteDriverOptions;
import software.amazon.awssdk.services.georoutes.model.RouteExclusionOptions;
import software.amazon.awssdk.services.georoutes.model.RouteLegAdditionalFeature;
import software.amazon.awssdk.services.georoutes.model.RouteLegAdditionalFeatureListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteOriginOptions;
import software.amazon.awssdk.services.georoutes.model.RouteSpanAdditionalFeature;
import software.amazon.awssdk.services.georoutes.model.RouteSpanAdditionalFeatureListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteTollOptions;
import software.amazon.awssdk.services.georoutes.model.RouteTrafficOptions;
import software.amazon.awssdk.services.georoutes.model.RouteTravelMode;
import software.amazon.awssdk.services.georoutes.model.RouteTravelModeOptions;
import software.amazon.awssdk.services.georoutes.model.RouteTravelStepType;
import software.amazon.awssdk.services.georoutes.model.RouteWaypoint;
import software.amazon.awssdk.services.georoutes.model.RouteWaypointListCopier;
import software.amazon.awssdk.services.georoutes.model.RoutingObjective;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateRoutesRequest
extends GeoRoutesRequest
implements ToCopyableBuilder<Builder, CalculateRoutesRequest> {
    private static final SdkField<RouteAllowOptions> ALLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Allow").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::allow)).setter(CalculateRoutesRequest.setter(Builder::allow)).constructor(RouteAllowOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Allow").build()}).build();
    private static final SdkField<String> ARRIVAL_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArrivalTime").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::arrivalTime)).setter(CalculateRoutesRequest.setter(Builder::arrivalTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrivalTime").build()}).build();
    private static final SdkField<RouteAvoidanceOptions> AVOID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Avoid").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::avoid)).setter(CalculateRoutesRequest.setter(Builder::avoid)).constructor(RouteAvoidanceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Avoid").build()}).build();
    private static final SdkField<Boolean> DEPART_NOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DepartNow").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::departNow)).setter(CalculateRoutesRequest.setter(Builder::departNow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartNow").build()}).build();
    private static final SdkField<String> DEPARTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DepartureTime").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::departureTime)).setter(CalculateRoutesRequest.setter(Builder::departureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build()}).build();
    private static final SdkField<List<Double>> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destination").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::destination)).setter(CalculateRoutesRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RouteDestinationOptions> DESTINATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationOptions").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::destinationOptions)).setter(CalculateRoutesRequest.setter(Builder::destinationOptions)).constructor(RouteDestinationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationOptions").build()}).build();
    private static final SdkField<RouteDriverOptions> DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Driver").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::driver)).setter(CalculateRoutesRequest.setter(Builder::driver)).constructor(RouteDriverOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Driver").build()}).build();
    private static final SdkField<RouteExclusionOptions> EXCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Exclude").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::exclude)).setter(CalculateRoutesRequest.setter(Builder::exclude)).constructor(RouteExclusionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude").build()}).build();
    private static final SdkField<String> INSTRUCTIONS_MEASUREMENT_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstructionsMeasurementSystem").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::instructionsMeasurementSystemAsString)).setter(CalculateRoutesRequest.setter(Builder::instructionsMeasurementSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstructionsMeasurementSystem").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::key)).setter(CalculateRoutesRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final SdkField<List<String>> LANGUAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Languages").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::languages)).setter(CalculateRoutesRequest.setter(Builder::languages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Languages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LEG_ADDITIONAL_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LegAdditionalFeatures").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::legAdditionalFeaturesAsStrings)).setter(CalculateRoutesRequest.setter(Builder::legAdditionalFeaturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegAdditionalFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LEG_GEOMETRY_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LegGeometryFormat").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::legGeometryFormatAsString)).setter(CalculateRoutesRequest.setter(Builder::legGeometryFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegGeometryFormat").build()}).build();
    private static final SdkField<Integer> MAX_ALTERNATIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAlternatives").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::maxAlternatives)).setter(CalculateRoutesRequest.setter(Builder::maxAlternatives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAlternatives").build()}).build();
    private static final SdkField<String> OPTIMIZE_ROUTING_FOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizeRoutingFor").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::optimizeRoutingForAsString)).setter(CalculateRoutesRequest.setter(Builder::optimizeRoutingFor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizeRoutingFor").build()}).build();
    private static final SdkField<List<Double>> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Origin").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::origin)).setter(CalculateRoutesRequest.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RouteOriginOptions> ORIGIN_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginOptions").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::originOptions)).setter(CalculateRoutesRequest.setter(Builder::originOptions)).constructor(RouteOriginOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginOptions").build()}).build();
    private static final SdkField<List<String>> SPAN_ADDITIONAL_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpanAdditionalFeatures").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::spanAdditionalFeaturesAsStrings)).setter(CalculateRoutesRequest.setter(Builder::spanAdditionalFeaturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpanAdditionalFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RouteTollOptions> TOLLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tolls").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::tolls)).setter(CalculateRoutesRequest.setter(Builder::tolls)).constructor(RouteTollOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tolls").build()}).build();
    private static final SdkField<RouteTrafficOptions> TRAFFIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Traffic").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::traffic)).setter(CalculateRoutesRequest.setter(Builder::traffic)).constructor(RouteTrafficOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traffic").build()}).build();
    private static final SdkField<String> TRAVEL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TravelMode").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::travelModeAsString)).setter(CalculateRoutesRequest.setter(Builder::travelMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()}).build();
    private static final SdkField<RouteTravelModeOptions> TRAVEL_MODE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TravelModeOptions").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::travelModeOptions)).setter(CalculateRoutesRequest.setter(Builder::travelModeOptions)).constructor(RouteTravelModeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelModeOptions").build()}).build();
    private static final SdkField<String> TRAVEL_STEP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TravelStepType").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::travelStepTypeAsString)).setter(CalculateRoutesRequest.setter(Builder::travelStepType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelStepType").build()}).build();
    private static final SdkField<List<RouteWaypoint>> WAYPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Waypoints").getter(CalculateRoutesRequest.getter(CalculateRoutesRequest::waypoints)).setter(CalculateRoutesRequest.setter(Builder::waypoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Waypoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteWaypoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_FIELD, ARRIVAL_TIME_FIELD, AVOID_FIELD, DEPART_NOW_FIELD, DEPARTURE_TIME_FIELD, DESTINATION_FIELD, DESTINATION_OPTIONS_FIELD, DRIVER_FIELD, EXCLUDE_FIELD, INSTRUCTIONS_MEASUREMENT_SYSTEM_FIELD, KEY_FIELD, LANGUAGES_FIELD, LEG_ADDITIONAL_FEATURES_FIELD, LEG_GEOMETRY_FORMAT_FIELD, MAX_ALTERNATIVES_FIELD, OPTIMIZE_ROUTING_FOR_FIELD, ORIGIN_FIELD, ORIGIN_OPTIONS_FIELD, SPAN_ADDITIONAL_FEATURES_FIELD, TOLLS_FIELD, TRAFFIC_FIELD, TRAVEL_MODE_FIELD, TRAVEL_MODE_OPTIONS_FIELD, TRAVEL_STEP_TYPE_FIELD, WAYPOINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CalculateRoutesRequest.memberNameToFieldInitializer();
    private final RouteAllowOptions allow;
    private final String arrivalTime;
    private final RouteAvoidanceOptions avoid;
    private final Boolean departNow;
    private final String departureTime;
    private final List<Double> destination;
    private final RouteDestinationOptions destinationOptions;
    private final RouteDriverOptions driver;
    private final RouteExclusionOptions exclude;
    private final String instructionsMeasurementSystem;
    private final String key;
    private final List<String> languages;
    private final List<String> legAdditionalFeatures;
    private final String legGeometryFormat;
    private final Integer maxAlternatives;
    private final String optimizeRoutingFor;
    private final List<Double> origin;
    private final RouteOriginOptions originOptions;
    private final List<String> spanAdditionalFeatures;
    private final RouteTollOptions tolls;
    private final RouteTrafficOptions traffic;
    private final String travelMode;
    private final RouteTravelModeOptions travelModeOptions;
    private final String travelStepType;
    private final List<RouteWaypoint> waypoints;

    private CalculateRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.allow = builder.allow;
        this.arrivalTime = builder.arrivalTime;
        this.avoid = builder.avoid;
        this.departNow = builder.departNow;
        this.departureTime = builder.departureTime;
        this.destination = builder.destination;
        this.destinationOptions = builder.destinationOptions;
        this.driver = builder.driver;
        this.exclude = builder.exclude;
        this.instructionsMeasurementSystem = builder.instructionsMeasurementSystem;
        this.key = builder.key;
        this.languages = builder.languages;
        this.legAdditionalFeatures = builder.legAdditionalFeatures;
        this.legGeometryFormat = builder.legGeometryFormat;
        this.maxAlternatives = builder.maxAlternatives;
        this.optimizeRoutingFor = builder.optimizeRoutingFor;
        this.origin = builder.origin;
        this.originOptions = builder.originOptions;
        this.spanAdditionalFeatures = builder.spanAdditionalFeatures;
        this.tolls = builder.tolls;
        this.traffic = builder.traffic;
        this.travelMode = builder.travelMode;
        this.travelModeOptions = builder.travelModeOptions;
        this.travelStepType = builder.travelStepType;
        this.waypoints = builder.waypoints;
    }

    public final RouteAllowOptions allow() {
        return this.allow;
    }

    public final String arrivalTime() {
        return this.arrivalTime;
    }

    public final RouteAvoidanceOptions avoid() {
        return this.avoid;
    }

    public final Boolean departNow() {
        return this.departNow;
    }

    public final String departureTime() {
        return this.departureTime;
    }

    public final boolean hasDestination() {
        return this.destination != null && !(this.destination instanceof SdkAutoConstructList);
    }

    public final List<Double> destination() {
        return this.destination;
    }

    public final RouteDestinationOptions destinationOptions() {
        return this.destinationOptions;
    }

    public final RouteDriverOptions driver() {
        return this.driver;
    }

    public final RouteExclusionOptions exclude() {
        return this.exclude;
    }

    public final MeasurementSystem instructionsMeasurementSystem() {
        return MeasurementSystem.fromValue(this.instructionsMeasurementSystem);
    }

    public final String instructionsMeasurementSystemAsString() {
        return this.instructionsMeasurementSystem;
    }

    public final String key() {
        return this.key;
    }

    public final boolean hasLanguages() {
        return this.languages != null && !(this.languages instanceof SdkAutoConstructList);
    }

    public final List<String> languages() {
        return this.languages;
    }

    public final List<RouteLegAdditionalFeature> legAdditionalFeatures() {
        return RouteLegAdditionalFeatureListCopier.copyStringToEnum(this.legAdditionalFeatures);
    }

    public final boolean hasLegAdditionalFeatures() {
        return this.legAdditionalFeatures != null && !(this.legAdditionalFeatures instanceof SdkAutoConstructList);
    }

    public final List<String> legAdditionalFeaturesAsStrings() {
        return this.legAdditionalFeatures;
    }

    public final GeometryFormat legGeometryFormat() {
        return GeometryFormat.fromValue(this.legGeometryFormat);
    }

    public final String legGeometryFormatAsString() {
        return this.legGeometryFormat;
    }

    public final Integer maxAlternatives() {
        return this.maxAlternatives;
    }

    public final RoutingObjective optimizeRoutingFor() {
        return RoutingObjective.fromValue(this.optimizeRoutingFor);
    }

    public final String optimizeRoutingForAsString() {
        return this.optimizeRoutingFor;
    }

    public final boolean hasOrigin() {
        return this.origin != null && !(this.origin instanceof SdkAutoConstructList);
    }

    public final List<Double> origin() {
        return this.origin;
    }

    public final RouteOriginOptions originOptions() {
        return this.originOptions;
    }

    public final List<RouteSpanAdditionalFeature> spanAdditionalFeatures() {
        return RouteSpanAdditionalFeatureListCopier.copyStringToEnum(this.spanAdditionalFeatures);
    }

    public final boolean hasSpanAdditionalFeatures() {
        return this.spanAdditionalFeatures != null && !(this.spanAdditionalFeatures instanceof SdkAutoConstructList);
    }

    public final List<String> spanAdditionalFeaturesAsStrings() {
        return this.spanAdditionalFeatures;
    }

    public final RouteTollOptions tolls() {
        return this.tolls;
    }

    public final RouteTrafficOptions traffic() {
        return this.traffic;
    }

    public final RouteTravelMode travelMode() {
        return RouteTravelMode.fromValue(this.travelMode);
    }

    public final String travelModeAsString() {
        return this.travelMode;
    }

    public final RouteTravelModeOptions travelModeOptions() {
        return this.travelModeOptions;
    }

    public final RouteTravelStepType travelStepType() {
        return RouteTravelStepType.fromValue(this.travelStepType);
    }

    public final String travelStepTypeAsString() {
        return this.travelStepType;
    }

    public final boolean hasWaypoints() {
        return this.waypoints != null && !(this.waypoints instanceof SdkAutoConstructList);
    }

    public final List<RouteWaypoint> waypoints() {
        return this.waypoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allow());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrivalTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.avoid());
        hashCode = 31 * hashCode + Objects.hashCode(this.departNow());
        hashCode = 31 * hashCode + Objects.hashCode(this.departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestination() ? this.destination() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.driver());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclude());
        hashCode = 31 * hashCode + Objects.hashCode(this.instructionsMeasurementSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLanguages() ? this.languages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLegAdditionalFeatures() ? this.legAdditionalFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.legGeometryFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAlternatives());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizeRoutingForAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrigin() ? this.origin() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.originOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpanAdditionalFeatures() ? this.spanAdditionalFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tolls());
        hashCode = 31 * hashCode + Objects.hashCode(this.traffic());
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.travelStepTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWaypoints() ? this.waypoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRoutesRequest)) {
            return false;
        }
        CalculateRoutesRequest other = (CalculateRoutesRequest)((Object)obj);
        return Objects.equals(this.allow(), other.allow()) && Objects.equals(this.arrivalTime(), other.arrivalTime()) && Objects.equals(this.avoid(), other.avoid()) && Objects.equals(this.departNow(), other.departNow()) && Objects.equals(this.departureTime(), other.departureTime()) && this.hasDestination() == other.hasDestination() && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationOptions(), other.destinationOptions()) && Objects.equals(this.driver(), other.driver()) && Objects.equals(this.exclude(), other.exclude()) && Objects.equals(this.instructionsMeasurementSystemAsString(), other.instructionsMeasurementSystemAsString()) && Objects.equals(this.key(), other.key()) && this.hasLanguages() == other.hasLanguages() && Objects.equals(this.languages(), other.languages()) && this.hasLegAdditionalFeatures() == other.hasLegAdditionalFeatures() && Objects.equals(this.legAdditionalFeaturesAsStrings(), other.legAdditionalFeaturesAsStrings()) && Objects.equals(this.legGeometryFormatAsString(), other.legGeometryFormatAsString()) && Objects.equals(this.maxAlternatives(), other.maxAlternatives()) && Objects.equals(this.optimizeRoutingForAsString(), other.optimizeRoutingForAsString()) && this.hasOrigin() == other.hasOrigin() && Objects.equals(this.origin(), other.origin()) && Objects.equals(this.originOptions(), other.originOptions()) && this.hasSpanAdditionalFeatures() == other.hasSpanAdditionalFeatures() && Objects.equals(this.spanAdditionalFeaturesAsStrings(), other.spanAdditionalFeaturesAsStrings()) && Objects.equals(this.tolls(), other.tolls()) && Objects.equals(this.traffic(), other.traffic()) && Objects.equals(this.travelModeAsString(), other.travelModeAsString()) && Objects.equals(this.travelModeOptions(), other.travelModeOptions()) && Objects.equals(this.travelStepTypeAsString(), other.travelStepTypeAsString()) && this.hasWaypoints() == other.hasWaypoints() && Objects.equals(this.waypoints(), other.waypoints());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateRoutesRequest").add("Allow", (Object)this.allow()).add("ArrivalTime", (Object)(this.arrivalTime() == null ? null : "*** Sensitive Data Redacted ***")).add("Avoid", (Object)this.avoid()).add("DepartNow", (Object)(this.departNow() == null ? null : "*** Sensitive Data Redacted ***")).add("DepartureTime", (Object)(this.departureTime() == null ? null : "*** Sensitive Data Redacted ***")).add("Destination", (Object)(this.destination() == null ? null : "*** Sensitive Data Redacted ***")).add("DestinationOptions", (Object)this.destinationOptions()).add("Driver", (Object)this.driver()).add("Exclude", (Object)this.exclude()).add("InstructionsMeasurementSystem", (Object)this.instructionsMeasurementSystemAsString()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).add("Languages", this.hasLanguages() ? this.languages() : null).add("LegAdditionalFeatures", (Object)(this.legAdditionalFeaturesAsStrings() == null ? null : "*** Sensitive Data Redacted ***")).add("LegGeometryFormat", (Object)this.legGeometryFormatAsString()).add("MaxAlternatives", (Object)this.maxAlternatives()).add("OptimizeRoutingFor", (Object)this.optimizeRoutingForAsString()).add("Origin", (Object)(this.origin() == null ? null : "*** Sensitive Data Redacted ***")).add("OriginOptions", (Object)this.originOptions()).add("SpanAdditionalFeatures", this.hasSpanAdditionalFeatures() ? this.spanAdditionalFeaturesAsStrings() : null).add("Tolls", (Object)this.tolls()).add("Traffic", (Object)this.traffic()).add("TravelMode", (Object)this.travelModeAsString()).add("TravelModeOptions", (Object)this.travelModeOptions()).add("TravelStepType", (Object)this.travelStepTypeAsString()).add("Waypoints", this.hasWaypoints() ? this.waypoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Allow": {
                return Optional.ofNullable(clazz.cast(this.allow()));
            }
            case "ArrivalTime": {
                return Optional.ofNullable(clazz.cast(this.arrivalTime()));
            }
            case "Avoid": {
                return Optional.ofNullable(clazz.cast(this.avoid()));
            }
            case "DepartNow": {
                return Optional.ofNullable(clazz.cast(this.departNow()));
            }
            case "DepartureTime": {
                return Optional.ofNullable(clazz.cast(this.departureTime()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DestinationOptions": {
                return Optional.ofNullable(clazz.cast(this.destinationOptions()));
            }
            case "Driver": {
                return Optional.ofNullable(clazz.cast(this.driver()));
            }
            case "Exclude": {
                return Optional.ofNullable(clazz.cast(this.exclude()));
            }
            case "InstructionsMeasurementSystem": {
                return Optional.ofNullable(clazz.cast(this.instructionsMeasurementSystemAsString()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Languages": {
                return Optional.ofNullable(clazz.cast(this.languages()));
            }
            case "LegAdditionalFeatures": {
                return Optional.ofNullable(clazz.cast(this.legAdditionalFeaturesAsStrings()));
            }
            case "LegGeometryFormat": {
                return Optional.ofNullable(clazz.cast(this.legGeometryFormatAsString()));
            }
            case "MaxAlternatives": {
                return Optional.ofNullable(clazz.cast(this.maxAlternatives()));
            }
            case "OptimizeRoutingFor": {
                return Optional.ofNullable(clazz.cast(this.optimizeRoutingForAsString()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.origin()));
            }
            case "OriginOptions": {
                return Optional.ofNullable(clazz.cast(this.originOptions()));
            }
            case "SpanAdditionalFeatures": {
                return Optional.ofNullable(clazz.cast(this.spanAdditionalFeaturesAsStrings()));
            }
            case "Tolls": {
                return Optional.ofNullable(clazz.cast(this.tolls()));
            }
            case "Traffic": {
                return Optional.ofNullable(clazz.cast(this.traffic()));
            }
            case "TravelMode": {
                return Optional.ofNullable(clazz.cast(this.travelModeAsString()));
            }
            case "TravelModeOptions": {
                return Optional.ofNullable(clazz.cast(this.travelModeOptions()));
            }
            case "TravelStepType": {
                return Optional.ofNullable(clazz.cast(this.travelStepTypeAsString()));
            }
            case "Waypoints": {
                return Optional.ofNullable(clazz.cast(this.waypoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Allow", ALLOW_FIELD);
        map.put("ArrivalTime", ARRIVAL_TIME_FIELD);
        map.put("Avoid", AVOID_FIELD);
        map.put("DepartNow", DEPART_NOW_FIELD);
        map.put("DepartureTime", DEPARTURE_TIME_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("DestinationOptions", DESTINATION_OPTIONS_FIELD);
        map.put("Driver", DRIVER_FIELD);
        map.put("Exclude", EXCLUDE_FIELD);
        map.put("InstructionsMeasurementSystem", INSTRUCTIONS_MEASUREMENT_SYSTEM_FIELD);
        map.put("key", KEY_FIELD);
        map.put("Languages", LANGUAGES_FIELD);
        map.put("LegAdditionalFeatures", LEG_ADDITIONAL_FEATURES_FIELD);
        map.put("LegGeometryFormat", LEG_GEOMETRY_FORMAT_FIELD);
        map.put("MaxAlternatives", MAX_ALTERNATIVES_FIELD);
        map.put("OptimizeRoutingFor", OPTIMIZE_ROUTING_FOR_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("OriginOptions", ORIGIN_OPTIONS_FIELD);
        map.put("SpanAdditionalFeatures", SPAN_ADDITIONAL_FEATURES_FIELD);
        map.put("Tolls", TOLLS_FIELD);
        map.put("Traffic", TRAFFIC_FIELD);
        map.put("TravelMode", TRAVEL_MODE_FIELD);
        map.put("TravelModeOptions", TRAVEL_MODE_OPTIONS_FIELD);
        map.put("TravelStepType", TRAVEL_STEP_TYPE_FIELD);
        map.put("Waypoints", WAYPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateRoutesRequest, T> g) {
        return obj -> g.apply((CalculateRoutesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoRoutesRequest.BuilderImpl
    implements Builder {
        private RouteAllowOptions allow;
        private String arrivalTime;
        private RouteAvoidanceOptions avoid;
        private Boolean departNow;
        private String departureTime;
        private List<Double> destination = DefaultSdkAutoConstructList.getInstance();
        private RouteDestinationOptions destinationOptions;
        private RouteDriverOptions driver;
        private RouteExclusionOptions exclude;
        private String instructionsMeasurementSystem;
        private String key;
        private List<String> languages = DefaultSdkAutoConstructList.getInstance();
        private List<String> legAdditionalFeatures = DefaultSdkAutoConstructList.getInstance();
        private String legGeometryFormat;
        private Integer maxAlternatives;
        private String optimizeRoutingFor;
        private List<Double> origin = DefaultSdkAutoConstructList.getInstance();
        private RouteOriginOptions originOptions;
        private List<String> spanAdditionalFeatures = DefaultSdkAutoConstructList.getInstance();
        private RouteTollOptions tolls;
        private RouteTrafficOptions traffic;
        private String travelMode;
        private RouteTravelModeOptions travelModeOptions;
        private String travelStepType;
        private List<RouteWaypoint> waypoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRoutesRequest model) {
            super(model);
            this.allow(model.allow);
            this.arrivalTime(model.arrivalTime);
            this.avoid(model.avoid);
            this.departNow(model.departNow);
            this.departureTime(model.departureTime);
            this.destination(model.destination);
            this.destinationOptions(model.destinationOptions);
            this.driver(model.driver);
            this.exclude(model.exclude);
            this.instructionsMeasurementSystem(model.instructionsMeasurementSystem);
            this.key(model.key);
            this.languages(model.languages);
            this.legAdditionalFeaturesWithStrings(model.legAdditionalFeatures);
            this.legGeometryFormat(model.legGeometryFormat);
            this.maxAlternatives(model.maxAlternatives);
            this.optimizeRoutingFor(model.optimizeRoutingFor);
            this.origin(model.origin);
            this.originOptions(model.originOptions);
            this.spanAdditionalFeaturesWithStrings(model.spanAdditionalFeatures);
            this.tolls(model.tolls);
            this.traffic(model.traffic);
            this.travelMode(model.travelMode);
            this.travelModeOptions(model.travelModeOptions);
            this.travelStepType(model.travelStepType);
            this.waypoints(model.waypoints);
        }

        public final RouteAllowOptions.Builder getAllow() {
            return this.allow != null ? this.allow.toBuilder() : null;
        }

        public final void setAllow(RouteAllowOptions.BuilderImpl allow) {
            this.allow = allow != null ? allow.build() : null;
        }

        @Override
        public final Builder allow(RouteAllowOptions allow) {
            this.allow = allow;
            return this;
        }

        public final String getArrivalTime() {
            return this.arrivalTime;
        }

        public final void setArrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
        }

        @Override
        public final Builder arrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
            return this;
        }

        public final RouteAvoidanceOptions.Builder getAvoid() {
            return this.avoid != null ? this.avoid.toBuilder() : null;
        }

        public final void setAvoid(RouteAvoidanceOptions.BuilderImpl avoid) {
            this.avoid = avoid != null ? avoid.build() : null;
        }

        @Override
        public final Builder avoid(RouteAvoidanceOptions avoid) {
            this.avoid = avoid;
            return this;
        }

        public final Boolean getDepartNow() {
            return this.departNow;
        }

        public final void setDepartNow(Boolean departNow) {
            this.departNow = departNow;
        }

        @Override
        public final Builder departNow(Boolean departNow) {
            this.departNow = departNow;
            return this;
        }

        public final String getDepartureTime() {
            return this.departureTime;
        }

        public final void setDepartureTime(String departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        public final Builder departureTime(String departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final Collection<Double> getDestination() {
            if (this.destination instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destination;
        }

        public final void setDestination(Collection<Double> destination) {
            this.destination = PositionCopier.copy(destination);
        }

        @Override
        public final Builder destination(Collection<Double> destination) {
            this.destination = PositionCopier.copy(destination);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destination(Double ... destination) {
            this.destination(Arrays.asList(destination));
            return this;
        }

        public final RouteDestinationOptions.Builder getDestinationOptions() {
            return this.destinationOptions != null ? this.destinationOptions.toBuilder() : null;
        }

        public final void setDestinationOptions(RouteDestinationOptions.BuilderImpl destinationOptions) {
            this.destinationOptions = destinationOptions != null ? destinationOptions.build() : null;
        }

        @Override
        public final Builder destinationOptions(RouteDestinationOptions destinationOptions) {
            this.destinationOptions = destinationOptions;
            return this;
        }

        public final RouteDriverOptions.Builder getDriver() {
            return this.driver != null ? this.driver.toBuilder() : null;
        }

        public final void setDriver(RouteDriverOptions.BuilderImpl driver) {
            this.driver = driver != null ? driver.build() : null;
        }

        @Override
        public final Builder driver(RouteDriverOptions driver) {
            this.driver = driver;
            return this;
        }

        public final RouteExclusionOptions.Builder getExclude() {
            return this.exclude != null ? this.exclude.toBuilder() : null;
        }

        public final void setExclude(RouteExclusionOptions.BuilderImpl exclude) {
            this.exclude = exclude != null ? exclude.build() : null;
        }

        @Override
        public final Builder exclude(RouteExclusionOptions exclude) {
            this.exclude = exclude;
            return this;
        }

        public final String getInstructionsMeasurementSystem() {
            return this.instructionsMeasurementSystem;
        }

        public final void setInstructionsMeasurementSystem(String instructionsMeasurementSystem) {
            this.instructionsMeasurementSystem = instructionsMeasurementSystem;
        }

        @Override
        public final Builder instructionsMeasurementSystem(String instructionsMeasurementSystem) {
            this.instructionsMeasurementSystem = instructionsMeasurementSystem;
            return this;
        }

        @Override
        public final Builder instructionsMeasurementSystem(MeasurementSystem instructionsMeasurementSystem) {
            this.instructionsMeasurementSystem(instructionsMeasurementSystem == null ? null : instructionsMeasurementSystem.toString());
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Collection<String> getLanguages() {
            if (this.languages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.languages;
        }

        public final void setLanguages(Collection<String> languages) {
            this.languages = CalculateRoutesRequestLanguagesListCopier.copy(languages);
        }

        @Override
        public final Builder languages(Collection<String> languages) {
            this.languages = CalculateRoutesRequestLanguagesListCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(String ... languages) {
            this.languages(Arrays.asList(languages));
            return this;
        }

        public final Collection<String> getLegAdditionalFeatures() {
            if (this.legAdditionalFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.legAdditionalFeatures;
        }

        public final void setLegAdditionalFeatures(Collection<String> legAdditionalFeatures) {
            this.legAdditionalFeatures = RouteLegAdditionalFeatureListCopier.copy(legAdditionalFeatures);
        }

        @Override
        public final Builder legAdditionalFeaturesWithStrings(Collection<String> legAdditionalFeatures) {
            this.legAdditionalFeatures = RouteLegAdditionalFeatureListCopier.copy(legAdditionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder legAdditionalFeaturesWithStrings(String ... legAdditionalFeatures) {
            this.legAdditionalFeaturesWithStrings(Arrays.asList(legAdditionalFeatures));
            return this;
        }

        @Override
        public final Builder legAdditionalFeatures(Collection<RouteLegAdditionalFeature> legAdditionalFeatures) {
            this.legAdditionalFeatures = RouteLegAdditionalFeatureListCopier.copyEnumToString(legAdditionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder legAdditionalFeatures(RouteLegAdditionalFeature ... legAdditionalFeatures) {
            this.legAdditionalFeatures(Arrays.asList(legAdditionalFeatures));
            return this;
        }

        public final String getLegGeometryFormat() {
            return this.legGeometryFormat;
        }

        public final void setLegGeometryFormat(String legGeometryFormat) {
            this.legGeometryFormat = legGeometryFormat;
        }

        @Override
        public final Builder legGeometryFormat(String legGeometryFormat) {
            this.legGeometryFormat = legGeometryFormat;
            return this;
        }

        @Override
        public final Builder legGeometryFormat(GeometryFormat legGeometryFormat) {
            this.legGeometryFormat(legGeometryFormat == null ? null : legGeometryFormat.toString());
            return this;
        }

        public final Integer getMaxAlternatives() {
            return this.maxAlternatives;
        }

        public final void setMaxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
        }

        @Override
        public final Builder maxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public final String getOptimizeRoutingFor() {
            return this.optimizeRoutingFor;
        }

        public final void setOptimizeRoutingFor(String optimizeRoutingFor) {
            this.optimizeRoutingFor = optimizeRoutingFor;
        }

        @Override
        public final Builder optimizeRoutingFor(String optimizeRoutingFor) {
            this.optimizeRoutingFor = optimizeRoutingFor;
            return this;
        }

        @Override
        public final Builder optimizeRoutingFor(RoutingObjective optimizeRoutingFor) {
            this.optimizeRoutingFor(optimizeRoutingFor == null ? null : optimizeRoutingFor.toString());
            return this;
        }

        public final Collection<Double> getOrigin() {
            if (this.origin instanceof SdkAutoConstructList) {
                return null;
            }
            return this.origin;
        }

        public final void setOrigin(Collection<Double> origin) {
            this.origin = PositionCopier.copy(origin);
        }

        @Override
        public final Builder origin(Collection<Double> origin) {
            this.origin = PositionCopier.copy(origin);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder origin(Double ... origin) {
            this.origin(Arrays.asList(origin));
            return this;
        }

        public final RouteOriginOptions.Builder getOriginOptions() {
            return this.originOptions != null ? this.originOptions.toBuilder() : null;
        }

        public final void setOriginOptions(RouteOriginOptions.BuilderImpl originOptions) {
            this.originOptions = originOptions != null ? originOptions.build() : null;
        }

        @Override
        public final Builder originOptions(RouteOriginOptions originOptions) {
            this.originOptions = originOptions;
            return this;
        }

        public final Collection<String> getSpanAdditionalFeatures() {
            if (this.spanAdditionalFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.spanAdditionalFeatures;
        }

        public final void setSpanAdditionalFeatures(Collection<String> spanAdditionalFeatures) {
            this.spanAdditionalFeatures = RouteSpanAdditionalFeatureListCopier.copy(spanAdditionalFeatures);
        }

        @Override
        public final Builder spanAdditionalFeaturesWithStrings(Collection<String> spanAdditionalFeatures) {
            this.spanAdditionalFeatures = RouteSpanAdditionalFeatureListCopier.copy(spanAdditionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spanAdditionalFeaturesWithStrings(String ... spanAdditionalFeatures) {
            this.spanAdditionalFeaturesWithStrings(Arrays.asList(spanAdditionalFeatures));
            return this;
        }

        @Override
        public final Builder spanAdditionalFeatures(Collection<RouteSpanAdditionalFeature> spanAdditionalFeatures) {
            this.spanAdditionalFeatures = RouteSpanAdditionalFeatureListCopier.copyEnumToString(spanAdditionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spanAdditionalFeatures(RouteSpanAdditionalFeature ... spanAdditionalFeatures) {
            this.spanAdditionalFeatures(Arrays.asList(spanAdditionalFeatures));
            return this;
        }

        public final RouteTollOptions.Builder getTolls() {
            return this.tolls != null ? this.tolls.toBuilder() : null;
        }

        public final void setTolls(RouteTollOptions.BuilderImpl tolls) {
            this.tolls = tolls != null ? tolls.build() : null;
        }

        @Override
        public final Builder tolls(RouteTollOptions tolls) {
            this.tolls = tolls;
            return this;
        }

        public final RouteTrafficOptions.Builder getTraffic() {
            return this.traffic != null ? this.traffic.toBuilder() : null;
        }

        public final void setTraffic(RouteTrafficOptions.BuilderImpl traffic) {
            this.traffic = traffic != null ? traffic.build() : null;
        }

        @Override
        public final Builder traffic(RouteTrafficOptions traffic) {
            this.traffic = traffic;
            return this;
        }

        public final String getTravelMode() {
            return this.travelMode;
        }

        public final void setTravelMode(String travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(String travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        @Override
        public final Builder travelMode(RouteTravelMode travelMode) {
            this.travelMode(travelMode == null ? null : travelMode.toString());
            return this;
        }

        public final RouteTravelModeOptions.Builder getTravelModeOptions() {
            return this.travelModeOptions != null ? this.travelModeOptions.toBuilder() : null;
        }

        public final void setTravelModeOptions(RouteTravelModeOptions.BuilderImpl travelModeOptions) {
            this.travelModeOptions = travelModeOptions != null ? travelModeOptions.build() : null;
        }

        @Override
        public final Builder travelModeOptions(RouteTravelModeOptions travelModeOptions) {
            this.travelModeOptions = travelModeOptions;
            return this;
        }

        public final String getTravelStepType() {
            return this.travelStepType;
        }

        public final void setTravelStepType(String travelStepType) {
            this.travelStepType = travelStepType;
        }

        @Override
        public final Builder travelStepType(String travelStepType) {
            this.travelStepType = travelStepType;
            return this;
        }

        @Override
        public final Builder travelStepType(RouteTravelStepType travelStepType) {
            this.travelStepType(travelStepType == null ? null : travelStepType.toString());
            return this;
        }

        public final List<RouteWaypoint.Builder> getWaypoints() {
            List<RouteWaypoint.Builder> result = RouteWaypointListCopier.copyToBuilder(this.waypoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWaypoints(Collection<RouteWaypoint.BuilderImpl> waypoints) {
            this.waypoints = RouteWaypointListCopier.copyFromBuilder(waypoints);
        }

        @Override
        public final Builder waypoints(Collection<RouteWaypoint> waypoints) {
            this.waypoints = RouteWaypointListCopier.copy(waypoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder waypoints(RouteWaypoint ... waypoints) {
            this.waypoints(Arrays.asList(waypoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder waypoints(Consumer<RouteWaypoint.Builder> ... waypoints) {
            this.waypoints(Stream.of(waypoints).map(c -> (RouteWaypoint)((RouteWaypoint.Builder)RouteWaypoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CalculateRoutesRequest build() {
            return new CalculateRoutesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GeoRoutesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CalculateRoutesRequest> {
        public Builder allow(RouteAllowOptions var1);

        default public Builder allow(Consumer<RouteAllowOptions.Builder> allow) {
            return this.allow((RouteAllowOptions)((RouteAllowOptions.Builder)RouteAllowOptions.builder().applyMutation(allow)).build());
        }

        public Builder arrivalTime(String var1);

        public Builder avoid(RouteAvoidanceOptions var1);

        default public Builder avoid(Consumer<RouteAvoidanceOptions.Builder> avoid) {
            return this.avoid((RouteAvoidanceOptions)((RouteAvoidanceOptions.Builder)RouteAvoidanceOptions.builder().applyMutation(avoid)).build());
        }

        public Builder departNow(Boolean var1);

        public Builder departureTime(String var1);

        public Builder destination(Collection<Double> var1);

        public Builder destination(Double ... var1);

        public Builder destinationOptions(RouteDestinationOptions var1);

        default public Builder destinationOptions(Consumer<RouteDestinationOptions.Builder> destinationOptions) {
            return this.destinationOptions((RouteDestinationOptions)((RouteDestinationOptions.Builder)RouteDestinationOptions.builder().applyMutation(destinationOptions)).build());
        }

        public Builder driver(RouteDriverOptions var1);

        default public Builder driver(Consumer<RouteDriverOptions.Builder> driver) {
            return this.driver((RouteDriverOptions)((RouteDriverOptions.Builder)RouteDriverOptions.builder().applyMutation(driver)).build());
        }

        public Builder exclude(RouteExclusionOptions var1);

        default public Builder exclude(Consumer<RouteExclusionOptions.Builder> exclude) {
            return this.exclude((RouteExclusionOptions)((RouteExclusionOptions.Builder)RouteExclusionOptions.builder().applyMutation(exclude)).build());
        }

        public Builder instructionsMeasurementSystem(String var1);

        public Builder instructionsMeasurementSystem(MeasurementSystem var1);

        public Builder key(String var1);

        public Builder languages(Collection<String> var1);

        public Builder languages(String ... var1);

        public Builder legAdditionalFeaturesWithStrings(Collection<String> var1);

        public Builder legAdditionalFeaturesWithStrings(String ... var1);

        public Builder legAdditionalFeatures(Collection<RouteLegAdditionalFeature> var1);

        public Builder legAdditionalFeatures(RouteLegAdditionalFeature ... var1);

        public Builder legGeometryFormat(String var1);

        public Builder legGeometryFormat(GeometryFormat var1);

        public Builder maxAlternatives(Integer var1);

        public Builder optimizeRoutingFor(String var1);

        public Builder optimizeRoutingFor(RoutingObjective var1);

        public Builder origin(Collection<Double> var1);

        public Builder origin(Double ... var1);

        public Builder originOptions(RouteOriginOptions var1);

        default public Builder originOptions(Consumer<RouteOriginOptions.Builder> originOptions) {
            return this.originOptions((RouteOriginOptions)((RouteOriginOptions.Builder)RouteOriginOptions.builder().applyMutation(originOptions)).build());
        }

        public Builder spanAdditionalFeaturesWithStrings(Collection<String> var1);

        public Builder spanAdditionalFeaturesWithStrings(String ... var1);

        public Builder spanAdditionalFeatures(Collection<RouteSpanAdditionalFeature> var1);

        public Builder spanAdditionalFeatures(RouteSpanAdditionalFeature ... var1);

        public Builder tolls(RouteTollOptions var1);

        default public Builder tolls(Consumer<RouteTollOptions.Builder> tolls) {
            return this.tolls((RouteTollOptions)((RouteTollOptions.Builder)RouteTollOptions.builder().applyMutation(tolls)).build());
        }

        public Builder traffic(RouteTrafficOptions var1);

        default public Builder traffic(Consumer<RouteTrafficOptions.Builder> traffic) {
            return this.traffic((RouteTrafficOptions)((RouteTrafficOptions.Builder)RouteTrafficOptions.builder().applyMutation(traffic)).build());
        }

        public Builder travelMode(String var1);

        public Builder travelMode(RouteTravelMode var1);

        public Builder travelModeOptions(RouteTravelModeOptions var1);

        default public Builder travelModeOptions(Consumer<RouteTravelModeOptions.Builder> travelModeOptions) {
            return this.travelModeOptions((RouteTravelModeOptions)((RouteTravelModeOptions.Builder)RouteTravelModeOptions.builder().applyMutation(travelModeOptions)).build());
        }

        public Builder travelStepType(String var1);

        public Builder travelStepType(RouteTravelStepType var1);

        public Builder waypoints(Collection<RouteWaypoint> var1);

        public Builder waypoints(RouteWaypoint ... var1);

        public Builder waypoints(Consumer<RouteWaypoint.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

