/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.BoundingBoxCopier;
import software.amazon.awssdk.services.georoutes.model.Circle;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixAutoCircle;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixBoundaryGeometryPolygonListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteMatrixBoundaryGeometry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteMatrixBoundaryGeometry> {
    private static final SdkField<RouteMatrixAutoCircle> AUTO_CIRCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoCircle").getter(RouteMatrixBoundaryGeometry.getter(RouteMatrixBoundaryGeometry::autoCircle)).setter(RouteMatrixBoundaryGeometry.setter(Builder::autoCircle)).constructor(RouteMatrixAutoCircle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoCircle").build()}).build();
    private static final SdkField<Circle> CIRCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Circle").getter(RouteMatrixBoundaryGeometry.getter(RouteMatrixBoundaryGeometry::circle)).setter(RouteMatrixBoundaryGeometry.setter(Builder::circle)).constructor(Circle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Circle").build()}).build();
    private static final SdkField<List<Double>> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BoundingBox").getter(RouteMatrixBoundaryGeometry.getter(RouteMatrixBoundaryGeometry::boundingBox)).setter(RouteMatrixBoundaryGeometry.setter(Builder::boundingBox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<List<Double>>>> POLYGON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Polygon").getter(RouteMatrixBoundaryGeometry.getter(RouteMatrixBoundaryGeometry::polygon)).setter(RouteMatrixBoundaryGeometry.setter(Builder::polygon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Polygon").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_CIRCLE_FIELD, CIRCLE_FIELD, BOUNDING_BOX_FIELD, POLYGON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteMatrixBoundaryGeometry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RouteMatrixAutoCircle autoCircle;
    private final Circle circle;
    private final List<Double> boundingBox;
    private final List<List<List<Double>>> polygon;

    private RouteMatrixBoundaryGeometry(BuilderImpl builder) {
        this.autoCircle = builder.autoCircle;
        this.circle = builder.circle;
        this.boundingBox = builder.boundingBox;
        this.polygon = builder.polygon;
    }

    public final RouteMatrixAutoCircle autoCircle() {
        return this.autoCircle;
    }

    public final Circle circle() {
        return this.circle;
    }

    public final boolean hasBoundingBox() {
        return this.boundingBox != null && !(this.boundingBox instanceof SdkAutoConstructList);
    }

    public final List<Double> boundingBox() {
        return this.boundingBox;
    }

    public final boolean hasPolygon() {
        return this.polygon != null && !(this.polygon instanceof SdkAutoConstructList);
    }

    public final List<List<List<Double>>> polygon() {
        return this.polygon;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoCircle());
        hashCode = 31 * hashCode + Objects.hashCode(this.circle());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBoundingBox() ? this.boundingBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolygon() ? this.polygon() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixBoundaryGeometry)) {
            return false;
        }
        RouteMatrixBoundaryGeometry other = (RouteMatrixBoundaryGeometry)obj;
        return Objects.equals(this.autoCircle(), other.autoCircle()) && Objects.equals(this.circle(), other.circle()) && this.hasBoundingBox() == other.hasBoundingBox() && Objects.equals(this.boundingBox(), other.boundingBox()) && this.hasPolygon() == other.hasPolygon() && Objects.equals(this.polygon(), other.polygon());
    }

    public final String toString() {
        return ToString.builder((String)"RouteMatrixBoundaryGeometry").add("AutoCircle", (Object)this.autoCircle()).add("Circle", (Object)(this.circle() == null ? null : "*** Sensitive Data Redacted ***")).add("BoundingBox", (Object)(this.boundingBox() == null ? null : "*** Sensitive Data Redacted ***")).add("Polygon", (Object)(this.polygon() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoCircle": {
                return Optional.ofNullable(clazz.cast(this.autoCircle()));
            }
            case "Circle": {
                return Optional.ofNullable(clazz.cast(this.circle()));
            }
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Polygon": {
                return Optional.ofNullable(clazz.cast(this.polygon()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutoCircle", AUTO_CIRCLE_FIELD);
        map.put("Circle", CIRCLE_FIELD);
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        map.put("Polygon", POLYGON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixBoundaryGeometry, T> g) {
        return obj -> g.apply((RouteMatrixBoundaryGeometry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RouteMatrixAutoCircle autoCircle;
        private Circle circle;
        private List<Double> boundingBox = DefaultSdkAutoConstructList.getInstance();
        private List<List<List<Double>>> polygon = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixBoundaryGeometry model) {
            this.autoCircle(model.autoCircle);
            this.circle(model.circle);
            this.boundingBox(model.boundingBox);
            this.polygon(model.polygon);
        }

        public final RouteMatrixAutoCircle.Builder getAutoCircle() {
            return this.autoCircle != null ? this.autoCircle.toBuilder() : null;
        }

        public final void setAutoCircle(RouteMatrixAutoCircle.BuilderImpl autoCircle) {
            this.autoCircle = autoCircle != null ? autoCircle.build() : null;
        }

        @Override
        public final Builder autoCircle(RouteMatrixAutoCircle autoCircle) {
            this.autoCircle = autoCircle;
            return this;
        }

        public final Circle.Builder getCircle() {
            return this.circle != null ? this.circle.toBuilder() : null;
        }

        public final void setCircle(Circle.BuilderImpl circle) {
            this.circle = circle != null ? circle.build() : null;
        }

        @Override
        public final Builder circle(Circle circle) {
            this.circle = circle;
            return this;
        }

        public final Collection<Double> getBoundingBox() {
            if (this.boundingBox instanceof SdkAutoConstructList) {
                return null;
            }
            return this.boundingBox;
        }

        public final void setBoundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
        }

        @Override
        public final Builder boundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder boundingBox(Double ... boundingBox) {
            this.boundingBox(Arrays.asList(boundingBox));
            return this;
        }

        public final Collection<? extends Collection<? extends Collection<Double>>> getPolygon() {
            if (this.polygon instanceof SdkAutoConstructList) {
                return null;
            }
            return this.polygon;
        }

        public final void setPolygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = RouteMatrixBoundaryGeometryPolygonListCopier.copy(polygon);
        }

        @Override
        public final Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = RouteMatrixBoundaryGeometryPolygonListCopier.copy(polygon);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Collection<? extends Collection<Double>> ... polygon) {
            this.polygon((Collection<? extends Collection<? extends Collection<Double>>>)Arrays.asList(polygon));
            return this;
        }

        public RouteMatrixBoundaryGeometry build() {
            return new RouteMatrixBoundaryGeometry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteMatrixBoundaryGeometry> {
        public Builder autoCircle(RouteMatrixAutoCircle var1);

        default public Builder autoCircle(Consumer<RouteMatrixAutoCircle.Builder> autoCircle) {
            return this.autoCircle((RouteMatrixAutoCircle)((RouteMatrixAutoCircle.Builder)RouteMatrixAutoCircle.builder().applyMutation(autoCircle)).build());
        }

        public Builder circle(Circle var1);

        default public Builder circle(Consumer<Circle.Builder> circle) {
            return this.circle((Circle)((Circle.Builder)Circle.builder().applyMutation(circle)).build());
        }

        public Builder boundingBox(Collection<Double> var1);

        public Builder boundingBox(Double ... var1);

        public Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> var1);

        public Builder polygon(Collection<? extends Collection<Double>> ... var1);
    }
}

