/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointConfiguration> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(EndpointConfiguration.getter(EndpointConfiguration::endpointId)).setter(EndpointConfiguration.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Weight").getter(EndpointConfiguration.getter(EndpointConfiguration::weight)).setter(EndpointConfiguration.setter(Builder::weight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()}).build();
    private static final SdkField<Boolean> CLIENT_IP_PRESERVATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ClientIPPreservationEnabled").getter(EndpointConfiguration.getter(EndpointConfiguration::clientIPPreservationEnabled)).setter(EndpointConfiguration.setter(Builder::clientIPPreservationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIPPreservationEnabled").build()}).build();
    private static final SdkField<String> ATTACHMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentArn").getter(EndpointConfiguration.getter(EndpointConfiguration::attachmentArn)).setter(EndpointConfiguration.setter(Builder::attachmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD, WEIGHT_FIELD, CLIENT_IP_PRESERVATION_ENABLED_FIELD, ATTACHMENT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EndpointConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String endpointId;
    private final Integer weight;
    private final Boolean clientIPPreservationEnabled;
    private final String attachmentArn;

    private EndpointConfiguration(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.weight = builder.weight;
        this.clientIPPreservationEnabled = builder.clientIPPreservationEnabled;
        this.attachmentArn = builder.attachmentArn;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final Integer weight() {
        return this.weight;
    }

    public final Boolean clientIPPreservationEnabled() {
        return this.clientIPPreservationEnabled;
    }

    public final String attachmentArn() {
        return this.attachmentArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientIPPreservationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointConfiguration)) {
            return false;
        }
        EndpointConfiguration other = (EndpointConfiguration)obj;
        return Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.weight(), other.weight()) && Objects.equals(this.clientIPPreservationEnabled(), other.clientIPPreservationEnabled()) && Objects.equals(this.attachmentArn(), other.attachmentArn());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointConfiguration").add("EndpointId", (Object)this.endpointId()).add("Weight", (Object)this.weight()).add("ClientIPPreservationEnabled", (Object)this.clientIPPreservationEnabled()).add("AttachmentArn", (Object)this.attachmentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "Weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
            case "ClientIPPreservationEnabled": {
                return Optional.ofNullable(clazz.cast(this.clientIPPreservationEnabled()));
            }
            case "AttachmentArn": {
                return Optional.ofNullable(clazz.cast(this.attachmentArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("Weight", WEIGHT_FIELD);
        map.put("ClientIPPreservationEnabled", CLIENT_IP_PRESERVATION_ENABLED_FIELD);
        map.put("AttachmentArn", ATTACHMENT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointConfiguration, T> g) {
        return obj -> g.apply((EndpointConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointId;
        private Integer weight;
        private Boolean clientIPPreservationEnabled;
        private String attachmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointConfiguration model) {
            this.endpointId(model.endpointId);
            this.weight(model.weight);
            this.clientIPPreservationEnabled(model.clientIPPreservationEnabled);
            this.attachmentArn(model.attachmentArn);
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final Integer getWeight() {
            return this.weight;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public final Boolean getClientIPPreservationEnabled() {
            return this.clientIPPreservationEnabled;
        }

        public final void setClientIPPreservationEnabled(Boolean clientIPPreservationEnabled) {
            this.clientIPPreservationEnabled = clientIPPreservationEnabled;
        }

        @Override
        public final Builder clientIPPreservationEnabled(Boolean clientIPPreservationEnabled) {
            this.clientIPPreservationEnabled = clientIPPreservationEnabled;
            return this;
        }

        public final String getAttachmentArn() {
            return this.attachmentArn;
        }

        public final void setAttachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
        }

        @Override
        public final Builder attachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
            return this;
        }

        public EndpointConfiguration build() {
            return new EndpointConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointConfiguration> {
        public Builder endpointId(String var1);

        public Builder weight(Integer var1);

        public Builder clientIPPreservationEnabled(Boolean var1);

        public Builder attachmentArn(String var1);
    }
}

