/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a transform that removes columns from the dataset if all values in the column are 'null'. By default, Glue
 * Studio will recognize null objects, but some values such as empty strings, strings that are "null", -1 integers or
 * other placeholders such as zeros, are not automatically recognized as nulls.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DropNullFields implements SdkPojo, Serializable, ToCopyableBuilder<DropNullFields.Builder, DropNullFields> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DropNullFields::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(DropNullFields::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<NullCheckBoxList> NULL_CHECK_BOX_LIST_FIELD = SdkField
            .<NullCheckBoxList> builder(MarshallingType.SDK_POJO).memberName("NullCheckBoxList")
            .getter(getter(DropNullFields::nullCheckBoxList)).setter(setter(Builder::nullCheckBoxList))
            .constructor(NullCheckBoxList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullCheckBoxList").build()).build();

    private static final SdkField<List<NullValueField>> NULL_TEXT_LIST_FIELD = SdkField
            .<List<NullValueField>> builder(MarshallingType.LIST)
            .memberName("NullTextList")
            .getter(getter(DropNullFields::nullTextList))
            .setter(setter(Builder::nullTextList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullTextList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NullValueField> builder(MarshallingType.SDK_POJO)
                                            .constructor(NullValueField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            NULL_CHECK_BOX_LIST_FIELD, NULL_TEXT_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final NullCheckBoxList nullCheckBoxList;

    private final List<NullValueField> nullTextList;

    private DropNullFields(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.nullCheckBoxList = builder.nullCheckBoxList;
        this.nullTextList = builder.nullTextList;
    }

    /**
     * <p>
     * The name of the transform node.
     * </p>
     * 
     * @return The name of the transform node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data inputs identified by their node names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The data inputs identified by their node names.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * A structure that represents whether certain values are recognized as null values for removal.
     * </p>
     * 
     * @return A structure that represents whether certain values are recognized as null values for removal.
     */
    public final NullCheckBoxList nullCheckBoxList() {
        return nullCheckBoxList;
    }

    /**
     * For responses, this returns true if the service returned a value for the NullTextList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNullTextList() {
        return nullTextList != null && !(nullTextList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that specifies a list of NullValueField structures that represent a custom null value such as zero or
     * other value being used as a null placeholder unique to the dataset.
     * </p>
     * <p>
     * The <code>DropNullFields</code> transform removes custom null values only if both the value of the null
     * placeholder and the datatype match the data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNullTextList} method.
     * </p>
     * 
     * @return A structure that specifies a list of NullValueField structures that represent a custom null value such as
     *         zero or other value being used as a null placeholder unique to the dataset.</p>
     *         <p>
     *         The <code>DropNullFields</code> transform removes custom null values only if both the value of the null
     *         placeholder and the datatype match the data.
     */
    public final List<NullValueField> nullTextList() {
        return nullTextList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nullCheckBoxList());
        hashCode = 31 * hashCode + Objects.hashCode(hasNullTextList() ? nullTextList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DropNullFields)) {
            return false;
        }
        DropNullFields other = (DropNullFields) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(nullCheckBoxList(), other.nullCheckBoxList())
                && hasNullTextList() == other.hasNullTextList() && Objects.equals(nullTextList(), other.nullTextList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DropNullFields").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("NullCheckBoxList", nullCheckBoxList()).add("NullTextList", hasNullTextList() ? nullTextList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "NullCheckBoxList":
            return Optional.ofNullable(clazz.cast(nullCheckBoxList()));
        case "NullTextList":
            return Optional.ofNullable(clazz.cast(nullTextList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DropNullFields, T> g) {
        return obj -> g.apply((DropNullFields) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DropNullFields> {
        /**
         * <p>
         * The name of the transform node.
         * </p>
         * 
         * @param name
         *        The name of the transform node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * A structure that represents whether certain values are recognized as null values for removal.
         * </p>
         * 
         * @param nullCheckBoxList
         *        A structure that represents whether certain values are recognized as null values for removal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullCheckBoxList(NullCheckBoxList nullCheckBoxList);

        /**
         * <p>
         * A structure that represents whether certain values are recognized as null values for removal.
         * </p>
         * This is a convenience method that creates an instance of the {@link NullCheckBoxList.Builder} avoiding the
         * need to create one manually via {@link NullCheckBoxList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NullCheckBoxList.Builder#build()} is called immediately and its
         * result is passed to {@link #nullCheckBoxList(NullCheckBoxList)}.
         * 
         * @param nullCheckBoxList
         *        a consumer that will call methods on {@link NullCheckBoxList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nullCheckBoxList(NullCheckBoxList)
         */
        default Builder nullCheckBoxList(Consumer<NullCheckBoxList.Builder> nullCheckBoxList) {
            return nullCheckBoxList(NullCheckBoxList.builder().applyMutation(nullCheckBoxList).build());
        }

        /**
         * <p>
         * A structure that specifies a list of NullValueField structures that represent a custom null value such as
         * zero or other value being used as a null placeholder unique to the dataset.
         * </p>
         * <p>
         * The <code>DropNullFields</code> transform removes custom null values only if both the value of the null
         * placeholder and the datatype match the data.
         * </p>
         * 
         * @param nullTextList
         *        A structure that specifies a list of NullValueField structures that represent a custom null value such
         *        as zero or other value being used as a null placeholder unique to the dataset.</p>
         *        <p>
         *        The <code>DropNullFields</code> transform removes custom null values only if both the value of the
         *        null placeholder and the datatype match the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullTextList(Collection<NullValueField> nullTextList);

        /**
         * <p>
         * A structure that specifies a list of NullValueField structures that represent a custom null value such as
         * zero or other value being used as a null placeholder unique to the dataset.
         * </p>
         * <p>
         * The <code>DropNullFields</code> transform removes custom null values only if both the value of the null
         * placeholder and the datatype match the data.
         * </p>
         * 
         * @param nullTextList
         *        A structure that specifies a list of NullValueField structures that represent a custom null value such
         *        as zero or other value being used as a null placeholder unique to the dataset.</p>
         *        <p>
         *        The <code>DropNullFields</code> transform removes custom null values only if both the value of the
         *        null placeholder and the datatype match the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullTextList(NullValueField... nullTextList);

        /**
         * <p>
         * A structure that specifies a list of NullValueField structures that represent a custom null value such as
         * zero or other value being used as a null placeholder unique to the dataset.
         * </p>
         * <p>
         * The <code>DropNullFields</code> transform removes custom null values only if both the value of the null
         * placeholder and the datatype match the data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.NullValueField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.NullValueField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.NullValueField.Builder#build()} is called immediately and
         * its result is passed to {@link #nullTextList(List<NullValueField>)}.
         * 
         * @param nullTextList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.NullValueField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nullTextList(java.util.Collection<NullValueField>)
         */
        Builder nullTextList(Consumer<NullValueField.Builder>... nullTextList);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private NullCheckBoxList nullCheckBoxList;

        private List<NullValueField> nullTextList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DropNullFields model) {
            name(model.name);
            inputs(model.inputs);
            nullCheckBoxList(model.nullCheckBoxList);
            nullTextList(model.nullTextList);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final NullCheckBoxList.Builder getNullCheckBoxList() {
            return nullCheckBoxList != null ? nullCheckBoxList.toBuilder() : null;
        }

        public final void setNullCheckBoxList(NullCheckBoxList.BuilderImpl nullCheckBoxList) {
            this.nullCheckBoxList = nullCheckBoxList != null ? nullCheckBoxList.build() : null;
        }

        @Override
        public final Builder nullCheckBoxList(NullCheckBoxList nullCheckBoxList) {
            this.nullCheckBoxList = nullCheckBoxList;
            return this;
        }

        public final List<NullValueField.Builder> getNullTextList() {
            List<NullValueField.Builder> result = NullValueFieldsCopier.copyToBuilder(this.nullTextList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNullTextList(Collection<NullValueField.BuilderImpl> nullTextList) {
            this.nullTextList = NullValueFieldsCopier.copyFromBuilder(nullTextList);
        }

        @Override
        public final Builder nullTextList(Collection<NullValueField> nullTextList) {
            this.nullTextList = NullValueFieldsCopier.copy(nullTextList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nullTextList(NullValueField... nullTextList) {
            nullTextList(Arrays.asList(nullTextList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nullTextList(Consumer<NullValueField.Builder>... nullTextList) {
            nullTextList(Stream.of(nullTextList).map(c -> NullValueField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DropNullFields build() {
            return new DropNullFields(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
