/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveSchemaVersionMetadataResponse extends GlueResponse implements
        ToCopyableBuilder<RemoveSchemaVersionMetadataResponse.Builder, RemoveSchemaVersionMetadataResponse> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(RemoveSchemaVersionMetadataResponse::schemaArn))
            .setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(RemoveSchemaVersionMetadataResponse::schemaName))
            .setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryName").getter(getter(RemoveSchemaVersionMetadataResponse::registryName))
            .setter(setter(Builder::registryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryName").build()).build();

    private static final SdkField<Boolean> LATEST_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("LatestVersion").getter(getter(RemoveSchemaVersionMetadataResponse::latestVersion))
            .setter(setter(Builder::latestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(RemoveSchemaVersionMetadataResponse::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersionId").getter(getter(RemoveSchemaVersionMetadataResponse::schemaVersionId))
            .setter(setter(Builder::schemaVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()).build();

    private static final SdkField<String> METADATA_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataKey").getter(getter(RemoveSchemaVersionMetadataResponse::metadataKey))
            .setter(setter(Builder::metadataKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataKey").build()).build();

    private static final SdkField<String> METADATA_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataValue").getter(getter(RemoveSchemaVersionMetadataResponse::metadataValue))
            .setter(setter(Builder::metadataValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD,
            SCHEMA_NAME_FIELD, REGISTRY_NAME_FIELD, LATEST_VERSION_FIELD, VERSION_NUMBER_FIELD, SCHEMA_VERSION_ID_FIELD,
            METADATA_KEY_FIELD, METADATA_VALUE_FIELD));

    private final String schemaArn;

    private final String schemaName;

    private final String registryName;

    private final Boolean latestVersion;

    private final Long versionNumber;

    private final String schemaVersionId;

    private final String metadataKey;

    private final String metadataValue;

    private RemoveSchemaVersionMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.schemaArn = builder.schemaArn;
        this.schemaName = builder.schemaName;
        this.registryName = builder.registryName;
        this.latestVersion = builder.latestVersion;
        this.versionNumber = builder.versionNumber;
        this.schemaVersionId = builder.schemaVersionId;
        this.metadataKey = builder.metadataKey;
        this.metadataValue = builder.metadataValue;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the schema.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the schema.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The name of the schema.
     * </p>
     * 
     * @return The name of the schema.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The name of the registry.
     * </p>
     * 
     * @return The name of the registry.
     */
    public final String registryName() {
        return registryName;
    }

    /**
     * <p>
     * The latest version of the schema.
     * </p>
     * 
     * @return The latest version of the schema.
     */
    public final Boolean latestVersion() {
        return latestVersion;
    }

    /**
     * <p>
     * The version number of the schema.
     * </p>
     * 
     * @return The version number of the schema.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The version ID for the schema version.
     * </p>
     * 
     * @return The version ID for the schema version.
     */
    public final String schemaVersionId() {
        return schemaVersionId;
    }

    /**
     * <p>
     * The metadata key.
     * </p>
     * 
     * @return The metadata key.
     */
    public final String metadataKey() {
        return metadataKey;
    }

    /**
     * <p>
     * The value of the metadata key.
     * </p>
     * 
     * @return The value of the metadata key.
     */
    public final String metadataValue() {
        return metadataValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(registryName());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(metadataKey());
        hashCode = 31 * hashCode + Objects.hashCode(metadataValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveSchemaVersionMetadataResponse)) {
            return false;
        }
        RemoveSchemaVersionMetadataResponse other = (RemoveSchemaVersionMetadataResponse) obj;
        return Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(schemaName(), other.schemaName())
                && Objects.equals(registryName(), other.registryName()) && Objects.equals(latestVersion(), other.latestVersion())
                && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(schemaVersionId(), other.schemaVersionId())
                && Objects.equals(metadataKey(), other.metadataKey()) && Objects.equals(metadataValue(), other.metadataValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveSchemaVersionMetadataResponse").add("SchemaArn", schemaArn())
                .add("SchemaName", schemaName()).add("RegistryName", registryName()).add("LatestVersion", latestVersion())
                .add("VersionNumber", versionNumber()).add("SchemaVersionId", schemaVersionId())
                .add("MetadataKey", metadataKey()).add("MetadataValue", metadataValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "RegistryName":
            return Optional.ofNullable(clazz.cast(registryName()));
        case "LatestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "SchemaVersionId":
            return Optional.ofNullable(clazz.cast(schemaVersionId()));
        case "MetadataKey":
            return Optional.ofNullable(clazz.cast(metadataKey()));
        case "MetadataValue":
            return Optional.ofNullable(clazz.cast(metadataValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveSchemaVersionMetadataResponse, T> g) {
        return obj -> g.apply((RemoveSchemaVersionMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, RemoveSchemaVersionMetadataResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the schema.
         * </p>
         * 
         * @param schemaArn
         *        The Amazon Resource Name (ARN) of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The name of the schema.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The name of the registry.
         * </p>
         * 
         * @param registryName
         *        The name of the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryName(String registryName);

        /**
         * <p>
         * The latest version of the schema.
         * </p>
         * 
         * @param latestVersion
         *        The latest version of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(Boolean latestVersion);

        /**
         * <p>
         * The version number of the schema.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The version ID for the schema version.
         * </p>
         * 
         * @param schemaVersionId
         *        The version ID for the schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionId(String schemaVersionId);

        /**
         * <p>
         * The metadata key.
         * </p>
         * 
         * @param metadataKey
         *        The metadata key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataKey(String metadataKey);

        /**
         * <p>
         * The value of the metadata key.
         * </p>
         * 
         * @param metadataValue
         *        The value of the metadata key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataValue(String metadataValue);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String schemaArn;

        private String schemaName;

        private String registryName;

        private Boolean latestVersion;

        private Long versionNumber;

        private String schemaVersionId;

        private String metadataKey;

        private String metadataValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveSchemaVersionMetadataResponse model) {
            super(model);
            schemaArn(model.schemaArn);
            schemaName(model.schemaName);
            registryName(model.registryName);
            latestVersion(model.latestVersion);
            versionNumber(model.versionNumber);
            schemaVersionId(model.schemaVersionId);
            metadataKey(model.metadataKey);
            metadataValue(model.metadataValue);
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getRegistryName() {
            return registryName;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final Boolean getLatestVersion() {
            return latestVersion;
        }

        public final void setLatestVersion(Boolean latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(Boolean latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getSchemaVersionId() {
            return schemaVersionId;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final String getMetadataKey() {
            return metadataKey;
        }

        public final void setMetadataKey(String metadataKey) {
            this.metadataKey = metadataKey;
        }

        @Override
        public final Builder metadataKey(String metadataKey) {
            this.metadataKey = metadataKey;
            return this;
        }

        public final String getMetadataValue() {
            return metadataValue;
        }

        public final void setMetadataValue(String metadataValue) {
            this.metadataValue = metadataValue;
        }

        @Override
        public final Builder metadataValue(String metadataValue) {
            this.metadataValue = metadataValue;
            return this;
        }

        @Override
        public RemoveSchemaVersionMetadataResponse build() {
            return new RemoveSchemaVersionMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
