/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Comparator {
    EQUALS("EQUALS"),
    GREATER_THAN("GREATER_THAN"),
    LESS_THAN("LESS_THAN"),
    GREATER_THAN_EQUALS("GREATER_THAN_EQUALS"),
    LESS_THAN_EQUALS("LESS_THAN_EQUALS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Comparator> VALUE_MAP;
    private final String value;

    private Comparator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Comparator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Comparator> knownValues() {
        EnumSet<Comparator> knownValues = EnumSet.allOf(Comparator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Comparator.class, Comparator::toString);
    }
}

