/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a target that uses a Glue Data Catalog table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BasicCatalogTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<BasicCatalogTarget.Builder, BasicCatalogTarget> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(BasicCatalogTarget::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(BasicCatalogTarget::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<List<String>>> PARTITION_KEYS_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("PartitionKeys")
            .getter(getter(BasicCatalogTarget::partitionKeys))
            .setter(setter(Builder::partitionKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(BasicCatalogTarget::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(BasicCatalogTarget::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            PARTITION_KEYS_FIELD, DATABASE_FIELD, TABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("Inputs", INPUTS_FIELD);
                    put("PartitionKeys", PARTITION_KEYS_FIELD);
                    put("Database", DATABASE_FIELD);
                    put("Table", TABLE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final List<List<String>> partitionKeys;

    private final String database;

    private final String table;

    private BasicCatalogTarget(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.partitionKeys = builder.partitionKeys;
        this.database = builder.database;
        this.table = builder.table;
    }

    /**
     * <p>
     * The name of your data target.
     * </p>
     * 
     * @return The name of your data target.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The nodes that are inputs to the data target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The nodes that are inputs to the data target.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionKeys() {
        return partitionKeys != null && !(partitionKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The partition keys used to distribute data across multiple partitions or shards based on a specific key or set of
     * key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionKeys} method.
     * </p>
     * 
     * @return The partition keys used to distribute data across multiple partitions or shards based on a specific key
     *         or set of key.
     */
    public final List<List<String>> partitionKeys() {
        return partitionKeys;
    }

    /**
     * <p>
     * The database that contains the table you want to use as the target. This database must already exist in the Data
     * Catalog.
     * </p>
     * 
     * @return The database that contains the table you want to use as the target. This database must already exist in
     *         the Data Catalog.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The table that defines the schema of your output data. This table must already exist in the Data Catalog.
     * </p>
     * 
     * @return The table that defines the schema of your output data. This table must already exist in the Data Catalog.
     */
    public final String table() {
        return table;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionKeys() ? partitionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasicCatalogTarget)) {
            return false;
        }
        BasicCatalogTarget other = (BasicCatalogTarget) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && hasPartitionKeys() == other.hasPartitionKeys()
                && Objects.equals(partitionKeys(), other.partitionKeys()) && Objects.equals(database(), other.database())
                && Objects.equals(table(), other.table());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BasicCatalogTarget").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("PartitionKeys", hasPartitionKeys() ? partitionKeys() : null).add("Database", database())
                .add("Table", table()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "PartitionKeys":
            return Optional.ofNullable(clazz.cast(partitionKeys()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BasicCatalogTarget, T> g) {
        return obj -> g.apply((BasicCatalogTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BasicCatalogTarget> {
        /**
         * <p>
         * The name of your data target.
         * </p>
         * 
         * @param name
         *        The name of your data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The nodes that are inputs to the data target.
         * </p>
         * 
         * @param inputs
         *        The nodes that are inputs to the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The nodes that are inputs to the data target.
         * </p>
         * 
         * @param inputs
         *        The nodes that are inputs to the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * The partition keys used to distribute data across multiple partitions or shards based on a specific key or
         * set of key.
         * </p>
         * 
         * @param partitionKeys
         *        The partition keys used to distribute data across multiple partitions or shards based on a specific
         *        key or set of key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(Collection<? extends Collection<String>> partitionKeys);

        /**
         * <p>
         * The partition keys used to distribute data across multiple partitions or shards based on a specific key or
         * set of key.
         * </p>
         * 
         * @param partitionKeys
         *        The partition keys used to distribute data across multiple partitions or shards based on a specific
         *        key or set of key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(Collection<String>... partitionKeys);

        /**
         * <p>
         * The database that contains the table you want to use as the target. This database must already exist in the
         * Data Catalog.
         * </p>
         * 
         * @param database
         *        The database that contains the table you want to use as the target. This database must already exist
         *        in the Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The table that defines the schema of your output data. This table must already exist in the Data Catalog.
         * </p>
         * 
         * @param table
         *        The table that defines the schema of your output data. This table must already exist in the Data
         *        Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private List<List<String>> partitionKeys = DefaultSdkAutoConstructList.getInstance();

        private String database;

        private String table;

        private BuilderImpl() {
        }

        private BuilderImpl(BasicCatalogTarget model) {
            name(model.name);
            inputs(model.inputs);
            partitionKeys(model.partitionKeys);
            database(model.database);
            table(model.table);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final Collection<? extends Collection<String>> getPartitionKeys() {
            if (partitionKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return partitionKeys;
        }

        public final void setPartitionKeys(Collection<? extends Collection<String>> partitionKeys) {
            this.partitionKeys = GlueStudioPathListCopier.copy(partitionKeys);
        }

        @Override
        public final Builder partitionKeys(Collection<? extends Collection<String>> partitionKeys) {
            this.partitionKeys = GlueStudioPathListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Collection<String>... partitionKeys) {
            partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        @Override
        public BasicCatalogTarget build() {
            return new BasicCatalogTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
