/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes catalog properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CatalogInput implements SdkPojo, Serializable, ToCopyableBuilder<CatalogInput.Builder, CatalogInput> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CatalogInput::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<FederatedCatalog> FEDERATED_CATALOG_FIELD = SdkField
            .<FederatedCatalog> builder(MarshallingType.SDK_POJO).memberName("FederatedCatalog")
            .getter(getter(CatalogInput::federatedCatalog)).setter(setter(Builder::federatedCatalog))
            .constructor(FederatedCatalog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederatedCatalog").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(CatalogInput::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<TargetRedshiftCatalog> TARGET_REDSHIFT_CATALOG_FIELD = SdkField
            .<TargetRedshiftCatalog> builder(MarshallingType.SDK_POJO).memberName("TargetRedshiftCatalog")
            .getter(getter(CatalogInput::targetRedshiftCatalog)).setter(setter(Builder::targetRedshiftCatalog))
            .constructor(TargetRedshiftCatalog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetRedshiftCatalog").build())
            .build();

    private static final SdkField<CatalogProperties> CATALOG_PROPERTIES_FIELD = SdkField
            .<CatalogProperties> builder(MarshallingType.SDK_POJO).memberName("CatalogProperties")
            .getter(getter(CatalogInput::catalogProperties)).setter(setter(Builder::catalogProperties))
            .constructor(CatalogProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogProperties").build()).build();

    private static final SdkField<List<PrincipalPermissions>> CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD = SdkField
            .<List<PrincipalPermissions>> builder(MarshallingType.LIST)
            .memberName("CreateTableDefaultPermissions")
            .getter(getter(CatalogInput::createTableDefaultPermissions))
            .setter(setter(Builder::createTableDefaultPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTableDefaultPermissions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalPermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalPermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PrincipalPermissions>> CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD = SdkField
            .<List<PrincipalPermissions>> builder(MarshallingType.LIST)
            .memberName("CreateDatabaseDefaultPermissions")
            .getter(getter(CatalogInput::createDatabaseDefaultPermissions))
            .setter(setter(Builder::createDatabaseDefaultPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDatabaseDefaultPermissions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalPermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalPermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            FEDERATED_CATALOG_FIELD, PARAMETERS_FIELD, TARGET_REDSHIFT_CATALOG_FIELD, CATALOG_PROPERTIES_FIELD,
            CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD, CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Description", DESCRIPTION_FIELD);
                    put("FederatedCatalog", FEDERATED_CATALOG_FIELD);
                    put("Parameters", PARAMETERS_FIELD);
                    put("TargetRedshiftCatalog", TARGET_REDSHIFT_CATALOG_FIELD);
                    put("CatalogProperties", CATALOG_PROPERTIES_FIELD);
                    put("CreateTableDefaultPermissions", CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD);
                    put("CreateDatabaseDefaultPermissions", CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String description;

    private final FederatedCatalog federatedCatalog;

    private final Map<String, String> parameters;

    private final TargetRedshiftCatalog targetRedshiftCatalog;

    private final CatalogProperties catalogProperties;

    private final List<PrincipalPermissions> createTableDefaultPermissions;

    private final List<PrincipalPermissions> createDatabaseDefaultPermissions;

    private CatalogInput(BuilderImpl builder) {
        this.description = builder.description;
        this.federatedCatalog = builder.federatedCatalog;
        this.parameters = builder.parameters;
        this.targetRedshiftCatalog = builder.targetRedshiftCatalog;
        this.catalogProperties = builder.catalogProperties;
        this.createTableDefaultPermissions = builder.createTableDefaultPermissions;
        this.createDatabaseDefaultPermissions = builder.createDatabaseDefaultPermissions;
    }

    /**
     * <p>
     * Description string, not more than 2048 bytes long, matching the URI address multi-line string pattern. A
     * description of the catalog.
     * </p>
     * 
     * @return Description string, not more than 2048 bytes long, matching the URI address multi-line string pattern. A
     *         description of the catalog.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A <code>FederatedCatalog</code> object. A <code>FederatedCatalog</code> structure that references an entity
     * outside the Glue Data Catalog, for example a Redshift database.
     * </p>
     * 
     * @return A <code>FederatedCatalog</code> object. A <code>FederatedCatalog</code> structure that references an
     *         entity outside the Glue Data Catalog, for example a Redshift database.
     */
    public final FederatedCatalog federatedCatalog() {
        return federatedCatalog;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map array of key-value pairs that define the parameters and properties of the catalog.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A map array of key-value pairs that define the parameters and properties of the catalog.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * A <code>TargetRedshiftCatalog</code> object that describes a target catalog for resource linking.
     * </p>
     * 
     * @return A <code>TargetRedshiftCatalog</code> object that describes a target catalog for resource linking.
     */
    public final TargetRedshiftCatalog targetRedshiftCatalog() {
        return targetRedshiftCatalog;
    }

    /**
     * <p>
     * A <code>CatalogProperties</code> object that specifies data lake access properties and other custom properties.
     * </p>
     * 
     * @return A <code>CatalogProperties</code> object that specifies data lake access properties and other custom
     *         properties.
     */
    public final CatalogProperties catalogProperties() {
        return catalogProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreateTableDefaultPermissions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCreateTableDefaultPermissions() {
        return createTableDefaultPermissions != null && !(createTableDefaultPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the table(s) for
     * principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly set as an empty list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreateTableDefaultPermissions} method.
     * </p>
     * 
     * @return An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the
     *         table(s) for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly set
     *         as an empty list.
     */
    public final List<PrincipalPermissions> createTableDefaultPermissions() {
        return createTableDefaultPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreateDatabaseDefaultPermissions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCreateDatabaseDefaultPermissions() {
        return createDatabaseDefaultPermissions != null && !(createDatabaseDefaultPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the database(s)
     * for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly set as an empty list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreateDatabaseDefaultPermissions}
     * method.
     * </p>
     * 
     * @return An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the
     *         database(s) for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly
     *         set as an empty list.
     */
    public final List<PrincipalPermissions> createDatabaseDefaultPermissions() {
        return createDatabaseDefaultPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(federatedCatalog());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetRedshiftCatalog());
        hashCode = 31 * hashCode + Objects.hashCode(catalogProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasCreateTableDefaultPermissions() ? createTableDefaultPermissions() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCreateDatabaseDefaultPermissions() ? createDatabaseDefaultPermissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogInput)) {
            return false;
        }
        CatalogInput other = (CatalogInput) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(federatedCatalog(), other.federatedCatalog())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(targetRedshiftCatalog(), other.targetRedshiftCatalog())
                && Objects.equals(catalogProperties(), other.catalogProperties())
                && hasCreateTableDefaultPermissions() == other.hasCreateTableDefaultPermissions()
                && Objects.equals(createTableDefaultPermissions(), other.createTableDefaultPermissions())
                && hasCreateDatabaseDefaultPermissions() == other.hasCreateDatabaseDefaultPermissions()
                && Objects.equals(createDatabaseDefaultPermissions(), other.createDatabaseDefaultPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CatalogInput")
                .add("Description", description())
                .add("FederatedCatalog", federatedCatalog())
                .add("Parameters", hasParameters() ? parameters() : null)
                .add("TargetRedshiftCatalog", targetRedshiftCatalog())
                .add("CatalogProperties", catalogProperties())
                .add("CreateTableDefaultPermissions", hasCreateTableDefaultPermissions() ? createTableDefaultPermissions() : null)
                .add("CreateDatabaseDefaultPermissions",
                        hasCreateDatabaseDefaultPermissions() ? createDatabaseDefaultPermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FederatedCatalog":
            return Optional.ofNullable(clazz.cast(federatedCatalog()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "TargetRedshiftCatalog":
            return Optional.ofNullable(clazz.cast(targetRedshiftCatalog()));
        case "CatalogProperties":
            return Optional.ofNullable(clazz.cast(catalogProperties()));
        case "CreateTableDefaultPermissions":
            return Optional.ofNullable(clazz.cast(createTableDefaultPermissions()));
        case "CreateDatabaseDefaultPermissions":
            return Optional.ofNullable(clazz.cast(createDatabaseDefaultPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CatalogInput, T> g) {
        return obj -> g.apply((CatalogInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CatalogInput> {
        /**
         * <p>
         * Description string, not more than 2048 bytes long, matching the URI address multi-line string pattern. A
         * description of the catalog.
         * </p>
         * 
         * @param description
         *        Description string, not more than 2048 bytes long, matching the URI address multi-line string pattern.
         *        A description of the catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A <code>FederatedCatalog</code> object. A <code>FederatedCatalog</code> structure that references an entity
         * outside the Glue Data Catalog, for example a Redshift database.
         * </p>
         * 
         * @param federatedCatalog
         *        A <code>FederatedCatalog</code> object. A <code>FederatedCatalog</code> structure that references an
         *        entity outside the Glue Data Catalog, for example a Redshift database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federatedCatalog(FederatedCatalog federatedCatalog);

        /**
         * <p>
         * A <code>FederatedCatalog</code> object. A <code>FederatedCatalog</code> structure that references an entity
         * outside the Glue Data Catalog, for example a Redshift database.
         * </p>
         * This is a convenience method that creates an instance of the {@link FederatedCatalog.Builder} avoiding the
         * need to create one manually via {@link FederatedCatalog#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FederatedCatalog.Builder#build()} is called immediately and its
         * result is passed to {@link #federatedCatalog(FederatedCatalog)}.
         * 
         * @param federatedCatalog
         *        a consumer that will call methods on {@link FederatedCatalog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #federatedCatalog(FederatedCatalog)
         */
        default Builder federatedCatalog(Consumer<FederatedCatalog.Builder> federatedCatalog) {
            return federatedCatalog(FederatedCatalog.builder().applyMutation(federatedCatalog).build());
        }

        /**
         * <p>
         * A map array of key-value pairs that define the parameters and properties of the catalog.
         * </p>
         * 
         * @param parameters
         *        A map array of key-value pairs that define the parameters and properties of the catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * A <code>TargetRedshiftCatalog</code> object that describes a target catalog for resource linking.
         * </p>
         * 
         * @param targetRedshiftCatalog
         *        A <code>TargetRedshiftCatalog</code> object that describes a target catalog for resource linking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRedshiftCatalog(TargetRedshiftCatalog targetRedshiftCatalog);

        /**
         * <p>
         * A <code>TargetRedshiftCatalog</code> object that describes a target catalog for resource linking.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetRedshiftCatalog.Builder} avoiding
         * the need to create one manually via {@link TargetRedshiftCatalog#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetRedshiftCatalog.Builder#build()} is called immediately and
         * its result is passed to {@link #targetRedshiftCatalog(TargetRedshiftCatalog)}.
         * 
         * @param targetRedshiftCatalog
         *        a consumer that will call methods on {@link TargetRedshiftCatalog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetRedshiftCatalog(TargetRedshiftCatalog)
         */
        default Builder targetRedshiftCatalog(Consumer<TargetRedshiftCatalog.Builder> targetRedshiftCatalog) {
            return targetRedshiftCatalog(TargetRedshiftCatalog.builder().applyMutation(targetRedshiftCatalog).build());
        }

        /**
         * <p>
         * A <code>CatalogProperties</code> object that specifies data lake access properties and other custom
         * properties.
         * </p>
         * 
         * @param catalogProperties
         *        A <code>CatalogProperties</code> object that specifies data lake access properties and other custom
         *        properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogProperties(CatalogProperties catalogProperties);

        /**
         * <p>
         * A <code>CatalogProperties</code> object that specifies data lake access properties and other custom
         * properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link CatalogProperties.Builder} avoiding the
         * need to create one manually via {@link CatalogProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CatalogProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #catalogProperties(CatalogProperties)}.
         * 
         * @param catalogProperties
         *        a consumer that will call methods on {@link CatalogProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogProperties(CatalogProperties)
         */
        default Builder catalogProperties(Consumer<CatalogProperties.Builder> catalogProperties) {
            return catalogProperties(CatalogProperties.builder().applyMutation(catalogProperties).build());
        }

        /**
         * <p>
         * An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the table(s)
         * for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly set as an empty
         * list.
         * </p>
         * 
         * @param createTableDefaultPermissions
         *        An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the
         *        table(s) for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly
         *        set as an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions);

        /**
         * <p>
         * An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the table(s)
         * for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly set as an empty
         * list.
         * </p>
         * 
         * @param createTableDefaultPermissions
         *        An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the
         *        table(s) for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly
         *        set as an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTableDefaultPermissions(PrincipalPermissions... createTableDefaultPermissions);

        /**
         * <p>
         * An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the table(s)
         * for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly set as an empty
         * list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.PrincipalPermissions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.PrincipalPermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.PrincipalPermissions.Builder#build()} is called immediately
         * and its result is passed to {@link #createTableDefaultPermissions(List<PrincipalPermissions>)}.
         * 
         * @param createTableDefaultPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.PrincipalPermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createTableDefaultPermissions(java.util.Collection<PrincipalPermissions>)
         */
        Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder>... createTableDefaultPermissions);

        /**
         * <p>
         * An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the
         * database(s) for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly set as
         * an empty list.
         * </p>
         * 
         * @param createDatabaseDefaultPermissions
         *        An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the
         *        database(s) for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly
         *        set as an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> createDatabaseDefaultPermissions);

        /**
         * <p>
         * An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the
         * database(s) for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly set as
         * an empty list.
         * </p>
         * 
         * @param createDatabaseDefaultPermissions
         *        An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the
         *        database(s) for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly
         *        set as an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDatabaseDefaultPermissions(PrincipalPermissions... createDatabaseDefaultPermissions);

        /**
         * <p>
         * An array of <code>PrincipalPermissions</code> objects. Creates a set of default permissions on the
         * database(s) for principals. Used by Amazon Web Services Lake Formation. Typically should be explicitly set as
         * an empty list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.PrincipalPermissions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.PrincipalPermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.PrincipalPermissions.Builder#build()} is called immediately
         * and its result is passed to {@link #createDatabaseDefaultPermissions(List<PrincipalPermissions>)}.
         * 
         * @param createDatabaseDefaultPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.PrincipalPermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createDatabaseDefaultPermissions(java.util.Collection<PrincipalPermissions>)
         */
        Builder createDatabaseDefaultPermissions(Consumer<PrincipalPermissions.Builder>... createDatabaseDefaultPermissions);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private FederatedCatalog federatedCatalog;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private TargetRedshiftCatalog targetRedshiftCatalog;

        private CatalogProperties catalogProperties;

        private List<PrincipalPermissions> createTableDefaultPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<PrincipalPermissions> createDatabaseDefaultPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogInput model) {
            description(model.description);
            federatedCatalog(model.federatedCatalog);
            parameters(model.parameters);
            targetRedshiftCatalog(model.targetRedshiftCatalog);
            catalogProperties(model.catalogProperties);
            createTableDefaultPermissions(model.createTableDefaultPermissions);
            createDatabaseDefaultPermissions(model.createDatabaseDefaultPermissions);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final FederatedCatalog.Builder getFederatedCatalog() {
            return federatedCatalog != null ? federatedCatalog.toBuilder() : null;
        }

        public final void setFederatedCatalog(FederatedCatalog.BuilderImpl federatedCatalog) {
            this.federatedCatalog = federatedCatalog != null ? federatedCatalog.build() : null;
        }

        @Override
        public final Builder federatedCatalog(FederatedCatalog federatedCatalog) {
            this.federatedCatalog = federatedCatalog;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final TargetRedshiftCatalog.Builder getTargetRedshiftCatalog() {
            return targetRedshiftCatalog != null ? targetRedshiftCatalog.toBuilder() : null;
        }

        public final void setTargetRedshiftCatalog(TargetRedshiftCatalog.BuilderImpl targetRedshiftCatalog) {
            this.targetRedshiftCatalog = targetRedshiftCatalog != null ? targetRedshiftCatalog.build() : null;
        }

        @Override
        public final Builder targetRedshiftCatalog(TargetRedshiftCatalog targetRedshiftCatalog) {
            this.targetRedshiftCatalog = targetRedshiftCatalog;
            return this;
        }

        public final CatalogProperties.Builder getCatalogProperties() {
            return catalogProperties != null ? catalogProperties.toBuilder() : null;
        }

        public final void setCatalogProperties(CatalogProperties.BuilderImpl catalogProperties) {
            this.catalogProperties = catalogProperties != null ? catalogProperties.build() : null;
        }

        @Override
        public final Builder catalogProperties(CatalogProperties catalogProperties) {
            this.catalogProperties = catalogProperties;
            return this;
        }

        public final List<PrincipalPermissions.Builder> getCreateTableDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier
                    .copyToBuilder(this.createTableDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateTableDefaultPermissions(
                Collection<PrincipalPermissions.BuilderImpl> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createTableDefaultPermissions);
        }

        @Override
        public final Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copy(createTableDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(PrincipalPermissions... createTableDefaultPermissions) {
            createTableDefaultPermissions(Arrays.asList(createTableDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(
                Consumer<PrincipalPermissions.Builder>... createTableDefaultPermissions) {
            createTableDefaultPermissions(Stream.of(createTableDefaultPermissions)
                    .map(c -> PrincipalPermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PrincipalPermissions.Builder> getCreateDatabaseDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier
                    .copyToBuilder(this.createDatabaseDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateDatabaseDefaultPermissions(
                Collection<PrincipalPermissions.BuilderImpl> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier
                    .copyFromBuilder(createDatabaseDefaultPermissions);
        }

        @Override
        public final Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier.copy(createDatabaseDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(PrincipalPermissions... createDatabaseDefaultPermissions) {
            createDatabaseDefaultPermissions(Arrays.asList(createDatabaseDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(
                Consumer<PrincipalPermissions.Builder>... createDatabaseDefaultPermissions) {
            createDatabaseDefaultPermissions(Stream.of(createDatabaseDefaultPermissions)
                    .map(c -> PrincipalPermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CatalogInput build() {
            return new CatalogInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
